/* automatically generated by rust-bindgen 0.63.0 */

#![allow(nonstandard_style, clippy::all)]

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub type __off_t = cty::c_long;
pub type __off64_t = cty::c_long;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = cty::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct _IO_FILE {
    pub _flags: cty::c_int,
    pub _IO_read_ptr: *mut cty::c_char,
    pub _IO_read_end: *mut cty::c_char,
    pub _IO_read_base: *mut cty::c_char,
    pub _IO_write_base: *mut cty::c_char,
    pub _IO_write_ptr: *mut cty::c_char,
    pub _IO_write_end: *mut cty::c_char,
    pub _IO_buf_base: *mut cty::c_char,
    pub _IO_buf_end: *mut cty::c_char,
    pub _IO_save_base: *mut cty::c_char,
    pub _IO_backup_base: *mut cty::c_char,
    pub _IO_save_end: *mut cty::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: cty::c_int,
    pub _flags2: cty::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: cty::c_ushort,
    pub _vtable_offset: cty::c_schar,
    pub _shortbuf: [cty::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut cty::c_void,
    pub __pad5: usize,
    pub _mode: cty::c_int,
    pub _unused2: [cty::c_char; 20usize],
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImGuiDockRequest {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ImGuiDockNodeSettings {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_const_charPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *const cty::c_char,
}
impl Default for ImVector_const_charPtr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ImGuiCol = cty::c_int;
pub type ImGuiCond = cty::c_int;
pub type ImGuiDataType = cty::c_int;
pub type ImGuiDir = cty::c_int;
pub type ImGuiMouseButton = cty::c_int;
pub type ImGuiMouseCursor = cty::c_int;
pub type ImGuiSortDirection = cty::c_int;
pub type ImGuiStyleVar = cty::c_int;
pub type ImGuiTableBgTarget = cty::c_int;
pub type ImDrawFlags = cty::c_int;
pub type ImDrawListFlags = cty::c_int;
pub type ImFontAtlasFlags = cty::c_int;
pub type ImGuiBackendFlags = cty::c_int;
pub type ImGuiButtonFlags = cty::c_int;
pub type ImGuiColorEditFlags = cty::c_int;
pub type ImGuiConfigFlags = cty::c_int;
pub type ImGuiComboFlags = cty::c_int;
pub type ImGuiDockNodeFlags = cty::c_int;
pub type ImGuiDragDropFlags = cty::c_int;
pub type ImGuiFocusedFlags = cty::c_int;
pub type ImGuiHoveredFlags = cty::c_int;
pub type ImGuiInputTextFlags = cty::c_int;
pub type ImGuiKeyChord = cty::c_int;
pub type ImGuiPopupFlags = cty::c_int;
pub type ImGuiSelectableFlags = cty::c_int;
pub type ImGuiSliderFlags = cty::c_int;
pub type ImGuiTabBarFlags = cty::c_int;
pub type ImGuiTabItemFlags = cty::c_int;
pub type ImGuiTableFlags = cty::c_int;
pub type ImGuiTableColumnFlags = cty::c_int;
pub type ImGuiTableRowFlags = cty::c_int;
pub type ImGuiTreeNodeFlags = cty::c_int;
pub type ImGuiViewportFlags = cty::c_int;
pub type ImGuiWindowFlags = cty::c_int;
pub type ImTextureID = *mut cty::c_void;
pub type ImDrawIdx = cty::c_ushort;
pub type ImGuiID = cty::c_uint;
pub type ImS8 = cty::c_schar;
pub type ImU8 = cty::c_uchar;
pub type ImS16 = cty::c_short;
pub type ImU16 = cty::c_ushort;
pub type ImS32 = cty::c_int;
pub type ImU32 = cty::c_uint;
pub type ImS64 = cty::c_longlong;
pub type ImU64 = cty::c_ulonglong;
pub type ImWchar16 = cty::c_ushort;
pub type ImWchar32 = cty::c_uint;
pub type ImWchar = ImWchar32;
pub type ImGuiInputTextCallback = ::core::option::Option<
    unsafe extern "C" fn(data: *mut ImGuiInputTextCallbackData) -> cty::c_int,
>;
pub type ImGuiSizeCallback =
    ::core::option::Option<unsafe extern "C" fn(data: *mut ImGuiSizeCallbackData)>;
pub type ImGuiMemAllocFunc = ::core::option::Option<
    unsafe extern "C" fn(sz: usize, user_data: *mut cty::c_void) -> *mut cty::c_void,
>;
pub type ImGuiMemFreeFunc = ::core::option::Option<
    unsafe extern "C" fn(ptr: *mut cty::c_void, user_data: *mut cty::c_void),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImVec2 {
    pub x: f32,
    pub y: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImVec4 {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
pub const ImGuiWindowFlags_None: ImGuiWindowFlags_ = 0;
pub const ImGuiWindowFlags_NoTitleBar: ImGuiWindowFlags_ = 1;
pub const ImGuiWindowFlags_NoResize: ImGuiWindowFlags_ = 2;
pub const ImGuiWindowFlags_NoMove: ImGuiWindowFlags_ = 4;
pub const ImGuiWindowFlags_NoScrollbar: ImGuiWindowFlags_ = 8;
pub const ImGuiWindowFlags_NoScrollWithMouse: ImGuiWindowFlags_ = 16;
pub const ImGuiWindowFlags_NoCollapse: ImGuiWindowFlags_ = 32;
pub const ImGuiWindowFlags_AlwaysAutoResize: ImGuiWindowFlags_ = 64;
pub const ImGuiWindowFlags_NoBackground: ImGuiWindowFlags_ = 128;
pub const ImGuiWindowFlags_NoSavedSettings: ImGuiWindowFlags_ = 256;
pub const ImGuiWindowFlags_NoMouseInputs: ImGuiWindowFlags_ = 512;
pub const ImGuiWindowFlags_MenuBar: ImGuiWindowFlags_ = 1024;
pub const ImGuiWindowFlags_HorizontalScrollbar: ImGuiWindowFlags_ = 2048;
pub const ImGuiWindowFlags_NoFocusOnAppearing: ImGuiWindowFlags_ = 4096;
pub const ImGuiWindowFlags_NoBringToFrontOnFocus: ImGuiWindowFlags_ = 8192;
pub const ImGuiWindowFlags_AlwaysVerticalScrollbar: ImGuiWindowFlags_ = 16384;
pub const ImGuiWindowFlags_AlwaysHorizontalScrollbar: ImGuiWindowFlags_ = 32768;
pub const ImGuiWindowFlags_AlwaysUseWindowPadding: ImGuiWindowFlags_ = 65536;
pub const ImGuiWindowFlags_NoNavInputs: ImGuiWindowFlags_ = 262144;
pub const ImGuiWindowFlags_NoNavFocus: ImGuiWindowFlags_ = 524288;
pub const ImGuiWindowFlags_UnsavedDocument: ImGuiWindowFlags_ = 1048576;
pub const ImGuiWindowFlags_NoDocking: ImGuiWindowFlags_ = 2097152;
pub const ImGuiWindowFlags_NoNav: ImGuiWindowFlags_ = 786432;
pub const ImGuiWindowFlags_NoDecoration: ImGuiWindowFlags_ = 43;
pub const ImGuiWindowFlags_NoInputs: ImGuiWindowFlags_ = 786944;
pub const ImGuiWindowFlags_NavFlattened: ImGuiWindowFlags_ = 8388608;
pub const ImGuiWindowFlags_ChildWindow: ImGuiWindowFlags_ = 16777216;
pub const ImGuiWindowFlags_Tooltip: ImGuiWindowFlags_ = 33554432;
pub const ImGuiWindowFlags_Popup: ImGuiWindowFlags_ = 67108864;
pub const ImGuiWindowFlags_Modal: ImGuiWindowFlags_ = 134217728;
pub const ImGuiWindowFlags_ChildMenu: ImGuiWindowFlags_ = 268435456;
pub const ImGuiWindowFlags_DockNodeHost: ImGuiWindowFlags_ = 536870912;
pub type ImGuiWindowFlags_ = cty::c_uint;
pub const ImGuiInputTextFlags_None: ImGuiInputTextFlags_ = 0;
pub const ImGuiInputTextFlags_CharsDecimal: ImGuiInputTextFlags_ = 1;
pub const ImGuiInputTextFlags_CharsHexadecimal: ImGuiInputTextFlags_ = 2;
pub const ImGuiInputTextFlags_CharsUppercase: ImGuiInputTextFlags_ = 4;
pub const ImGuiInputTextFlags_CharsNoBlank: ImGuiInputTextFlags_ = 8;
pub const ImGuiInputTextFlags_AutoSelectAll: ImGuiInputTextFlags_ = 16;
pub const ImGuiInputTextFlags_EnterReturnsTrue: ImGuiInputTextFlags_ = 32;
pub const ImGuiInputTextFlags_CallbackCompletion: ImGuiInputTextFlags_ = 64;
pub const ImGuiInputTextFlags_CallbackHistory: ImGuiInputTextFlags_ = 128;
pub const ImGuiInputTextFlags_CallbackAlways: ImGuiInputTextFlags_ = 256;
pub const ImGuiInputTextFlags_CallbackCharFilter: ImGuiInputTextFlags_ = 512;
pub const ImGuiInputTextFlags_AllowTabInput: ImGuiInputTextFlags_ = 1024;
pub const ImGuiInputTextFlags_CtrlEnterForNewLine: ImGuiInputTextFlags_ = 2048;
pub const ImGuiInputTextFlags_NoHorizontalScroll: ImGuiInputTextFlags_ = 4096;
pub const ImGuiInputTextFlags_AlwaysOverwrite: ImGuiInputTextFlags_ = 8192;
pub const ImGuiInputTextFlags_ReadOnly: ImGuiInputTextFlags_ = 16384;
pub const ImGuiInputTextFlags_Password: ImGuiInputTextFlags_ = 32768;
pub const ImGuiInputTextFlags_NoUndoRedo: ImGuiInputTextFlags_ = 65536;
pub const ImGuiInputTextFlags_CharsScientific: ImGuiInputTextFlags_ = 131072;
pub const ImGuiInputTextFlags_CallbackResize: ImGuiInputTextFlags_ = 262144;
pub const ImGuiInputTextFlags_CallbackEdit: ImGuiInputTextFlags_ = 524288;
pub const ImGuiInputTextFlags_EscapeClearsAll: ImGuiInputTextFlags_ = 1048576;
pub type ImGuiInputTextFlags_ = cty::c_uint;
pub const ImGuiTreeNodeFlags_None: ImGuiTreeNodeFlags_ = 0;
pub const ImGuiTreeNodeFlags_Selected: ImGuiTreeNodeFlags_ = 1;
pub const ImGuiTreeNodeFlags_Framed: ImGuiTreeNodeFlags_ = 2;
pub const ImGuiTreeNodeFlags_AllowItemOverlap: ImGuiTreeNodeFlags_ = 4;
pub const ImGuiTreeNodeFlags_NoTreePushOnOpen: ImGuiTreeNodeFlags_ = 8;
pub const ImGuiTreeNodeFlags_NoAutoOpenOnLog: ImGuiTreeNodeFlags_ = 16;
pub const ImGuiTreeNodeFlags_DefaultOpen: ImGuiTreeNodeFlags_ = 32;
pub const ImGuiTreeNodeFlags_OpenOnDoubleClick: ImGuiTreeNodeFlags_ = 64;
pub const ImGuiTreeNodeFlags_OpenOnArrow: ImGuiTreeNodeFlags_ = 128;
pub const ImGuiTreeNodeFlags_Leaf: ImGuiTreeNodeFlags_ = 256;
pub const ImGuiTreeNodeFlags_Bullet: ImGuiTreeNodeFlags_ = 512;
pub const ImGuiTreeNodeFlags_FramePadding: ImGuiTreeNodeFlags_ = 1024;
pub const ImGuiTreeNodeFlags_SpanAvailWidth: ImGuiTreeNodeFlags_ = 2048;
pub const ImGuiTreeNodeFlags_SpanFullWidth: ImGuiTreeNodeFlags_ = 4096;
pub const ImGuiTreeNodeFlags_NavLeftJumpsBackHere: ImGuiTreeNodeFlags_ = 8192;
pub const ImGuiTreeNodeFlags_CollapsingHeader: ImGuiTreeNodeFlags_ = 26;
pub type ImGuiTreeNodeFlags_ = cty::c_uint;
pub const ImGuiPopupFlags_None: ImGuiPopupFlags_ = 0;
pub const ImGuiPopupFlags_MouseButtonLeft: ImGuiPopupFlags_ = 0;
pub const ImGuiPopupFlags_MouseButtonRight: ImGuiPopupFlags_ = 1;
pub const ImGuiPopupFlags_MouseButtonMiddle: ImGuiPopupFlags_ = 2;
pub const ImGuiPopupFlags_MouseButtonMask_: ImGuiPopupFlags_ = 31;
pub const ImGuiPopupFlags_MouseButtonDefault_: ImGuiPopupFlags_ = 1;
pub const ImGuiPopupFlags_NoOpenOverExistingPopup: ImGuiPopupFlags_ = 32;
pub const ImGuiPopupFlags_NoOpenOverItems: ImGuiPopupFlags_ = 64;
pub const ImGuiPopupFlags_AnyPopupId: ImGuiPopupFlags_ = 128;
pub const ImGuiPopupFlags_AnyPopupLevel: ImGuiPopupFlags_ = 256;
pub const ImGuiPopupFlags_AnyPopup: ImGuiPopupFlags_ = 384;
pub type ImGuiPopupFlags_ = cty::c_uint;
pub const ImGuiSelectableFlags_None: ImGuiSelectableFlags_ = 0;
pub const ImGuiSelectableFlags_DontClosePopups: ImGuiSelectableFlags_ = 1;
pub const ImGuiSelectableFlags_SpanAllColumns: ImGuiSelectableFlags_ = 2;
pub const ImGuiSelectableFlags_AllowDoubleClick: ImGuiSelectableFlags_ = 4;
pub const ImGuiSelectableFlags_Disabled: ImGuiSelectableFlags_ = 8;
pub const ImGuiSelectableFlags_AllowItemOverlap: ImGuiSelectableFlags_ = 16;
pub type ImGuiSelectableFlags_ = cty::c_uint;
pub const ImGuiComboFlags_None: ImGuiComboFlags_ = 0;
pub const ImGuiComboFlags_PopupAlignLeft: ImGuiComboFlags_ = 1;
pub const ImGuiComboFlags_HeightSmall: ImGuiComboFlags_ = 2;
pub const ImGuiComboFlags_HeightRegular: ImGuiComboFlags_ = 4;
pub const ImGuiComboFlags_HeightLarge: ImGuiComboFlags_ = 8;
pub const ImGuiComboFlags_HeightLargest: ImGuiComboFlags_ = 16;
pub const ImGuiComboFlags_NoArrowButton: ImGuiComboFlags_ = 32;
pub const ImGuiComboFlags_NoPreview: ImGuiComboFlags_ = 64;
pub const ImGuiComboFlags_HeightMask_: ImGuiComboFlags_ = 30;
pub type ImGuiComboFlags_ = cty::c_uint;
pub const ImGuiTabBarFlags_None: ImGuiTabBarFlags_ = 0;
pub const ImGuiTabBarFlags_Reorderable: ImGuiTabBarFlags_ = 1;
pub const ImGuiTabBarFlags_AutoSelectNewTabs: ImGuiTabBarFlags_ = 2;
pub const ImGuiTabBarFlags_TabListPopupButton: ImGuiTabBarFlags_ = 4;
pub const ImGuiTabBarFlags_NoCloseWithMiddleMouseButton: ImGuiTabBarFlags_ = 8;
pub const ImGuiTabBarFlags_NoTabListScrollingButtons: ImGuiTabBarFlags_ = 16;
pub const ImGuiTabBarFlags_NoTooltip: ImGuiTabBarFlags_ = 32;
pub const ImGuiTabBarFlags_FittingPolicyResizeDown: ImGuiTabBarFlags_ = 64;
pub const ImGuiTabBarFlags_FittingPolicyScroll: ImGuiTabBarFlags_ = 128;
pub const ImGuiTabBarFlags_FittingPolicyMask_: ImGuiTabBarFlags_ = 192;
pub const ImGuiTabBarFlags_FittingPolicyDefault_: ImGuiTabBarFlags_ = 64;
pub type ImGuiTabBarFlags_ = cty::c_uint;
pub const ImGuiTabItemFlags_None: ImGuiTabItemFlags_ = 0;
pub const ImGuiTabItemFlags_UnsavedDocument: ImGuiTabItemFlags_ = 1;
pub const ImGuiTabItemFlags_SetSelected: ImGuiTabItemFlags_ = 2;
pub const ImGuiTabItemFlags_NoCloseWithMiddleMouseButton: ImGuiTabItemFlags_ = 4;
pub const ImGuiTabItemFlags_NoPushId: ImGuiTabItemFlags_ = 8;
pub const ImGuiTabItemFlags_NoTooltip: ImGuiTabItemFlags_ = 16;
pub const ImGuiTabItemFlags_NoReorder: ImGuiTabItemFlags_ = 32;
pub const ImGuiTabItemFlags_Leading: ImGuiTabItemFlags_ = 64;
pub const ImGuiTabItemFlags_Trailing: ImGuiTabItemFlags_ = 128;
pub type ImGuiTabItemFlags_ = cty::c_uint;
pub const ImGuiTableFlags_None: ImGuiTableFlags_ = 0;
pub const ImGuiTableFlags_Resizable: ImGuiTableFlags_ = 1;
pub const ImGuiTableFlags_Reorderable: ImGuiTableFlags_ = 2;
pub const ImGuiTableFlags_Hideable: ImGuiTableFlags_ = 4;
pub const ImGuiTableFlags_Sortable: ImGuiTableFlags_ = 8;
pub const ImGuiTableFlags_NoSavedSettings: ImGuiTableFlags_ = 16;
pub const ImGuiTableFlags_ContextMenuInBody: ImGuiTableFlags_ = 32;
pub const ImGuiTableFlags_RowBg: ImGuiTableFlags_ = 64;
pub const ImGuiTableFlags_BordersInnerH: ImGuiTableFlags_ = 128;
pub const ImGuiTableFlags_BordersOuterH: ImGuiTableFlags_ = 256;
pub const ImGuiTableFlags_BordersInnerV: ImGuiTableFlags_ = 512;
pub const ImGuiTableFlags_BordersOuterV: ImGuiTableFlags_ = 1024;
pub const ImGuiTableFlags_BordersH: ImGuiTableFlags_ = 384;
pub const ImGuiTableFlags_BordersV: ImGuiTableFlags_ = 1536;
pub const ImGuiTableFlags_BordersInner: ImGuiTableFlags_ = 640;
pub const ImGuiTableFlags_BordersOuter: ImGuiTableFlags_ = 1280;
pub const ImGuiTableFlags_Borders: ImGuiTableFlags_ = 1920;
pub const ImGuiTableFlags_NoBordersInBody: ImGuiTableFlags_ = 2048;
pub const ImGuiTableFlags_NoBordersInBodyUntilResize: ImGuiTableFlags_ = 4096;
pub const ImGuiTableFlags_SizingFixedFit: ImGuiTableFlags_ = 8192;
pub const ImGuiTableFlags_SizingFixedSame: ImGuiTableFlags_ = 16384;
pub const ImGuiTableFlags_SizingStretchProp: ImGuiTableFlags_ = 24576;
pub const ImGuiTableFlags_SizingStretchSame: ImGuiTableFlags_ = 32768;
pub const ImGuiTableFlags_NoHostExtendX: ImGuiTableFlags_ = 65536;
pub const ImGuiTableFlags_NoHostExtendY: ImGuiTableFlags_ = 131072;
pub const ImGuiTableFlags_NoKeepColumnsVisible: ImGuiTableFlags_ = 262144;
pub const ImGuiTableFlags_PreciseWidths: ImGuiTableFlags_ = 524288;
pub const ImGuiTableFlags_NoClip: ImGuiTableFlags_ = 1048576;
pub const ImGuiTableFlags_PadOuterX: ImGuiTableFlags_ = 2097152;
pub const ImGuiTableFlags_NoPadOuterX: ImGuiTableFlags_ = 4194304;
pub const ImGuiTableFlags_NoPadInnerX: ImGuiTableFlags_ = 8388608;
pub const ImGuiTableFlags_ScrollX: ImGuiTableFlags_ = 16777216;
pub const ImGuiTableFlags_ScrollY: ImGuiTableFlags_ = 33554432;
pub const ImGuiTableFlags_SortMulti: ImGuiTableFlags_ = 67108864;
pub const ImGuiTableFlags_SortTristate: ImGuiTableFlags_ = 134217728;
pub const ImGuiTableFlags_SizingMask_: ImGuiTableFlags_ = 57344;
pub type ImGuiTableFlags_ = cty::c_uint;
pub const ImGuiTableColumnFlags_None: ImGuiTableColumnFlags_ = 0;
pub const ImGuiTableColumnFlags_Disabled: ImGuiTableColumnFlags_ = 1;
pub const ImGuiTableColumnFlags_DefaultHide: ImGuiTableColumnFlags_ = 2;
pub const ImGuiTableColumnFlags_DefaultSort: ImGuiTableColumnFlags_ = 4;
pub const ImGuiTableColumnFlags_WidthStretch: ImGuiTableColumnFlags_ = 8;
pub const ImGuiTableColumnFlags_WidthFixed: ImGuiTableColumnFlags_ = 16;
pub const ImGuiTableColumnFlags_NoResize: ImGuiTableColumnFlags_ = 32;
pub const ImGuiTableColumnFlags_NoReorder: ImGuiTableColumnFlags_ = 64;
pub const ImGuiTableColumnFlags_NoHide: ImGuiTableColumnFlags_ = 128;
pub const ImGuiTableColumnFlags_NoClip: ImGuiTableColumnFlags_ = 256;
pub const ImGuiTableColumnFlags_NoSort: ImGuiTableColumnFlags_ = 512;
pub const ImGuiTableColumnFlags_NoSortAscending: ImGuiTableColumnFlags_ = 1024;
pub const ImGuiTableColumnFlags_NoSortDescending: ImGuiTableColumnFlags_ = 2048;
pub const ImGuiTableColumnFlags_NoHeaderLabel: ImGuiTableColumnFlags_ = 4096;
pub const ImGuiTableColumnFlags_NoHeaderWidth: ImGuiTableColumnFlags_ = 8192;
pub const ImGuiTableColumnFlags_PreferSortAscending: ImGuiTableColumnFlags_ = 16384;
pub const ImGuiTableColumnFlags_PreferSortDescending: ImGuiTableColumnFlags_ = 32768;
pub const ImGuiTableColumnFlags_IndentEnable: ImGuiTableColumnFlags_ = 65536;
pub const ImGuiTableColumnFlags_IndentDisable: ImGuiTableColumnFlags_ = 131072;
pub const ImGuiTableColumnFlags_IsEnabled: ImGuiTableColumnFlags_ = 16777216;
pub const ImGuiTableColumnFlags_IsVisible: ImGuiTableColumnFlags_ = 33554432;
pub const ImGuiTableColumnFlags_IsSorted: ImGuiTableColumnFlags_ = 67108864;
pub const ImGuiTableColumnFlags_IsHovered: ImGuiTableColumnFlags_ = 134217728;
pub const ImGuiTableColumnFlags_WidthMask_: ImGuiTableColumnFlags_ = 24;
pub const ImGuiTableColumnFlags_IndentMask_: ImGuiTableColumnFlags_ = 196608;
pub const ImGuiTableColumnFlags_StatusMask_: ImGuiTableColumnFlags_ = 251658240;
pub const ImGuiTableColumnFlags_NoDirectResize_: ImGuiTableColumnFlags_ = 1073741824;
pub type ImGuiTableColumnFlags_ = cty::c_uint;
pub const ImGuiTableRowFlags_None: ImGuiTableRowFlags_ = 0;
pub const ImGuiTableRowFlags_Headers: ImGuiTableRowFlags_ = 1;
pub type ImGuiTableRowFlags_ = cty::c_uint;
pub const ImGuiTableBgTarget_None: ImGuiTableBgTarget_ = 0;
pub const ImGuiTableBgTarget_RowBg0: ImGuiTableBgTarget_ = 1;
pub const ImGuiTableBgTarget_RowBg1: ImGuiTableBgTarget_ = 2;
pub const ImGuiTableBgTarget_CellBg: ImGuiTableBgTarget_ = 3;
pub type ImGuiTableBgTarget_ = cty::c_uint;
pub const ImGuiFocusedFlags_None: ImGuiFocusedFlags_ = 0;
pub const ImGuiFocusedFlags_ChildWindows: ImGuiFocusedFlags_ = 1;
pub const ImGuiFocusedFlags_RootWindow: ImGuiFocusedFlags_ = 2;
pub const ImGuiFocusedFlags_AnyWindow: ImGuiFocusedFlags_ = 4;
pub const ImGuiFocusedFlags_NoPopupHierarchy: ImGuiFocusedFlags_ = 8;
pub const ImGuiFocusedFlags_DockHierarchy: ImGuiFocusedFlags_ = 16;
pub const ImGuiFocusedFlags_RootAndChildWindows: ImGuiFocusedFlags_ = 3;
pub type ImGuiFocusedFlags_ = cty::c_uint;
pub const ImGuiHoveredFlags_None: ImGuiHoveredFlags_ = 0;
pub const ImGuiHoveredFlags_ChildWindows: ImGuiHoveredFlags_ = 1;
pub const ImGuiHoveredFlags_RootWindow: ImGuiHoveredFlags_ = 2;
pub const ImGuiHoveredFlags_AnyWindow: ImGuiHoveredFlags_ = 4;
pub const ImGuiHoveredFlags_NoPopupHierarchy: ImGuiHoveredFlags_ = 8;
pub const ImGuiHoveredFlags_DockHierarchy: ImGuiHoveredFlags_ = 16;
pub const ImGuiHoveredFlags_AllowWhenBlockedByPopup: ImGuiHoveredFlags_ = 32;
pub const ImGuiHoveredFlags_AllowWhenBlockedByActiveItem: ImGuiHoveredFlags_ = 128;
pub const ImGuiHoveredFlags_AllowWhenOverlapped: ImGuiHoveredFlags_ = 256;
pub const ImGuiHoveredFlags_AllowWhenDisabled: ImGuiHoveredFlags_ = 512;
pub const ImGuiHoveredFlags_NoNavOverride: ImGuiHoveredFlags_ = 1024;
pub const ImGuiHoveredFlags_RectOnly: ImGuiHoveredFlags_ = 416;
pub const ImGuiHoveredFlags_RootAndChildWindows: ImGuiHoveredFlags_ = 3;
pub const ImGuiHoveredFlags_DelayNormal: ImGuiHoveredFlags_ = 2048;
pub const ImGuiHoveredFlags_DelayShort: ImGuiHoveredFlags_ = 4096;
pub const ImGuiHoveredFlags_NoSharedDelay: ImGuiHoveredFlags_ = 8192;
pub type ImGuiHoveredFlags_ = cty::c_uint;
pub const ImGuiDockNodeFlags_None: ImGuiDockNodeFlags_ = 0;
pub const ImGuiDockNodeFlags_KeepAliveOnly: ImGuiDockNodeFlags_ = 1;
pub const ImGuiDockNodeFlags_NoDockingInCentralNode: ImGuiDockNodeFlags_ = 4;
pub const ImGuiDockNodeFlags_PassthruCentralNode: ImGuiDockNodeFlags_ = 8;
pub const ImGuiDockNodeFlags_NoSplit: ImGuiDockNodeFlags_ = 16;
pub const ImGuiDockNodeFlags_NoResize: ImGuiDockNodeFlags_ = 32;
pub const ImGuiDockNodeFlags_AutoHideTabBar: ImGuiDockNodeFlags_ = 64;
pub type ImGuiDockNodeFlags_ = cty::c_uint;
pub const ImGuiDragDropFlags_None: ImGuiDragDropFlags_ = 0;
pub const ImGuiDragDropFlags_SourceNoPreviewTooltip: ImGuiDragDropFlags_ = 1;
pub const ImGuiDragDropFlags_SourceNoDisableHover: ImGuiDragDropFlags_ = 2;
pub const ImGuiDragDropFlags_SourceNoHoldToOpenOthers: ImGuiDragDropFlags_ = 4;
pub const ImGuiDragDropFlags_SourceAllowNullID: ImGuiDragDropFlags_ = 8;
pub const ImGuiDragDropFlags_SourceExtern: ImGuiDragDropFlags_ = 16;
pub const ImGuiDragDropFlags_SourceAutoExpirePayload: ImGuiDragDropFlags_ = 32;
pub const ImGuiDragDropFlags_AcceptBeforeDelivery: ImGuiDragDropFlags_ = 1024;
pub const ImGuiDragDropFlags_AcceptNoDrawDefaultRect: ImGuiDragDropFlags_ = 2048;
pub const ImGuiDragDropFlags_AcceptNoPreviewTooltip: ImGuiDragDropFlags_ = 4096;
pub const ImGuiDragDropFlags_AcceptPeekOnly: ImGuiDragDropFlags_ = 3072;
pub type ImGuiDragDropFlags_ = cty::c_uint;
pub const ImGuiDataType_S8: ImGuiDataType_ = 0;
pub const ImGuiDataType_U8: ImGuiDataType_ = 1;
pub const ImGuiDataType_S16: ImGuiDataType_ = 2;
pub const ImGuiDataType_U16: ImGuiDataType_ = 3;
pub const ImGuiDataType_S32: ImGuiDataType_ = 4;
pub const ImGuiDataType_U32: ImGuiDataType_ = 5;
pub const ImGuiDataType_S64: ImGuiDataType_ = 6;
pub const ImGuiDataType_U64: ImGuiDataType_ = 7;
pub const ImGuiDataType_Float: ImGuiDataType_ = 8;
pub const ImGuiDataType_Double: ImGuiDataType_ = 9;
pub const ImGuiDataType_COUNT: ImGuiDataType_ = 10;
pub type ImGuiDataType_ = cty::c_uint;
pub const ImGuiDir_None: ImGuiDir_ = -1;
pub const ImGuiDir_Left: ImGuiDir_ = 0;
pub const ImGuiDir_Right: ImGuiDir_ = 1;
pub const ImGuiDir_Up: ImGuiDir_ = 2;
pub const ImGuiDir_Down: ImGuiDir_ = 3;
pub const ImGuiDir_COUNT: ImGuiDir_ = 4;
pub type ImGuiDir_ = cty::c_int;
pub const ImGuiSortDirection_None: ImGuiSortDirection_ = 0;
pub const ImGuiSortDirection_Ascending: ImGuiSortDirection_ = 1;
pub const ImGuiSortDirection_Descending: ImGuiSortDirection_ = 2;
pub type ImGuiSortDirection_ = cty::c_uint;
pub const ImGuiKey_None: ImGuiKey = 0;
pub const ImGuiKey_Tab: ImGuiKey = 512;
pub const ImGuiKey_LeftArrow: ImGuiKey = 513;
pub const ImGuiKey_RightArrow: ImGuiKey = 514;
pub const ImGuiKey_UpArrow: ImGuiKey = 515;
pub const ImGuiKey_DownArrow: ImGuiKey = 516;
pub const ImGuiKey_PageUp: ImGuiKey = 517;
pub const ImGuiKey_PageDown: ImGuiKey = 518;
pub const ImGuiKey_Home: ImGuiKey = 519;
pub const ImGuiKey_End: ImGuiKey = 520;
pub const ImGuiKey_Insert: ImGuiKey = 521;
pub const ImGuiKey_Delete: ImGuiKey = 522;
pub const ImGuiKey_Backspace: ImGuiKey = 523;
pub const ImGuiKey_Space: ImGuiKey = 524;
pub const ImGuiKey_Enter: ImGuiKey = 525;
pub const ImGuiKey_Escape: ImGuiKey = 526;
pub const ImGuiKey_LeftCtrl: ImGuiKey = 527;
pub const ImGuiKey_LeftShift: ImGuiKey = 528;
pub const ImGuiKey_LeftAlt: ImGuiKey = 529;
pub const ImGuiKey_LeftSuper: ImGuiKey = 530;
pub const ImGuiKey_RightCtrl: ImGuiKey = 531;
pub const ImGuiKey_RightShift: ImGuiKey = 532;
pub const ImGuiKey_RightAlt: ImGuiKey = 533;
pub const ImGuiKey_RightSuper: ImGuiKey = 534;
pub const ImGuiKey_Menu: ImGuiKey = 535;
pub const ImGuiKey_0: ImGuiKey = 536;
pub const ImGuiKey_1: ImGuiKey = 537;
pub const ImGuiKey_2: ImGuiKey = 538;
pub const ImGuiKey_3: ImGuiKey = 539;
pub const ImGuiKey_4: ImGuiKey = 540;
pub const ImGuiKey_5: ImGuiKey = 541;
pub const ImGuiKey_6: ImGuiKey = 542;
pub const ImGuiKey_7: ImGuiKey = 543;
pub const ImGuiKey_8: ImGuiKey = 544;
pub const ImGuiKey_9: ImGuiKey = 545;
pub const ImGuiKey_A: ImGuiKey = 546;
pub const ImGuiKey_B: ImGuiKey = 547;
pub const ImGuiKey_C: ImGuiKey = 548;
pub const ImGuiKey_D: ImGuiKey = 549;
pub const ImGuiKey_E: ImGuiKey = 550;
pub const ImGuiKey_F: ImGuiKey = 551;
pub const ImGuiKey_G: ImGuiKey = 552;
pub const ImGuiKey_H: ImGuiKey = 553;
pub const ImGuiKey_I: ImGuiKey = 554;
pub const ImGuiKey_J: ImGuiKey = 555;
pub const ImGuiKey_K: ImGuiKey = 556;
pub const ImGuiKey_L: ImGuiKey = 557;
pub const ImGuiKey_M: ImGuiKey = 558;
pub const ImGuiKey_N: ImGuiKey = 559;
pub const ImGuiKey_O: ImGuiKey = 560;
pub const ImGuiKey_P: ImGuiKey = 561;
pub const ImGuiKey_Q: ImGuiKey = 562;
pub const ImGuiKey_R: ImGuiKey = 563;
pub const ImGuiKey_S: ImGuiKey = 564;
pub const ImGuiKey_T: ImGuiKey = 565;
pub const ImGuiKey_U: ImGuiKey = 566;
pub const ImGuiKey_V: ImGuiKey = 567;
pub const ImGuiKey_W: ImGuiKey = 568;
pub const ImGuiKey_X: ImGuiKey = 569;
pub const ImGuiKey_Y: ImGuiKey = 570;
pub const ImGuiKey_Z: ImGuiKey = 571;
pub const ImGuiKey_F1: ImGuiKey = 572;
pub const ImGuiKey_F2: ImGuiKey = 573;
pub const ImGuiKey_F3: ImGuiKey = 574;
pub const ImGuiKey_F4: ImGuiKey = 575;
pub const ImGuiKey_F5: ImGuiKey = 576;
pub const ImGuiKey_F6: ImGuiKey = 577;
pub const ImGuiKey_F7: ImGuiKey = 578;
pub const ImGuiKey_F8: ImGuiKey = 579;
pub const ImGuiKey_F9: ImGuiKey = 580;
pub const ImGuiKey_F10: ImGuiKey = 581;
pub const ImGuiKey_F11: ImGuiKey = 582;
pub const ImGuiKey_F12: ImGuiKey = 583;
pub const ImGuiKey_Apostrophe: ImGuiKey = 584;
pub const ImGuiKey_Comma: ImGuiKey = 585;
pub const ImGuiKey_Minus: ImGuiKey = 586;
pub const ImGuiKey_Period: ImGuiKey = 587;
pub const ImGuiKey_Slash: ImGuiKey = 588;
pub const ImGuiKey_Semicolon: ImGuiKey = 589;
pub const ImGuiKey_Equal: ImGuiKey = 590;
pub const ImGuiKey_LeftBracket: ImGuiKey = 591;
pub const ImGuiKey_Backslash: ImGuiKey = 592;
pub const ImGuiKey_RightBracket: ImGuiKey = 593;
pub const ImGuiKey_GraveAccent: ImGuiKey = 594;
pub const ImGuiKey_CapsLock: ImGuiKey = 595;
pub const ImGuiKey_ScrollLock: ImGuiKey = 596;
pub const ImGuiKey_NumLock: ImGuiKey = 597;
pub const ImGuiKey_PrintScreen: ImGuiKey = 598;
pub const ImGuiKey_Pause: ImGuiKey = 599;
pub const ImGuiKey_Keypad0: ImGuiKey = 600;
pub const ImGuiKey_Keypad1: ImGuiKey = 601;
pub const ImGuiKey_Keypad2: ImGuiKey = 602;
pub const ImGuiKey_Keypad3: ImGuiKey = 603;
pub const ImGuiKey_Keypad4: ImGuiKey = 604;
pub const ImGuiKey_Keypad5: ImGuiKey = 605;
pub const ImGuiKey_Keypad6: ImGuiKey = 606;
pub const ImGuiKey_Keypad7: ImGuiKey = 607;
pub const ImGuiKey_Keypad8: ImGuiKey = 608;
pub const ImGuiKey_Keypad9: ImGuiKey = 609;
pub const ImGuiKey_KeypadDecimal: ImGuiKey = 610;
pub const ImGuiKey_KeypadDivide: ImGuiKey = 611;
pub const ImGuiKey_KeypadMultiply: ImGuiKey = 612;
pub const ImGuiKey_KeypadSubtract: ImGuiKey = 613;
pub const ImGuiKey_KeypadAdd: ImGuiKey = 614;
pub const ImGuiKey_KeypadEnter: ImGuiKey = 615;
pub const ImGuiKey_KeypadEqual: ImGuiKey = 616;
pub const ImGuiKey_GamepadStart: ImGuiKey = 617;
pub const ImGuiKey_GamepadBack: ImGuiKey = 618;
pub const ImGuiKey_GamepadFaceLeft: ImGuiKey = 619;
pub const ImGuiKey_GamepadFaceRight: ImGuiKey = 620;
pub const ImGuiKey_GamepadFaceUp: ImGuiKey = 621;
pub const ImGuiKey_GamepadFaceDown: ImGuiKey = 622;
pub const ImGuiKey_GamepadDpadLeft: ImGuiKey = 623;
pub const ImGuiKey_GamepadDpadRight: ImGuiKey = 624;
pub const ImGuiKey_GamepadDpadUp: ImGuiKey = 625;
pub const ImGuiKey_GamepadDpadDown: ImGuiKey = 626;
pub const ImGuiKey_GamepadL1: ImGuiKey = 627;
pub const ImGuiKey_GamepadR1: ImGuiKey = 628;
pub const ImGuiKey_GamepadL2: ImGuiKey = 629;
pub const ImGuiKey_GamepadR2: ImGuiKey = 630;
pub const ImGuiKey_GamepadL3: ImGuiKey = 631;
pub const ImGuiKey_GamepadR3: ImGuiKey = 632;
pub const ImGuiKey_GamepadLStickLeft: ImGuiKey = 633;
pub const ImGuiKey_GamepadLStickRight: ImGuiKey = 634;
pub const ImGuiKey_GamepadLStickUp: ImGuiKey = 635;
pub const ImGuiKey_GamepadLStickDown: ImGuiKey = 636;
pub const ImGuiKey_GamepadRStickLeft: ImGuiKey = 637;
pub const ImGuiKey_GamepadRStickRight: ImGuiKey = 638;
pub const ImGuiKey_GamepadRStickUp: ImGuiKey = 639;
pub const ImGuiKey_GamepadRStickDown: ImGuiKey = 640;
pub const ImGuiKey_MouseLeft: ImGuiKey = 641;
pub const ImGuiKey_MouseRight: ImGuiKey = 642;
pub const ImGuiKey_MouseMiddle: ImGuiKey = 643;
pub const ImGuiKey_MouseX1: ImGuiKey = 644;
pub const ImGuiKey_MouseX2: ImGuiKey = 645;
pub const ImGuiKey_MouseWheelX: ImGuiKey = 646;
pub const ImGuiKey_MouseWheelY: ImGuiKey = 647;
pub const ImGuiKey_ReservedForModCtrl: ImGuiKey = 648;
pub const ImGuiKey_ReservedForModShift: ImGuiKey = 649;
pub const ImGuiKey_ReservedForModAlt: ImGuiKey = 650;
pub const ImGuiKey_ReservedForModSuper: ImGuiKey = 651;
pub const ImGuiKey_COUNT: ImGuiKey = 652;
pub const ImGuiMod_None: ImGuiKey = 0;
pub const ImGuiMod_Ctrl: ImGuiKey = 4096;
pub const ImGuiMod_Shift: ImGuiKey = 8192;
pub const ImGuiMod_Alt: ImGuiKey = 16384;
pub const ImGuiMod_Super: ImGuiKey = 32768;
pub const ImGuiMod_Shortcut: ImGuiKey = 2048;
pub const ImGuiMod_Mask_: ImGuiKey = 63488;
pub const ImGuiKey_NamedKey_BEGIN: ImGuiKey = 512;
pub const ImGuiKey_NamedKey_END: ImGuiKey = 652;
pub const ImGuiKey_NamedKey_COUNT: ImGuiKey = 140;
pub const ImGuiKey_KeysData_SIZE: ImGuiKey = 652;
pub const ImGuiKey_KeysData_OFFSET: ImGuiKey = 0;
pub type ImGuiKey = cty::c_uint;
pub const ImGuiNavInput_Activate: ImGuiNavInput = 0;
pub const ImGuiNavInput_Cancel: ImGuiNavInput = 1;
pub const ImGuiNavInput_Input: ImGuiNavInput = 2;
pub const ImGuiNavInput_Menu: ImGuiNavInput = 3;
pub const ImGuiNavInput_DpadLeft: ImGuiNavInput = 4;
pub const ImGuiNavInput_DpadRight: ImGuiNavInput = 5;
pub const ImGuiNavInput_DpadUp: ImGuiNavInput = 6;
pub const ImGuiNavInput_DpadDown: ImGuiNavInput = 7;
pub const ImGuiNavInput_LStickLeft: ImGuiNavInput = 8;
pub const ImGuiNavInput_LStickRight: ImGuiNavInput = 9;
pub const ImGuiNavInput_LStickUp: ImGuiNavInput = 10;
pub const ImGuiNavInput_LStickDown: ImGuiNavInput = 11;
pub const ImGuiNavInput_FocusPrev: ImGuiNavInput = 12;
pub const ImGuiNavInput_FocusNext: ImGuiNavInput = 13;
pub const ImGuiNavInput_TweakSlow: ImGuiNavInput = 14;
pub const ImGuiNavInput_TweakFast: ImGuiNavInput = 15;
pub const ImGuiNavInput_COUNT: ImGuiNavInput = 16;
pub type ImGuiNavInput = cty::c_uint;
pub const ImGuiConfigFlags_None: ImGuiConfigFlags_ = 0;
pub const ImGuiConfigFlags_NavEnableKeyboard: ImGuiConfigFlags_ = 1;
pub const ImGuiConfigFlags_NavEnableGamepad: ImGuiConfigFlags_ = 2;
pub const ImGuiConfigFlags_NavEnableSetMousePos: ImGuiConfigFlags_ = 4;
pub const ImGuiConfigFlags_NavNoCaptureKeyboard: ImGuiConfigFlags_ = 8;
pub const ImGuiConfigFlags_NoMouse: ImGuiConfigFlags_ = 16;
pub const ImGuiConfigFlags_NoMouseCursorChange: ImGuiConfigFlags_ = 32;
pub const ImGuiConfigFlags_DockingEnable: ImGuiConfigFlags_ = 64;
pub const ImGuiConfigFlags_ViewportsEnable: ImGuiConfigFlags_ = 1024;
pub const ImGuiConfigFlags_DpiEnableScaleViewports: ImGuiConfigFlags_ = 16384;
pub const ImGuiConfigFlags_DpiEnableScaleFonts: ImGuiConfigFlags_ = 32768;
pub const ImGuiConfigFlags_IsSRGB: ImGuiConfigFlags_ = 1048576;
pub const ImGuiConfigFlags_IsTouchScreen: ImGuiConfigFlags_ = 2097152;
pub type ImGuiConfigFlags_ = cty::c_uint;
pub const ImGuiBackendFlags_None: ImGuiBackendFlags_ = 0;
pub const ImGuiBackendFlags_HasGamepad: ImGuiBackendFlags_ = 1;
pub const ImGuiBackendFlags_HasMouseCursors: ImGuiBackendFlags_ = 2;
pub const ImGuiBackendFlags_HasSetMousePos: ImGuiBackendFlags_ = 4;
pub const ImGuiBackendFlags_RendererHasVtxOffset: ImGuiBackendFlags_ = 8;
pub const ImGuiBackendFlags_PlatformHasViewports: ImGuiBackendFlags_ = 1024;
pub const ImGuiBackendFlags_HasMouseHoveredViewport: ImGuiBackendFlags_ = 2048;
pub const ImGuiBackendFlags_RendererHasViewports: ImGuiBackendFlags_ = 4096;
pub type ImGuiBackendFlags_ = cty::c_uint;
pub const ImGuiCol_Text: ImGuiCol_ = 0;
pub const ImGuiCol_TextDisabled: ImGuiCol_ = 1;
pub const ImGuiCol_WindowBg: ImGuiCol_ = 2;
pub const ImGuiCol_ChildBg: ImGuiCol_ = 3;
pub const ImGuiCol_PopupBg: ImGuiCol_ = 4;
pub const ImGuiCol_Border: ImGuiCol_ = 5;
pub const ImGuiCol_BorderShadow: ImGuiCol_ = 6;
pub const ImGuiCol_FrameBg: ImGuiCol_ = 7;
pub const ImGuiCol_FrameBgHovered: ImGuiCol_ = 8;
pub const ImGuiCol_FrameBgActive: ImGuiCol_ = 9;
pub const ImGuiCol_TitleBg: ImGuiCol_ = 10;
pub const ImGuiCol_TitleBgActive: ImGuiCol_ = 11;
pub const ImGuiCol_TitleBgCollapsed: ImGuiCol_ = 12;
pub const ImGuiCol_MenuBarBg: ImGuiCol_ = 13;
pub const ImGuiCol_ScrollbarBg: ImGuiCol_ = 14;
pub const ImGuiCol_ScrollbarGrab: ImGuiCol_ = 15;
pub const ImGuiCol_ScrollbarGrabHovered: ImGuiCol_ = 16;
pub const ImGuiCol_ScrollbarGrabActive: ImGuiCol_ = 17;
pub const ImGuiCol_CheckMark: ImGuiCol_ = 18;
pub const ImGuiCol_SliderGrab: ImGuiCol_ = 19;
pub const ImGuiCol_SliderGrabActive: ImGuiCol_ = 20;
pub const ImGuiCol_Button: ImGuiCol_ = 21;
pub const ImGuiCol_ButtonHovered: ImGuiCol_ = 22;
pub const ImGuiCol_ButtonActive: ImGuiCol_ = 23;
pub const ImGuiCol_Header: ImGuiCol_ = 24;
pub const ImGuiCol_HeaderHovered: ImGuiCol_ = 25;
pub const ImGuiCol_HeaderActive: ImGuiCol_ = 26;
pub const ImGuiCol_Separator: ImGuiCol_ = 27;
pub const ImGuiCol_SeparatorHovered: ImGuiCol_ = 28;
pub const ImGuiCol_SeparatorActive: ImGuiCol_ = 29;
pub const ImGuiCol_ResizeGrip: ImGuiCol_ = 30;
pub const ImGuiCol_ResizeGripHovered: ImGuiCol_ = 31;
pub const ImGuiCol_ResizeGripActive: ImGuiCol_ = 32;
pub const ImGuiCol_Tab: ImGuiCol_ = 33;
pub const ImGuiCol_TabHovered: ImGuiCol_ = 34;
pub const ImGuiCol_TabActive: ImGuiCol_ = 35;
pub const ImGuiCol_TabUnfocused: ImGuiCol_ = 36;
pub const ImGuiCol_TabUnfocusedActive: ImGuiCol_ = 37;
pub const ImGuiCol_DockingPreview: ImGuiCol_ = 38;
pub const ImGuiCol_DockingEmptyBg: ImGuiCol_ = 39;
pub const ImGuiCol_PlotLines: ImGuiCol_ = 40;
pub const ImGuiCol_PlotLinesHovered: ImGuiCol_ = 41;
pub const ImGuiCol_PlotHistogram: ImGuiCol_ = 42;
pub const ImGuiCol_PlotHistogramHovered: ImGuiCol_ = 43;
pub const ImGuiCol_TableHeaderBg: ImGuiCol_ = 44;
pub const ImGuiCol_TableBorderStrong: ImGuiCol_ = 45;
pub const ImGuiCol_TableBorderLight: ImGuiCol_ = 46;
pub const ImGuiCol_TableRowBg: ImGuiCol_ = 47;
pub const ImGuiCol_TableRowBgAlt: ImGuiCol_ = 48;
pub const ImGuiCol_TextSelectedBg: ImGuiCol_ = 49;
pub const ImGuiCol_DragDropTarget: ImGuiCol_ = 50;
pub const ImGuiCol_NavHighlight: ImGuiCol_ = 51;
pub const ImGuiCol_NavWindowingHighlight: ImGuiCol_ = 52;
pub const ImGuiCol_NavWindowingDimBg: ImGuiCol_ = 53;
pub const ImGuiCol_ModalWindowDimBg: ImGuiCol_ = 54;
pub const ImGuiCol_COUNT: ImGuiCol_ = 55;
pub type ImGuiCol_ = cty::c_uint;
pub const ImGuiStyleVar_Alpha: ImGuiStyleVar_ = 0;
pub const ImGuiStyleVar_DisabledAlpha: ImGuiStyleVar_ = 1;
pub const ImGuiStyleVar_WindowPadding: ImGuiStyleVar_ = 2;
pub const ImGuiStyleVar_WindowRounding: ImGuiStyleVar_ = 3;
pub const ImGuiStyleVar_WindowBorderSize: ImGuiStyleVar_ = 4;
pub const ImGuiStyleVar_WindowMinSize: ImGuiStyleVar_ = 5;
pub const ImGuiStyleVar_WindowTitleAlign: ImGuiStyleVar_ = 6;
pub const ImGuiStyleVar_ChildRounding: ImGuiStyleVar_ = 7;
pub const ImGuiStyleVar_ChildBorderSize: ImGuiStyleVar_ = 8;
pub const ImGuiStyleVar_PopupRounding: ImGuiStyleVar_ = 9;
pub const ImGuiStyleVar_PopupBorderSize: ImGuiStyleVar_ = 10;
pub const ImGuiStyleVar_FramePadding: ImGuiStyleVar_ = 11;
pub const ImGuiStyleVar_FrameRounding: ImGuiStyleVar_ = 12;
pub const ImGuiStyleVar_FrameBorderSize: ImGuiStyleVar_ = 13;
pub const ImGuiStyleVar_ItemSpacing: ImGuiStyleVar_ = 14;
pub const ImGuiStyleVar_ItemInnerSpacing: ImGuiStyleVar_ = 15;
pub const ImGuiStyleVar_IndentSpacing: ImGuiStyleVar_ = 16;
pub const ImGuiStyleVar_CellPadding: ImGuiStyleVar_ = 17;
pub const ImGuiStyleVar_ScrollbarSize: ImGuiStyleVar_ = 18;
pub const ImGuiStyleVar_ScrollbarRounding: ImGuiStyleVar_ = 19;
pub const ImGuiStyleVar_GrabMinSize: ImGuiStyleVar_ = 20;
pub const ImGuiStyleVar_GrabRounding: ImGuiStyleVar_ = 21;
pub const ImGuiStyleVar_TabRounding: ImGuiStyleVar_ = 22;
pub const ImGuiStyleVar_ButtonTextAlign: ImGuiStyleVar_ = 23;
pub const ImGuiStyleVar_SelectableTextAlign: ImGuiStyleVar_ = 24;
pub const ImGuiStyleVar_COUNT: ImGuiStyleVar_ = 25;
pub type ImGuiStyleVar_ = cty::c_uint;
pub const ImGuiButtonFlags_None: ImGuiButtonFlags_ = 0;
pub const ImGuiButtonFlags_MouseButtonLeft: ImGuiButtonFlags_ = 1;
pub const ImGuiButtonFlags_MouseButtonRight: ImGuiButtonFlags_ = 2;
pub const ImGuiButtonFlags_MouseButtonMiddle: ImGuiButtonFlags_ = 4;
pub const ImGuiButtonFlags_MouseButtonMask_: ImGuiButtonFlags_ = 7;
pub const ImGuiButtonFlags_MouseButtonDefault_: ImGuiButtonFlags_ = 1;
pub type ImGuiButtonFlags_ = cty::c_uint;
pub const ImGuiColorEditFlags_None: ImGuiColorEditFlags_ = 0;
pub const ImGuiColorEditFlags_NoAlpha: ImGuiColorEditFlags_ = 2;
pub const ImGuiColorEditFlags_NoPicker: ImGuiColorEditFlags_ = 4;
pub const ImGuiColorEditFlags_NoOptions: ImGuiColorEditFlags_ = 8;
pub const ImGuiColorEditFlags_NoSmallPreview: ImGuiColorEditFlags_ = 16;
pub const ImGuiColorEditFlags_NoInputs: ImGuiColorEditFlags_ = 32;
pub const ImGuiColorEditFlags_NoTooltip: ImGuiColorEditFlags_ = 64;
pub const ImGuiColorEditFlags_NoLabel: ImGuiColorEditFlags_ = 128;
pub const ImGuiColorEditFlags_NoSidePreview: ImGuiColorEditFlags_ = 256;
pub const ImGuiColorEditFlags_NoDragDrop: ImGuiColorEditFlags_ = 512;
pub const ImGuiColorEditFlags_NoBorder: ImGuiColorEditFlags_ = 1024;
pub const ImGuiColorEditFlags_AlphaBar: ImGuiColorEditFlags_ = 65536;
pub const ImGuiColorEditFlags_AlphaPreview: ImGuiColorEditFlags_ = 131072;
pub const ImGuiColorEditFlags_AlphaPreviewHalf: ImGuiColorEditFlags_ = 262144;
pub const ImGuiColorEditFlags_HDR: ImGuiColorEditFlags_ = 524288;
pub const ImGuiColorEditFlags_DisplayRGB: ImGuiColorEditFlags_ = 1048576;
pub const ImGuiColorEditFlags_DisplayHSV: ImGuiColorEditFlags_ = 2097152;
pub const ImGuiColorEditFlags_DisplayHex: ImGuiColorEditFlags_ = 4194304;
pub const ImGuiColorEditFlags_Uint8: ImGuiColorEditFlags_ = 8388608;
pub const ImGuiColorEditFlags_Float: ImGuiColorEditFlags_ = 16777216;
pub const ImGuiColorEditFlags_PickerHueBar: ImGuiColorEditFlags_ = 33554432;
pub const ImGuiColorEditFlags_PickerHueWheel: ImGuiColorEditFlags_ = 67108864;
pub const ImGuiColorEditFlags_InputRGB: ImGuiColorEditFlags_ = 134217728;
pub const ImGuiColorEditFlags_InputHSV: ImGuiColorEditFlags_ = 268435456;
pub const ImGuiColorEditFlags_DefaultOptions_: ImGuiColorEditFlags_ = 177209344;
pub const ImGuiColorEditFlags_DisplayMask_: ImGuiColorEditFlags_ = 7340032;
pub const ImGuiColorEditFlags_DataTypeMask_: ImGuiColorEditFlags_ = 25165824;
pub const ImGuiColorEditFlags_PickerMask_: ImGuiColorEditFlags_ = 100663296;
pub const ImGuiColorEditFlags_InputMask_: ImGuiColorEditFlags_ = 402653184;
pub type ImGuiColorEditFlags_ = cty::c_uint;
pub const ImGuiSliderFlags_None: ImGuiSliderFlags_ = 0;
pub const ImGuiSliderFlags_AlwaysClamp: ImGuiSliderFlags_ = 16;
pub const ImGuiSliderFlags_Logarithmic: ImGuiSliderFlags_ = 32;
pub const ImGuiSliderFlags_NoRoundToFormat: ImGuiSliderFlags_ = 64;
pub const ImGuiSliderFlags_NoInput: ImGuiSliderFlags_ = 128;
pub const ImGuiSliderFlags_InvalidMask_: ImGuiSliderFlags_ = 1879048207;
pub type ImGuiSliderFlags_ = cty::c_uint;
pub const ImGuiMouseButton_Left: ImGuiMouseButton_ = 0;
pub const ImGuiMouseButton_Right: ImGuiMouseButton_ = 1;
pub const ImGuiMouseButton_Middle: ImGuiMouseButton_ = 2;
pub const ImGuiMouseButton_COUNT: ImGuiMouseButton_ = 5;
pub type ImGuiMouseButton_ = cty::c_uint;
pub const ImGuiMouseCursor_None: ImGuiMouseCursor_ = -1;
pub const ImGuiMouseCursor_Arrow: ImGuiMouseCursor_ = 0;
pub const ImGuiMouseCursor_TextInput: ImGuiMouseCursor_ = 1;
pub const ImGuiMouseCursor_ResizeAll: ImGuiMouseCursor_ = 2;
pub const ImGuiMouseCursor_ResizeNS: ImGuiMouseCursor_ = 3;
pub const ImGuiMouseCursor_ResizeEW: ImGuiMouseCursor_ = 4;
pub const ImGuiMouseCursor_ResizeNESW: ImGuiMouseCursor_ = 5;
pub const ImGuiMouseCursor_ResizeNWSE: ImGuiMouseCursor_ = 6;
pub const ImGuiMouseCursor_Hand: ImGuiMouseCursor_ = 7;
pub const ImGuiMouseCursor_NotAllowed: ImGuiMouseCursor_ = 8;
pub const ImGuiMouseCursor_COUNT: ImGuiMouseCursor_ = 9;
pub type ImGuiMouseCursor_ = cty::c_int;
pub const ImGuiCond_None: ImGuiCond_ = 0;
pub const ImGuiCond_Always: ImGuiCond_ = 1;
pub const ImGuiCond_Once: ImGuiCond_ = 2;
pub const ImGuiCond_FirstUseEver: ImGuiCond_ = 4;
pub const ImGuiCond_Appearing: ImGuiCond_ = 8;
pub type ImGuiCond_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiStyle {
    pub Alpha: f32,
    pub DisabledAlpha: f32,
    pub WindowPadding: ImVec2,
    pub WindowRounding: f32,
    pub WindowBorderSize: f32,
    pub WindowMinSize: ImVec2,
    pub WindowTitleAlign: ImVec2,
    pub WindowMenuButtonPosition: ImGuiDir,
    pub ChildRounding: f32,
    pub ChildBorderSize: f32,
    pub PopupRounding: f32,
    pub PopupBorderSize: f32,
    pub FramePadding: ImVec2,
    pub FrameRounding: f32,
    pub FrameBorderSize: f32,
    pub ItemSpacing: ImVec2,
    pub ItemInnerSpacing: ImVec2,
    pub CellPadding: ImVec2,
    pub TouchExtraPadding: ImVec2,
    pub IndentSpacing: f32,
    pub ColumnsMinSpacing: f32,
    pub ScrollbarSize: f32,
    pub ScrollbarRounding: f32,
    pub GrabMinSize: f32,
    pub GrabRounding: f32,
    pub LogSliderDeadzone: f32,
    pub TabRounding: f32,
    pub TabBorderSize: f32,
    pub TabMinWidthForCloseButton: f32,
    pub ColorButtonPosition: ImGuiDir,
    pub ButtonTextAlign: ImVec2,
    pub SelectableTextAlign: ImVec2,
    pub DisplayWindowPadding: ImVec2,
    pub DisplaySafeAreaPadding: ImVec2,
    pub MouseCursorScale: f32,
    pub AntiAliasedLines: bool,
    pub AntiAliasedLinesUseTex: bool,
    pub AntiAliasedFill: bool,
    pub CurveTessellationTol: f32,
    pub CircleTessellationMaxError: f32,
    pub Colors: [ImVec4; 55usize],
}
impl Default for ImGuiStyle {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiKeyData {
    pub Down: bool,
    pub DownDuration: f32,
    pub DownDurationPrev: f32,
    pub AnalogValue: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImWchar {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImWchar,
}
impl Default for ImVector_ImWchar {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiIO {
    pub ConfigFlags: ImGuiConfigFlags,
    pub BackendFlags: ImGuiBackendFlags,
    pub DisplaySize: ImVec2,
    pub DeltaTime: f32,
    pub IniSavingRate: f32,
    pub IniFilename: *const cty::c_char,
    pub LogFilename: *const cty::c_char,
    pub MouseDoubleClickTime: f32,
    pub MouseDoubleClickMaxDist: f32,
    pub MouseDragThreshold: f32,
    pub KeyRepeatDelay: f32,
    pub KeyRepeatRate: f32,
    pub HoverDelayNormal: f32,
    pub HoverDelayShort: f32,
    pub UserData: *mut cty::c_void,
    pub Fonts: *mut ImFontAtlas,
    pub FontGlobalScale: f32,
    pub FontAllowUserScaling: bool,
    pub FontDefault: *mut ImFont,
    pub DisplayFramebufferScale: ImVec2,
    pub ConfigDockingNoSplit: bool,
    pub ConfigDockingWithShift: bool,
    pub ConfigDockingAlwaysTabBar: bool,
    pub ConfigDockingTransparentPayload: bool,
    pub ConfigViewportsNoAutoMerge: bool,
    pub ConfigViewportsNoTaskBarIcon: bool,
    pub ConfigViewportsNoDecoration: bool,
    pub ConfigViewportsNoDefaultParent: bool,
    pub MouseDrawCursor: bool,
    pub ConfigMacOSXBehaviors: bool,
    pub ConfigInputTrickleEventQueue: bool,
    pub ConfigInputTextCursorBlink: bool,
    pub ConfigInputTextEnterKeepActive: bool,
    pub ConfigDragClickToInputText: bool,
    pub ConfigWindowsResizeFromEdges: bool,
    pub ConfigWindowsMoveFromTitleBarOnly: bool,
    pub ConfigMemoryCompactTimer: f32,
    pub BackendPlatformName: *const cty::c_char,
    pub BackendRendererName: *const cty::c_char,
    pub BackendPlatformUserData: *mut cty::c_void,
    pub BackendRendererUserData: *mut cty::c_void,
    pub BackendLanguageUserData: *mut cty::c_void,
    pub GetClipboardTextFn: ::core::option::Option<
        unsafe extern "C" fn(user_data: *mut cty::c_void) -> *const cty::c_char,
    >,
    pub SetClipboardTextFn: ::core::option::Option<
        unsafe extern "C" fn(user_data: *mut cty::c_void, text: *const cty::c_char),
    >,
    pub ClipboardUserData: *mut cty::c_void,
    pub SetPlatformImeDataFn: ::core::option::Option<
        unsafe extern "C" fn(viewport: *mut ImGuiViewport, data: *mut ImGuiPlatformImeData),
    >,
    pub _UnusedPadding: *mut cty::c_void,
    pub WantCaptureMouse: bool,
    pub WantCaptureKeyboard: bool,
    pub WantTextInput: bool,
    pub WantSetMousePos: bool,
    pub WantSaveIniSettings: bool,
    pub NavActive: bool,
    pub NavVisible: bool,
    pub Framerate: f32,
    pub MetricsRenderVertices: cty::c_int,
    pub MetricsRenderIndices: cty::c_int,
    pub MetricsRenderWindows: cty::c_int,
    pub MetricsActiveWindows: cty::c_int,
    pub MetricsActiveAllocations: cty::c_int,
    pub MouseDelta: ImVec2,
    pub KeyMap: [cty::c_int; 652usize],
    pub KeysDown: [bool; 652usize],
    pub NavInputs: [f32; 16usize],
    pub MousePos: ImVec2,
    pub MouseDown: [bool; 5usize],
    pub MouseWheel: f32,
    pub MouseWheelH: f32,
    pub MouseHoveredViewport: ImGuiID,
    pub KeyCtrl: bool,
    pub KeyShift: bool,
    pub KeyAlt: bool,
    pub KeySuper: bool,
    pub KeyMods: ImGuiKeyChord,
    pub KeysData: [ImGuiKeyData; 652usize],
    pub WantCaptureMouseUnlessPopupClose: bool,
    pub MousePosPrev: ImVec2,
    pub MouseClickedPos: [ImVec2; 5usize],
    pub MouseClickedTime: [f64; 5usize],
    pub MouseClicked: [bool; 5usize],
    pub MouseDoubleClicked: [bool; 5usize],
    pub MouseClickedCount: [ImU16; 5usize],
    pub MouseClickedLastCount: [ImU16; 5usize],
    pub MouseReleased: [bool; 5usize],
    pub MouseDownOwned: [bool; 5usize],
    pub MouseDownOwnedUnlessPopupClose: [bool; 5usize],
    pub MouseDownDuration: [f32; 5usize],
    pub MouseDownDurationPrev: [f32; 5usize],
    pub MouseDragMaxDistanceAbs: [ImVec2; 5usize],
    pub MouseDragMaxDistanceSqr: [f32; 5usize],
    pub PenPressure: f32,
    pub AppFocusLost: bool,
    pub AppAcceptingEvents: bool,
    pub BackendUsingLegacyKeyArrays: ImS8,
    pub BackendUsingLegacyNavInputArray: bool,
    pub InputQueueSurrogate: ImWchar16,
    pub InputQueueCharacters: ImVector_ImWchar,
}
impl Default for ImGuiIO {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiInputTextCallbackData {
    pub EventFlag: ImGuiInputTextFlags,
    pub Flags: ImGuiInputTextFlags,
    pub UserData: *mut cty::c_void,
    pub EventChar: ImWchar,
    pub EventKey: ImGuiKey,
    pub Buf: *mut cty::c_char,
    pub BufTextLen: cty::c_int,
    pub BufSize: cty::c_int,
    pub BufDirty: bool,
    pub CursorPos: cty::c_int,
    pub SelectionStart: cty::c_int,
    pub SelectionEnd: cty::c_int,
}
impl Default for ImGuiInputTextCallbackData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiSizeCallbackData {
    pub UserData: *mut cty::c_void,
    pub Pos: ImVec2,
    pub CurrentSize: ImVec2,
    pub DesiredSize: ImVec2,
}
impl Default for ImGuiSizeCallbackData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiWindowClass {
    pub ClassId: ImGuiID,
    pub ParentViewportId: ImGuiID,
    pub ViewportFlagsOverrideSet: ImGuiViewportFlags,
    pub ViewportFlagsOverrideClear: ImGuiViewportFlags,
    pub TabItemFlagsOverrideSet: ImGuiTabItemFlags,
    pub DockNodeFlagsOverrideSet: ImGuiDockNodeFlags,
    pub DockingAlwaysTabBar: bool,
    pub DockingAllowUnclassed: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiPayload {
    pub Data: *mut cty::c_void,
    pub DataSize: cty::c_int,
    pub SourceId: ImGuiID,
    pub SourceParentId: ImGuiID,
    pub DataFrameCount: cty::c_int,
    pub DataType: [cty::c_char; 33usize],
    pub Preview: bool,
    pub Delivery: bool,
}
impl Default for ImGuiPayload {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTableColumnSortSpecs {
    pub ColumnUserID: ImGuiID,
    pub ColumnIndex: ImS16,
    pub SortOrder: ImS16,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 3usize],
}
impl ImGuiTableColumnSortSpecs {
    #[inline]
    pub fn SortDirection(&self) -> ImGuiSortDirection {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_SortDirection(&mut self, val: ImGuiSortDirection) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        SortDirection: ImGuiSortDirection,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let SortDirection: u32 = unsafe { ::core::mem::transmute(SortDirection) };
            SortDirection as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTableSortSpecs {
    pub Specs: *const ImGuiTableColumnSortSpecs,
    pub SpecsCount: cty::c_int,
    pub SpecsDirty: bool,
}
impl Default for ImGuiTableSortSpecs {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiOnceUponAFrame {
    pub RefFrame: cty::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTextRange {
    pub b: *const cty::c_char,
    pub e: *const cty::c_char,
}
impl Default for ImGuiTextRange {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTextRange {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTextRange,
}
impl Default for ImVector_ImGuiTextRange {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTextFilter {
    pub InputBuf: [cty::c_char; 256usize],
    pub Filters: ImVector_ImGuiTextRange,
    pub CountGrep: cty::c_int,
}
impl Default for ImGuiTextFilter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_char {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut cty::c_char,
}
impl Default for ImVector_char {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTextBuffer {
    pub Buf: ImVector_char,
}
impl Default for ImGuiTextBuffer {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiStoragePair {
    pub key: ImGuiID,
    pub __bindgen_anon_1: ImGuiStoragePair__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ImGuiStoragePair__bindgen_ty_1 {
    pub val_i: cty::c_int,
    pub val_f: f32,
    pub val_p: *mut cty::c_void,
}
impl Default for ImGuiStoragePair__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::core::fmt::Debug for ImGuiStoragePair__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "ImGuiStoragePair__bindgen_ty_1 {{ union }}")
    }
}
impl Default for ImGuiStoragePair {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::core::fmt::Debug for ImGuiStoragePair {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "ImGuiStoragePair {{ key: {:?}, __bindgen_anon_1: {:?} }}",
            self.key, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiStoragePair {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiStoragePair,
}
impl Default for ImVector_ImGuiStoragePair {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiStorage {
    pub Data: ImVector_ImGuiStoragePair,
}
impl Default for ImGuiStorage {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiListClipper {
    pub DisplayStart: cty::c_int,
    pub DisplayEnd: cty::c_int,
    pub ItemsCount: cty::c_int,
    pub ItemsHeight: f32,
    pub StartPosY: f32,
    pub TempData: *mut cty::c_void,
}
impl Default for ImGuiListClipper {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImColor {
    pub Value: ImVec4,
}
pub type ImDrawCallback = ::core::option::Option<
    unsafe extern "C" fn(parent_list: *const ImDrawList, cmd: *const ImDrawCmd),
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawCmd {
    pub ClipRect: ImVec4,
    pub TextureId: ImTextureID,
    pub VtxOffset: cty::c_uint,
    pub IdxOffset: cty::c_uint,
    pub ElemCount: cty::c_uint,
    pub UserCallback: ImDrawCallback,
    pub UserCallbackData: *mut cty::c_void,
}
impl Default for ImDrawCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImDrawVert {
    pub pos: ImVec2,
    pub uv: ImVec2,
    pub col: ImU32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawCmdHeader {
    pub ClipRect: ImVec4,
    pub TextureId: ImTextureID,
    pub VtxOffset: cty::c_uint,
}
impl Default for ImDrawCmdHeader {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawCmd {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawCmd,
}
impl Default for ImVector_ImDrawCmd {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawIdx {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawIdx,
}
impl Default for ImVector_ImDrawIdx {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImDrawChannel {
    pub _CmdBuffer: ImVector_ImDrawCmd,
    pub _IdxBuffer: ImVector_ImDrawIdx,
}
impl Default for ImDrawChannel {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawChannel {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawChannel,
}
impl Default for ImVector_ImDrawChannel {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImDrawListSplitter {
    pub _Current: cty::c_int,
    pub _Count: cty::c_int,
    pub _Channels: ImVector_ImDrawChannel,
}
impl Default for ImDrawListSplitter {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImDrawFlags_None: ImDrawFlags_ = 0;
pub const ImDrawFlags_Closed: ImDrawFlags_ = 1;
pub const ImDrawFlags_RoundCornersTopLeft: ImDrawFlags_ = 16;
pub const ImDrawFlags_RoundCornersTopRight: ImDrawFlags_ = 32;
pub const ImDrawFlags_RoundCornersBottomLeft: ImDrawFlags_ = 64;
pub const ImDrawFlags_RoundCornersBottomRight: ImDrawFlags_ = 128;
pub const ImDrawFlags_RoundCornersNone: ImDrawFlags_ = 256;
pub const ImDrawFlags_RoundCornersTop: ImDrawFlags_ = 48;
pub const ImDrawFlags_RoundCornersBottom: ImDrawFlags_ = 192;
pub const ImDrawFlags_RoundCornersLeft: ImDrawFlags_ = 80;
pub const ImDrawFlags_RoundCornersRight: ImDrawFlags_ = 160;
pub const ImDrawFlags_RoundCornersAll: ImDrawFlags_ = 240;
pub const ImDrawFlags_RoundCornersDefault_: ImDrawFlags_ = 240;
pub const ImDrawFlags_RoundCornersMask_: ImDrawFlags_ = 496;
pub type ImDrawFlags_ = cty::c_uint;
pub const ImDrawListFlags_None: ImDrawListFlags_ = 0;
pub const ImDrawListFlags_AntiAliasedLines: ImDrawListFlags_ = 1;
pub const ImDrawListFlags_AntiAliasedLinesUseTex: ImDrawListFlags_ = 2;
pub const ImDrawListFlags_AntiAliasedFill: ImDrawListFlags_ = 4;
pub const ImDrawListFlags_AllowVtxOffset: ImDrawListFlags_ = 8;
pub type ImDrawListFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawVert {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImDrawVert,
}
impl Default for ImVector_ImDrawVert {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImVec4 {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImVec4,
}
impl Default for ImVector_ImVec4 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImTextureID {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImTextureID,
}
impl Default for ImVector_ImTextureID {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImVec2 {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImVec2,
}
impl Default for ImVector_ImVec2 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawList {
    pub CmdBuffer: ImVector_ImDrawCmd,
    pub IdxBuffer: ImVector_ImDrawIdx,
    pub VtxBuffer: ImVector_ImDrawVert,
    pub Flags: ImDrawListFlags,
    pub _VtxCurrentIdx: cty::c_uint,
    pub _Data: *mut ImDrawListSharedData,
    pub _OwnerName: *const cty::c_char,
    pub _VtxWritePtr: *mut ImDrawVert,
    pub _IdxWritePtr: *mut ImDrawIdx,
    pub _ClipRectStack: ImVector_ImVec4,
    pub _TextureIdStack: ImVector_ImTextureID,
    pub _Path: ImVector_ImVec2,
    pub _CmdHeader: ImDrawCmdHeader,
    pub _Splitter: ImDrawListSplitter,
    pub _FringeScale: f32,
}
impl Default for ImDrawList {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawData {
    pub Valid: bool,
    pub CmdListsCount: cty::c_int,
    pub TotalIdxCount: cty::c_int,
    pub TotalVtxCount: cty::c_int,
    pub CmdLists: *mut *mut ImDrawList,
    pub DisplayPos: ImVec2,
    pub DisplaySize: ImVec2,
    pub FramebufferScale: ImVec2,
    pub OwnerViewport: *mut ImGuiViewport,
}
impl Default for ImDrawData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImFontConfig {
    pub FontData: *mut cty::c_void,
    pub FontDataSize: cty::c_int,
    pub FontDataOwnedByAtlas: bool,
    pub FontNo: cty::c_int,
    pub SizePixels: f32,
    pub OversampleH: cty::c_int,
    pub OversampleV: cty::c_int,
    pub PixelSnapH: bool,
    pub GlyphExtraSpacing: ImVec2,
    pub GlyphOffset: ImVec2,
    pub GlyphRanges: *const ImWchar,
    pub GlyphMinAdvanceX: f32,
    pub GlyphMaxAdvanceX: f32,
    pub MergeMode: bool,
    pub FontBuilderFlags: cty::c_uint,
    pub RasterizerMultiply: f32,
    pub EllipsisChar: ImWchar,
    pub Name: [cty::c_char; 40usize],
    pub DstFont: *mut ImFont,
}
impl Default for ImFontConfig {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImFontGlyph {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub AdvanceX: f32,
    pub X0: f32,
    pub Y0: f32,
    pub X1: f32,
    pub Y1: f32,
    pub U0: f32,
    pub V0: f32,
    pub U1: f32,
    pub V1: f32,
}
impl ImFontGlyph {
    #[inline]
    pub fn Colored(&self) -> cty::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Colored(&mut self, val: cty::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Visible(&self) -> cty::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Visible(&mut self, val: cty::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Codepoint(&self) -> cty::c_uint {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set_Codepoint(&mut self, val: cty::c_uint) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        Colored: cty::c_uint,
        Visible: cty::c_uint,
        Codepoint: cty::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let Colored: u32 = unsafe { ::core::mem::transmute(Colored) };
            Colored as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let Visible: u32 = unsafe { ::core::mem::transmute(Visible) };
            Visible as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let Codepoint: u32 = unsafe { ::core::mem::transmute(Codepoint) };
            Codepoint as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImU32 {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImU32,
}
impl Default for ImVector_ImU32 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImFontGlyphRangesBuilder {
    pub UsedChars: ImVector_ImU32,
}
impl Default for ImFontGlyphRangesBuilder {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImFontAtlasCustomRect {
    pub Width: cty::c_ushort,
    pub Height: cty::c_ushort,
    pub X: cty::c_ushort,
    pub Y: cty::c_ushort,
    pub GlyphID: cty::c_uint,
    pub GlyphAdvanceX: f32,
    pub GlyphOffset: ImVec2,
    pub Font: *mut ImFont,
}
impl Default for ImFontAtlasCustomRect {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImFontAtlasFlags_None: ImFontAtlasFlags_ = 0;
pub const ImFontAtlasFlags_NoPowerOfTwoHeight: ImFontAtlasFlags_ = 1;
pub const ImFontAtlasFlags_NoMouseCursors: ImFontAtlasFlags_ = 2;
pub const ImFontAtlasFlags_NoBakedLines: ImFontAtlasFlags_ = 4;
pub type ImFontAtlasFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *mut ImFont,
}
impl Default for ImVector_ImFontPtr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontAtlasCustomRect {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImFontAtlasCustomRect,
}
impl Default for ImVector_ImFontAtlasCustomRect {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontConfig {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImFontConfig,
}
impl Default for ImVector_ImFontConfig {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImFontAtlas {
    pub Flags: ImFontAtlasFlags,
    pub TexID: ImTextureID,
    pub TexDesiredWidth: cty::c_int,
    pub TexGlyphPadding: cty::c_int,
    pub Locked: bool,
    pub UserData: *mut cty::c_void,
    pub TexReady: bool,
    pub TexPixelsUseColors: bool,
    pub TexPixelsAlpha8: *mut cty::c_uchar,
    pub TexPixelsRGBA32: *mut cty::c_uint,
    pub TexWidth: cty::c_int,
    pub TexHeight: cty::c_int,
    pub TexUvScale: ImVec2,
    pub TexUvWhitePixel: ImVec2,
    pub Fonts: ImVector_ImFontPtr,
    pub CustomRects: ImVector_ImFontAtlasCustomRect,
    pub ConfigData: ImVector_ImFontConfig,
    pub TexUvLines: [ImVec4; 64usize],
    pub FontBuilderIO: *const ImFontBuilderIO,
    pub FontBuilderFlags: cty::c_uint,
    pub PackIdMouseCursors: cty::c_int,
    pub PackIdLines: cty::c_int,
}
impl Default for ImFontAtlas {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_float {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut f32,
}
impl Default for ImVector_float {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImFontGlyph {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImFontGlyph,
}
impl Default for ImVector_ImFontGlyph {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImFont {
    pub IndexAdvanceX: ImVector_float,
    pub FallbackAdvanceX: f32,
    pub FontSize: f32,
    pub IndexLookup: ImVector_ImWchar,
    pub Glyphs: ImVector_ImFontGlyph,
    pub FallbackGlyph: *const ImFontGlyph,
    pub ContainerAtlas: *mut ImFontAtlas,
    pub ConfigData: *const ImFontConfig,
    pub ConfigDataCount: cty::c_short,
    pub FallbackChar: ImWchar,
    pub EllipsisChar: ImWchar,
    pub DotChar: ImWchar,
    pub DirtyLookupTables: bool,
    pub Scale: f32,
    pub Ascent: f32,
    pub Descent: f32,
    pub MetricsTotalSurface: cty::c_int,
    pub Used4kPagesMap: [ImU8; 34usize],
}
impl Default for ImFont {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiViewportFlags_None: ImGuiViewportFlags_ = 0;
pub const ImGuiViewportFlags_IsPlatformWindow: ImGuiViewportFlags_ = 1;
pub const ImGuiViewportFlags_IsPlatformMonitor: ImGuiViewportFlags_ = 2;
pub const ImGuiViewportFlags_OwnedByApp: ImGuiViewportFlags_ = 4;
pub const ImGuiViewportFlags_NoDecoration: ImGuiViewportFlags_ = 8;
pub const ImGuiViewportFlags_NoTaskBarIcon: ImGuiViewportFlags_ = 16;
pub const ImGuiViewportFlags_NoFocusOnAppearing: ImGuiViewportFlags_ = 32;
pub const ImGuiViewportFlags_NoFocusOnClick: ImGuiViewportFlags_ = 64;
pub const ImGuiViewportFlags_NoInputs: ImGuiViewportFlags_ = 128;
pub const ImGuiViewportFlags_NoRendererClear: ImGuiViewportFlags_ = 256;
pub const ImGuiViewportFlags_TopMost: ImGuiViewportFlags_ = 512;
pub const ImGuiViewportFlags_Minimized: ImGuiViewportFlags_ = 1024;
pub const ImGuiViewportFlags_NoAutoMerge: ImGuiViewportFlags_ = 2048;
pub const ImGuiViewportFlags_CanHostOtherWindows: ImGuiViewportFlags_ = 4096;
pub type ImGuiViewportFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiViewport {
    pub ID: ImGuiID,
    pub Flags: ImGuiViewportFlags,
    pub Pos: ImVec2,
    pub Size: ImVec2,
    pub WorkPos: ImVec2,
    pub WorkSize: ImVec2,
    pub DpiScale: f32,
    pub ParentViewportId: ImGuiID,
    pub DrawData: *mut ImDrawData,
    pub RendererUserData: *mut cty::c_void,
    pub PlatformUserData: *mut cty::c_void,
    pub PlatformHandle: *mut cty::c_void,
    pub PlatformHandleRaw: *mut cty::c_void,
    pub PlatformWindowCreated: bool,
    pub PlatformRequestMove: bool,
    pub PlatformRequestResize: bool,
    pub PlatformRequestClose: bool,
}
impl Default for ImGuiViewport {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiPlatformMonitor {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiPlatformMonitor,
}
impl Default for ImVector_ImGuiPlatformMonitor {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiViewportPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *mut ImGuiViewport,
}
impl Default for ImVector_ImGuiViewportPtr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiPlatformIO {
    pub Platform_CreateWindow: ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Platform_DestroyWindow:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Platform_ShowWindow: ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Platform_SetWindowPos:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport, pos: ImVec2)>,
    pub Platform_GetWindowPos:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport) -> ImVec2>,
    pub Platform_SetWindowSize:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport, size: ImVec2)>,
    pub Platform_GetWindowSize:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport) -> ImVec2>,
    pub Platform_SetWindowFocus:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Platform_GetWindowFocus:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport) -> bool>,
    pub Platform_GetWindowMinimized:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport) -> bool>,
    pub Platform_SetWindowTitle: ::core::option::Option<
        unsafe extern "C" fn(vp: *mut ImGuiViewport, str_: *const cty::c_char),
    >,
    pub Platform_SetWindowAlpha:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport, alpha: f32)>,
    pub Platform_UpdateWindow: ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Platform_RenderWindow: ::core::option::Option<
        unsafe extern "C" fn(vp: *mut ImGuiViewport, render_arg: *mut cty::c_void),
    >,
    pub Platform_SwapBuffers: ::core::option::Option<
        unsafe extern "C" fn(vp: *mut ImGuiViewport, render_arg: *mut cty::c_void),
    >,
    pub Platform_GetWindowDpiScale:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport) -> f32>,
    pub Platform_OnChangedViewport:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Platform_CreateVkSurface: ::core::option::Option<
        unsafe extern "C" fn(
            vp: *mut ImGuiViewport,
            vk_inst: ImU64,
            vk_allocators: *const cty::c_void,
            out_vk_surface: *mut ImU64,
        ) -> cty::c_int,
    >,
    pub Renderer_CreateWindow: ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Renderer_DestroyWindow:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport)>,
    pub Renderer_SetWindowSize:
        ::core::option::Option<unsafe extern "C" fn(vp: *mut ImGuiViewport, size: ImVec2)>,
    pub Renderer_RenderWindow: ::core::option::Option<
        unsafe extern "C" fn(vp: *mut ImGuiViewport, render_arg: *mut cty::c_void),
    >,
    pub Renderer_SwapBuffers: ::core::option::Option<
        unsafe extern "C" fn(vp: *mut ImGuiViewport, render_arg: *mut cty::c_void),
    >,
    pub Monitors: ImVector_ImGuiPlatformMonitor,
    pub Viewports: ImVector_ImGuiViewportPtr,
}
impl Default for ImGuiPlatformIO {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiPlatformMonitor {
    pub MainPos: ImVec2,
    pub MainSize: ImVec2,
    pub WorkPos: ImVec2,
    pub WorkSize: ImVec2,
    pub DpiScale: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiPlatformImeData {
    pub WantVisible: bool,
    pub InputPos: ImVec2,
    pub InputLineHeight: f32,
}
pub type ImGuiDataAuthority = cty::c_int;
pub type ImGuiLayoutType = cty::c_int;
pub type ImGuiActivateFlags = cty::c_int;
pub type ImGuiDebugLogFlags = cty::c_int;
pub type ImGuiInputFlags = cty::c_int;
pub type ImGuiItemFlags = cty::c_int;
pub type ImGuiItemStatusFlags = cty::c_int;
pub type ImGuiOldColumnFlags = cty::c_int;
pub type ImGuiNavHighlightFlags = cty::c_int;
pub type ImGuiNavMoveFlags = cty::c_int;
pub type ImGuiNextItemDataFlags = cty::c_int;
pub type ImGuiNextWindowDataFlags = cty::c_int;
pub type ImGuiScrollFlags = cty::c_int;
pub type ImGuiSeparatorFlags = cty::c_int;
pub type ImGuiTextFlags = cty::c_int;
pub type ImGuiTooltipFlags = cty::c_int;
pub type ImGuiErrorLogCallback = ::core::option::Option<
    unsafe extern "C" fn(user_data: *mut cty::c_void, fmt: *const cty::c_char, ...),
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct StbUndoRecord {
    pub where_: cty::c_int,
    pub insert_length: cty::c_int,
    pub delete_length: cty::c_int,
    pub char_storage: cty::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct StbUndoState {
    pub undo_rec: [StbUndoRecord; 99usize],
    pub undo_char: [ImWchar; 999usize],
    pub undo_point: cty::c_short,
    pub redo_point: cty::c_short,
    pub undo_char_point: cty::c_int,
    pub redo_char_point: cty::c_int,
}
impl Default for StbUndoState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct STB_TexteditState {
    pub cursor: cty::c_int,
    pub select_start: cty::c_int,
    pub select_end: cty::c_int,
    pub insert_mode: cty::c_uchar,
    pub row_count_per_page: cty::c_int,
    pub cursor_at_end_of_line: cty::c_uchar,
    pub initialized: cty::c_uchar,
    pub has_preferred_x: cty::c_uchar,
    pub single_line: cty::c_uchar,
    pub padding1: cty::c_uchar,
    pub padding2: cty::c_uchar,
    pub padding3: cty::c_uchar,
    pub preferred_x: f32,
    pub undostate: StbUndoState,
}
impl Default for STB_TexteditState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct StbTexteditRow {
    pub x0: f32,
    pub x1: f32,
    pub baseline_y_delta: f32,
    pub ymin: f32,
    pub ymax: f32,
    pub num_chars: cty::c_int,
}
pub type ImFileHandle = *mut FILE;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImVec1 {
    pub x: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVec2ih {
    pub x: cty::c_short,
    pub y: cty::c_short,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImRect {
    pub Min: ImVec2,
    pub Max: ImVec2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImBitVector {
    pub Storage: ImVector_ImU32,
}
impl Default for ImBitVector {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ImPoolIdx = cty::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_int {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut cty::c_int,
}
impl Default for ImVector_int {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTextIndex {
    pub LineOffsets: ImVector_int,
    pub EndOffset: cty::c_int,
}
impl Default for ImGuiTextIndex {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImDrawListSharedData {
    pub TexUvWhitePixel: ImVec2,
    pub Font: *mut ImFont,
    pub FontSize: f32,
    pub CurveTessellationTol: f32,
    pub CircleSegmentMaxError: f32,
    pub ClipRectFullscreen: ImVec4,
    pub InitialFlags: ImDrawListFlags,
    pub TempBuffer: ImVector_ImVec2,
    pub ArcFastVtx: [ImVec2; 48usize],
    pub ArcFastRadiusCutoff: f32,
    pub CircleSegmentCounts: [ImU8; 64usize],
    pub TexUvLines: *const ImVec4,
}
impl Default for ImDrawListSharedData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImDrawListPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *mut ImDrawList,
}
impl Default for ImVector_ImDrawListPtr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImDrawDataBuilder {
    pub Layers: [ImVector_ImDrawListPtr; 2usize],
}
impl Default for ImDrawDataBuilder {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiItemFlags_None: ImGuiItemFlags_ = 0;
pub const ImGuiItemFlags_NoTabStop: ImGuiItemFlags_ = 1;
pub const ImGuiItemFlags_ButtonRepeat: ImGuiItemFlags_ = 2;
pub const ImGuiItemFlags_Disabled: ImGuiItemFlags_ = 4;
pub const ImGuiItemFlags_NoNav: ImGuiItemFlags_ = 8;
pub const ImGuiItemFlags_NoNavDefaultFocus: ImGuiItemFlags_ = 16;
pub const ImGuiItemFlags_SelectableDontClosePopup: ImGuiItemFlags_ = 32;
pub const ImGuiItemFlags_MixedValue: ImGuiItemFlags_ = 64;
pub const ImGuiItemFlags_ReadOnly: ImGuiItemFlags_ = 128;
pub const ImGuiItemFlags_NoWindowHoverableCheck: ImGuiItemFlags_ = 256;
pub const ImGuiItemFlags_Inputable: ImGuiItemFlags_ = 1024;
pub type ImGuiItemFlags_ = cty::c_uint;
pub const ImGuiItemStatusFlags_None: ImGuiItemStatusFlags_ = 0;
pub const ImGuiItemStatusFlags_HoveredRect: ImGuiItemStatusFlags_ = 1;
pub const ImGuiItemStatusFlags_HasDisplayRect: ImGuiItemStatusFlags_ = 2;
pub const ImGuiItemStatusFlags_Edited: ImGuiItemStatusFlags_ = 4;
pub const ImGuiItemStatusFlags_ToggledSelection: ImGuiItemStatusFlags_ = 8;
pub const ImGuiItemStatusFlags_ToggledOpen: ImGuiItemStatusFlags_ = 16;
pub const ImGuiItemStatusFlags_HasDeactivated: ImGuiItemStatusFlags_ = 32;
pub const ImGuiItemStatusFlags_Deactivated: ImGuiItemStatusFlags_ = 64;
pub const ImGuiItemStatusFlags_HoveredWindow: ImGuiItemStatusFlags_ = 128;
pub const ImGuiItemStatusFlags_FocusedByTabbing: ImGuiItemStatusFlags_ = 256;
pub const ImGuiItemStatusFlags_Visible: ImGuiItemStatusFlags_ = 512;
pub type ImGuiItemStatusFlags_ = cty::c_uint;
pub const ImGuiInputTextFlags_Multiline: ImGuiInputTextFlagsPrivate_ = 67108864;
pub const ImGuiInputTextFlags_NoMarkEdited: ImGuiInputTextFlagsPrivate_ = 134217728;
pub const ImGuiInputTextFlags_MergedItem: ImGuiInputTextFlagsPrivate_ = 268435456;
pub type ImGuiInputTextFlagsPrivate_ = cty::c_uint;
pub const ImGuiButtonFlags_PressedOnClick: ImGuiButtonFlagsPrivate_ = 16;
pub const ImGuiButtonFlags_PressedOnClickRelease: ImGuiButtonFlagsPrivate_ = 32;
pub const ImGuiButtonFlags_PressedOnClickReleaseAnywhere: ImGuiButtonFlagsPrivate_ = 64;
pub const ImGuiButtonFlags_PressedOnRelease: ImGuiButtonFlagsPrivate_ = 128;
pub const ImGuiButtonFlags_PressedOnDoubleClick: ImGuiButtonFlagsPrivate_ = 256;
pub const ImGuiButtonFlags_PressedOnDragDropHold: ImGuiButtonFlagsPrivate_ = 512;
pub const ImGuiButtonFlags_Repeat: ImGuiButtonFlagsPrivate_ = 1024;
pub const ImGuiButtonFlags_FlattenChildren: ImGuiButtonFlagsPrivate_ = 2048;
pub const ImGuiButtonFlags_AllowItemOverlap: ImGuiButtonFlagsPrivate_ = 4096;
pub const ImGuiButtonFlags_DontClosePopups: ImGuiButtonFlagsPrivate_ = 8192;
pub const ImGuiButtonFlags_AlignTextBaseLine: ImGuiButtonFlagsPrivate_ = 32768;
pub const ImGuiButtonFlags_NoKeyModifiers: ImGuiButtonFlagsPrivate_ = 65536;
pub const ImGuiButtonFlags_NoHoldingActiveId: ImGuiButtonFlagsPrivate_ = 131072;
pub const ImGuiButtonFlags_NoNavFocus: ImGuiButtonFlagsPrivate_ = 262144;
pub const ImGuiButtonFlags_NoHoveredOnFocus: ImGuiButtonFlagsPrivate_ = 524288;
pub const ImGuiButtonFlags_NoSetKeyOwner: ImGuiButtonFlagsPrivate_ = 1048576;
pub const ImGuiButtonFlags_NoTestKeyOwner: ImGuiButtonFlagsPrivate_ = 2097152;
pub const ImGuiButtonFlags_PressedOnMask_: ImGuiButtonFlagsPrivate_ = 1008;
pub const ImGuiButtonFlags_PressedOnDefault_: ImGuiButtonFlagsPrivate_ = 32;
pub type ImGuiButtonFlagsPrivate_ = cty::c_uint;
pub const ImGuiComboFlags_CustomPreview: ImGuiComboFlagsPrivate_ = 1048576;
pub type ImGuiComboFlagsPrivate_ = cty::c_uint;
pub const ImGuiSliderFlags_Vertical: ImGuiSliderFlagsPrivate_ = 1048576;
pub const ImGuiSliderFlags_ReadOnly: ImGuiSliderFlagsPrivate_ = 2097152;
pub type ImGuiSliderFlagsPrivate_ = cty::c_uint;
pub const ImGuiSelectableFlags_NoHoldingActiveID: ImGuiSelectableFlagsPrivate_ = 1048576;
pub const ImGuiSelectableFlags_SelectOnNav: ImGuiSelectableFlagsPrivate_ = 2097152;
pub const ImGuiSelectableFlags_SelectOnClick: ImGuiSelectableFlagsPrivate_ = 4194304;
pub const ImGuiSelectableFlags_SelectOnRelease: ImGuiSelectableFlagsPrivate_ = 8388608;
pub const ImGuiSelectableFlags_SpanAvailWidth: ImGuiSelectableFlagsPrivate_ = 16777216;
pub const ImGuiSelectableFlags_SetNavIdOnHover: ImGuiSelectableFlagsPrivate_ = 33554432;
pub const ImGuiSelectableFlags_NoPadWithHalfSpacing: ImGuiSelectableFlagsPrivate_ = 67108864;
pub const ImGuiSelectableFlags_NoSetKeyOwner: ImGuiSelectableFlagsPrivate_ = 134217728;
pub type ImGuiSelectableFlagsPrivate_ = cty::c_uint;
pub const ImGuiTreeNodeFlags_ClipLabelForTrailingButton: ImGuiTreeNodeFlagsPrivate_ = 1048576;
pub type ImGuiTreeNodeFlagsPrivate_ = cty::c_uint;
pub const ImGuiSeparatorFlags_None: ImGuiSeparatorFlags_ = 0;
pub const ImGuiSeparatorFlags_Horizontal: ImGuiSeparatorFlags_ = 1;
pub const ImGuiSeparatorFlags_Vertical: ImGuiSeparatorFlags_ = 2;
pub const ImGuiSeparatorFlags_SpanAllColumns: ImGuiSeparatorFlags_ = 4;
pub type ImGuiSeparatorFlags_ = cty::c_uint;
pub const ImGuiTextFlags_None: ImGuiTextFlags_ = 0;
pub const ImGuiTextFlags_NoWidthForLargeClippedText: ImGuiTextFlags_ = 1;
pub type ImGuiTextFlags_ = cty::c_uint;
pub const ImGuiTooltipFlags_None: ImGuiTooltipFlags_ = 0;
pub const ImGuiTooltipFlags_OverridePreviousTooltip: ImGuiTooltipFlags_ = 1;
pub type ImGuiTooltipFlags_ = cty::c_uint;
pub const ImGuiLayoutType_Horizontal: ImGuiLayoutType_ = 0;
pub const ImGuiLayoutType_Vertical: ImGuiLayoutType_ = 1;
pub type ImGuiLayoutType_ = cty::c_uint;
pub const ImGuiLogType_None: ImGuiLogType = 0;
pub const ImGuiLogType_TTY: ImGuiLogType = 1;
pub const ImGuiLogType_File: ImGuiLogType = 2;
pub const ImGuiLogType_Buffer: ImGuiLogType = 3;
pub const ImGuiLogType_Clipboard: ImGuiLogType = 4;
pub type ImGuiLogType = cty::c_uint;
pub const ImGuiAxis_None: ImGuiAxis = -1;
pub const ImGuiAxis_X: ImGuiAxis = 0;
pub const ImGuiAxis_Y: ImGuiAxis = 1;
pub type ImGuiAxis = cty::c_int;
pub const ImGuiPlotType_Lines: ImGuiPlotType = 0;
pub const ImGuiPlotType_Histogram: ImGuiPlotType = 1;
pub type ImGuiPlotType = cty::c_uint;
pub const ImGuiPopupPositionPolicy_Default: ImGuiPopupPositionPolicy = 0;
pub const ImGuiPopupPositionPolicy_ComboBox: ImGuiPopupPositionPolicy = 1;
pub const ImGuiPopupPositionPolicy_Tooltip: ImGuiPopupPositionPolicy = 2;
pub type ImGuiPopupPositionPolicy = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiDataTypeTempStorage {
    pub Data: [ImU8; 8usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiDataTypeInfo {
    pub Size: usize,
    pub Name: *const cty::c_char,
    pub PrintFmt: *const cty::c_char,
    pub ScanFmt: *const cty::c_char,
}
impl Default for ImGuiDataTypeInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiDataType_String: ImGuiDataTypePrivate_ = 11;
pub const ImGuiDataType_Pointer: ImGuiDataTypePrivate_ = 12;
pub const ImGuiDataType_ID: ImGuiDataTypePrivate_ = 13;
pub type ImGuiDataTypePrivate_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiColorMod {
    pub Col: ImGuiCol,
    pub BackupValue: ImVec4,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiStyleMod {
    pub VarIdx: ImGuiStyleVar,
    pub __bindgen_anon_1: ImGuiStyleMod__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ImGuiStyleMod__bindgen_ty_1 {
    pub BackupInt: [cty::c_int; 2usize],
    pub BackupFloat: [f32; 2usize],
}
impl Default for ImGuiStyleMod__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::core::fmt::Debug for ImGuiStyleMod__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "ImGuiStyleMod__bindgen_ty_1 {{ union }}")
    }
}
impl Default for ImGuiStyleMod {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::core::fmt::Debug for ImGuiStyleMod {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "ImGuiStyleMod {{ VarIdx: {:?}, __bindgen_anon_1: {:?} }}",
            self.VarIdx, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiComboPreviewData {
    pub PreviewRect: ImRect,
    pub BackupCursorPos: ImVec2,
    pub BackupCursorMaxPos: ImVec2,
    pub BackupCursorPosPrevLine: ImVec2,
    pub BackupPrevLineTextBaseOffset: f32,
    pub BackupLayout: ImGuiLayoutType,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiGroupData {
    pub WindowID: ImGuiID,
    pub BackupCursorPos: ImVec2,
    pub BackupCursorMaxPos: ImVec2,
    pub BackupIndent: ImVec1,
    pub BackupGroupOffset: ImVec1,
    pub BackupCurrLineSize: ImVec2,
    pub BackupCurrLineTextBaseOffset: f32,
    pub BackupActiveIdIsAlive: ImGuiID,
    pub BackupActiveIdPreviousFrameIsAlive: bool,
    pub BackupHoveredIdIsAlive: bool,
    pub EmitItem: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiMenuColumns {
    pub TotalWidth: ImU32,
    pub NextTotalWidth: ImU32,
    pub Spacing: ImU16,
    pub OffsetIcon: ImU16,
    pub OffsetLabel: ImU16,
    pub OffsetShortcut: ImU16,
    pub OffsetMark: ImU16,
    pub Widths: [ImU16; 4usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiInputTextState {
    pub Ctx: *mut ImGuiContext,
    pub ID: ImGuiID,
    pub CurLenW: cty::c_int,
    pub CurLenA: cty::c_int,
    pub TextW: ImVector_ImWchar,
    pub TextA: ImVector_char,
    pub InitialTextA: ImVector_char,
    pub TextAIsValid: bool,
    pub BufCapacityA: cty::c_int,
    pub ScrollX: f32,
    pub Stb: STB_TexteditState,
    pub CursorAnim: f32,
    pub CursorFollow: bool,
    pub SelectedAllMouseLock: bool,
    pub Edited: bool,
    pub Flags: ImGuiInputTextFlags,
}
impl Default for ImGuiInputTextState {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiPopupData {
    pub PopupId: ImGuiID,
    pub Window: *mut ImGuiWindow,
    pub BackupNavWindow: *mut ImGuiWindow,
    pub ParentNavLayer: cty::c_int,
    pub OpenFrameCount: cty::c_int,
    pub OpenParentId: ImGuiID,
    pub OpenPopupPos: ImVec2,
    pub OpenMousePos: ImVec2,
}
impl Default for ImGuiPopupData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiNextWindowDataFlags_None: ImGuiNextWindowDataFlags_ = 0;
pub const ImGuiNextWindowDataFlags_HasPos: ImGuiNextWindowDataFlags_ = 1;
pub const ImGuiNextWindowDataFlags_HasSize: ImGuiNextWindowDataFlags_ = 2;
pub const ImGuiNextWindowDataFlags_HasContentSize: ImGuiNextWindowDataFlags_ = 4;
pub const ImGuiNextWindowDataFlags_HasCollapsed: ImGuiNextWindowDataFlags_ = 8;
pub const ImGuiNextWindowDataFlags_HasSizeConstraint: ImGuiNextWindowDataFlags_ = 16;
pub const ImGuiNextWindowDataFlags_HasFocus: ImGuiNextWindowDataFlags_ = 32;
pub const ImGuiNextWindowDataFlags_HasBgAlpha: ImGuiNextWindowDataFlags_ = 64;
pub const ImGuiNextWindowDataFlags_HasScroll: ImGuiNextWindowDataFlags_ = 128;
pub const ImGuiNextWindowDataFlags_HasViewport: ImGuiNextWindowDataFlags_ = 256;
pub const ImGuiNextWindowDataFlags_HasDock: ImGuiNextWindowDataFlags_ = 512;
pub const ImGuiNextWindowDataFlags_HasWindowClass: ImGuiNextWindowDataFlags_ = 1024;
pub type ImGuiNextWindowDataFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiNextWindowData {
    pub Flags: ImGuiNextWindowDataFlags,
    pub PosCond: ImGuiCond,
    pub SizeCond: ImGuiCond,
    pub CollapsedCond: ImGuiCond,
    pub DockCond: ImGuiCond,
    pub PosVal: ImVec2,
    pub PosPivotVal: ImVec2,
    pub SizeVal: ImVec2,
    pub ContentSizeVal: ImVec2,
    pub ScrollVal: ImVec2,
    pub PosUndock: bool,
    pub CollapsedVal: bool,
    pub SizeConstraintRect: ImRect,
    pub SizeCallback: ImGuiSizeCallback,
    pub SizeCallbackUserData: *mut cty::c_void,
    pub BgAlphaVal: f32,
    pub ViewportId: ImGuiID,
    pub DockId: ImGuiID,
    pub WindowClass: ImGuiWindowClass,
    pub MenuBarOffsetMinVal: ImVec2,
}
impl Default for ImGuiNextWindowData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiNextItemDataFlags_None: ImGuiNextItemDataFlags_ = 0;
pub const ImGuiNextItemDataFlags_HasWidth: ImGuiNextItemDataFlags_ = 1;
pub const ImGuiNextItemDataFlags_HasOpen: ImGuiNextItemDataFlags_ = 2;
pub type ImGuiNextItemDataFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiNextItemData {
    pub Flags: ImGuiNextItemDataFlags,
    pub Width: f32,
    pub FocusScopeId: ImGuiID,
    pub OpenCond: ImGuiCond,
    pub OpenVal: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiLastItemData {
    pub ID: ImGuiID,
    pub InFlags: ImGuiItemFlags,
    pub StatusFlags: ImGuiItemStatusFlags,
    pub Rect: ImRect,
    pub NavRect: ImRect,
    pub DisplayRect: ImRect,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiStackSizes {
    pub SizeOfIDStack: cty::c_short,
    pub SizeOfColorStack: cty::c_short,
    pub SizeOfStyleVarStack: cty::c_short,
    pub SizeOfFontStack: cty::c_short,
    pub SizeOfFocusScopeStack: cty::c_short,
    pub SizeOfGroupStack: cty::c_short,
    pub SizeOfItemFlagsStack: cty::c_short,
    pub SizeOfBeginPopupStack: cty::c_short,
    pub SizeOfDisabledStack: cty::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiWindowStackData {
    pub Window: *mut ImGuiWindow,
    pub ParentLastItemDataBackup: ImGuiLastItemData,
    pub StackSizesOnBegin: ImGuiStackSizes,
}
impl Default for ImGuiWindowStackData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiShrinkWidthItem {
    pub Index: cty::c_int,
    pub Width: f32,
    pub InitialWidth: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiPtrOrIndex {
    pub Ptr: *mut cty::c_void,
    pub Index: cty::c_int,
}
impl Default for ImGuiPtrOrIndex {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiInputEventType_None: ImGuiInputEventType = 0;
pub const ImGuiInputEventType_MousePos: ImGuiInputEventType = 1;
pub const ImGuiInputEventType_MouseWheel: ImGuiInputEventType = 2;
pub const ImGuiInputEventType_MouseButton: ImGuiInputEventType = 3;
pub const ImGuiInputEventType_MouseViewport: ImGuiInputEventType = 4;
pub const ImGuiInputEventType_Key: ImGuiInputEventType = 5;
pub const ImGuiInputEventType_Text: ImGuiInputEventType = 6;
pub const ImGuiInputEventType_Focus: ImGuiInputEventType = 7;
pub const ImGuiInputEventType_COUNT: ImGuiInputEventType = 8;
pub type ImGuiInputEventType = cty::c_uint;
pub const ImGuiInputSource_None: ImGuiInputSource = 0;
pub const ImGuiInputSource_Mouse: ImGuiInputSource = 1;
pub const ImGuiInputSource_Keyboard: ImGuiInputSource = 2;
pub const ImGuiInputSource_Gamepad: ImGuiInputSource = 3;
pub const ImGuiInputSource_Clipboard: ImGuiInputSource = 4;
pub const ImGuiInputSource_Nav: ImGuiInputSource = 5;
pub const ImGuiInputSource_COUNT: ImGuiInputSource = 6;
pub type ImGuiInputSource = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiInputEventMousePos {
    pub PosX: f32,
    pub PosY: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiInputEventMouseWheel {
    pub WheelX: f32,
    pub WheelY: f32,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiInputEventMouseButton {
    pub Button: cty::c_int,
    pub Down: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiInputEventMouseViewport {
    pub HoveredViewportID: ImGuiID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiInputEventKey {
    pub Key: ImGuiKey,
    pub Down: bool,
    pub AnalogValue: f32,
}
impl Default for ImGuiInputEventKey {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiInputEventText {
    pub Char: cty::c_uint,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiInputEventAppFocused {
    pub Focused: bool,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct ImGuiInputEvent {
    pub Type: ImGuiInputEventType,
    pub Source: ImGuiInputSource,
    pub __bindgen_anon_1: ImGuiInputEvent__bindgen_ty_1,
    pub AddedByTestEngine: bool,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union ImGuiInputEvent__bindgen_ty_1 {
    pub MousePos: ImGuiInputEventMousePos,
    pub MouseWheel: ImGuiInputEventMouseWheel,
    pub MouseButton: ImGuiInputEventMouseButton,
    pub MouseViewport: ImGuiInputEventMouseViewport,
    pub Key: ImGuiInputEventKey,
    pub Text: ImGuiInputEventText,
    pub AppFocused: ImGuiInputEventAppFocused,
}
impl Default for ImGuiInputEvent__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::core::fmt::Debug for ImGuiInputEvent__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "ImGuiInputEvent__bindgen_ty_1 {{ union }}")
    }
}
impl Default for ImGuiInputEvent {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ::core::fmt::Debug for ImGuiInputEvent {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "ImGuiInputEvent {{ Type: {:?}, Source: {:?}, __bindgen_anon_1: {:?}, AddedByTestEngine: {:?} }}" , self . Type , self . Source , self . __bindgen_anon_1 , self . AddedByTestEngine)
    }
}
pub type ImGuiKeyRoutingIndex = ImS16;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiKeyRoutingData {
    pub NextEntryIndex: ImGuiKeyRoutingIndex,
    pub Mods: ImU16,
    pub RoutingNextScore: ImU8,
    pub RoutingCurr: ImGuiID,
    pub RoutingNext: ImGuiID,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiKeyRoutingData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiKeyRoutingData,
}
impl Default for ImVector_ImGuiKeyRoutingData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiKeyRoutingTable {
    pub Index: [ImGuiKeyRoutingIndex; 140usize],
    pub Entries: ImVector_ImGuiKeyRoutingData,
    pub EntriesNext: ImVector_ImGuiKeyRoutingData,
}
impl Default for ImGuiKeyRoutingTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiKeyOwnerData {
    pub OwnerCurr: ImGuiID,
    pub OwnerNext: ImGuiID,
    pub LockThisFrame: bool,
    pub LockUntilRelease: bool,
}
pub const ImGuiInputFlags_None: ImGuiInputFlags_ = 0;
pub const ImGuiInputFlags_Repeat: ImGuiInputFlags_ = 1;
pub const ImGuiInputFlags_RepeatRateDefault: ImGuiInputFlags_ = 2;
pub const ImGuiInputFlags_RepeatRateNavMove: ImGuiInputFlags_ = 4;
pub const ImGuiInputFlags_RepeatRateNavTweak: ImGuiInputFlags_ = 8;
pub const ImGuiInputFlags_RepeatRateMask_: ImGuiInputFlags_ = 14;
pub const ImGuiInputFlags_CondHovered: ImGuiInputFlags_ = 16;
pub const ImGuiInputFlags_CondActive: ImGuiInputFlags_ = 32;
pub const ImGuiInputFlags_CondDefault_: ImGuiInputFlags_ = 48;
pub const ImGuiInputFlags_CondMask_: ImGuiInputFlags_ = 48;
pub const ImGuiInputFlags_LockThisFrame: ImGuiInputFlags_ = 64;
pub const ImGuiInputFlags_LockUntilRelease: ImGuiInputFlags_ = 128;
pub const ImGuiInputFlags_RouteFocused: ImGuiInputFlags_ = 256;
pub const ImGuiInputFlags_RouteGlobalLow: ImGuiInputFlags_ = 512;
pub const ImGuiInputFlags_RouteGlobal: ImGuiInputFlags_ = 1024;
pub const ImGuiInputFlags_RouteGlobalHigh: ImGuiInputFlags_ = 2048;
pub const ImGuiInputFlags_RouteMask_: ImGuiInputFlags_ = 3840;
pub const ImGuiInputFlags_RouteAlways: ImGuiInputFlags_ = 4096;
pub const ImGuiInputFlags_RouteUnlessBgFocused: ImGuiInputFlags_ = 8192;
pub const ImGuiInputFlags_RouteExtraMask_: ImGuiInputFlags_ = 12288;
pub const ImGuiInputFlags_SupportedByIsKeyPressed: ImGuiInputFlags_ = 15;
pub const ImGuiInputFlags_SupportedByShortcut: ImGuiInputFlags_ = 16143;
pub const ImGuiInputFlags_SupportedBySetKeyOwner: ImGuiInputFlags_ = 192;
pub const ImGuiInputFlags_SupportedBySetItemKeyOwner: ImGuiInputFlags_ = 240;
pub type ImGuiInputFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiListClipperRange {
    pub Min: cty::c_int,
    pub Max: cty::c_int,
    pub PosToIndexConvert: bool,
    pub PosToIndexOffsetMin: ImS8,
    pub PosToIndexOffsetMax: ImS8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiListClipperRange {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiListClipperRange,
}
impl Default for ImVector_ImGuiListClipperRange {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiListClipperData {
    pub ListClipper: *mut ImGuiListClipper,
    pub LossynessOffset: f32,
    pub StepNo: cty::c_int,
    pub ItemsFrozen: cty::c_int,
    pub Ranges: ImVector_ImGuiListClipperRange,
}
impl Default for ImGuiListClipperData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiActivateFlags_None: ImGuiActivateFlags_ = 0;
pub const ImGuiActivateFlags_PreferInput: ImGuiActivateFlags_ = 1;
pub const ImGuiActivateFlags_PreferTweak: ImGuiActivateFlags_ = 2;
pub const ImGuiActivateFlags_TryToPreserveState: ImGuiActivateFlags_ = 4;
pub type ImGuiActivateFlags_ = cty::c_uint;
pub const ImGuiScrollFlags_None: ImGuiScrollFlags_ = 0;
pub const ImGuiScrollFlags_KeepVisibleEdgeX: ImGuiScrollFlags_ = 1;
pub const ImGuiScrollFlags_KeepVisibleEdgeY: ImGuiScrollFlags_ = 2;
pub const ImGuiScrollFlags_KeepVisibleCenterX: ImGuiScrollFlags_ = 4;
pub const ImGuiScrollFlags_KeepVisibleCenterY: ImGuiScrollFlags_ = 8;
pub const ImGuiScrollFlags_AlwaysCenterX: ImGuiScrollFlags_ = 16;
pub const ImGuiScrollFlags_AlwaysCenterY: ImGuiScrollFlags_ = 32;
pub const ImGuiScrollFlags_NoScrollParent: ImGuiScrollFlags_ = 64;
pub const ImGuiScrollFlags_MaskX_: ImGuiScrollFlags_ = 21;
pub const ImGuiScrollFlags_MaskY_: ImGuiScrollFlags_ = 42;
pub type ImGuiScrollFlags_ = cty::c_uint;
pub const ImGuiNavHighlightFlags_None: ImGuiNavHighlightFlags_ = 0;
pub const ImGuiNavHighlightFlags_TypeDefault: ImGuiNavHighlightFlags_ = 1;
pub const ImGuiNavHighlightFlags_TypeThin: ImGuiNavHighlightFlags_ = 2;
pub const ImGuiNavHighlightFlags_AlwaysDraw: ImGuiNavHighlightFlags_ = 4;
pub const ImGuiNavHighlightFlags_NoRounding: ImGuiNavHighlightFlags_ = 8;
pub type ImGuiNavHighlightFlags_ = cty::c_uint;
pub const ImGuiNavMoveFlags_None: ImGuiNavMoveFlags_ = 0;
pub const ImGuiNavMoveFlags_LoopX: ImGuiNavMoveFlags_ = 1;
pub const ImGuiNavMoveFlags_LoopY: ImGuiNavMoveFlags_ = 2;
pub const ImGuiNavMoveFlags_WrapX: ImGuiNavMoveFlags_ = 4;
pub const ImGuiNavMoveFlags_WrapY: ImGuiNavMoveFlags_ = 8;
pub const ImGuiNavMoveFlags_AllowCurrentNavId: ImGuiNavMoveFlags_ = 16;
pub const ImGuiNavMoveFlags_AlsoScoreVisibleSet: ImGuiNavMoveFlags_ = 32;
pub const ImGuiNavMoveFlags_ScrollToEdgeY: ImGuiNavMoveFlags_ = 64;
pub const ImGuiNavMoveFlags_Forwarded: ImGuiNavMoveFlags_ = 128;
pub const ImGuiNavMoveFlags_DebugNoResult: ImGuiNavMoveFlags_ = 256;
pub const ImGuiNavMoveFlags_FocusApi: ImGuiNavMoveFlags_ = 512;
pub const ImGuiNavMoveFlags_Tabbing: ImGuiNavMoveFlags_ = 1024;
pub const ImGuiNavMoveFlags_Activate: ImGuiNavMoveFlags_ = 2048;
pub const ImGuiNavMoveFlags_DontSetNavHighlight: ImGuiNavMoveFlags_ = 4096;
pub type ImGuiNavMoveFlags_ = cty::c_uint;
pub const ImGuiNavLayer_Main: ImGuiNavLayer = 0;
pub const ImGuiNavLayer_Menu: ImGuiNavLayer = 1;
pub const ImGuiNavLayer_COUNT: ImGuiNavLayer = 2;
pub type ImGuiNavLayer = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiNavItemData {
    pub Window: *mut ImGuiWindow,
    pub ID: ImGuiID,
    pub FocusScopeId: ImGuiID,
    pub RectRel: ImRect,
    pub InFlags: ImGuiItemFlags,
    pub DistBox: f32,
    pub DistCenter: f32,
    pub DistAxial: f32,
}
impl Default for ImGuiNavItemData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiOldColumnFlags_None: ImGuiOldColumnFlags_ = 0;
pub const ImGuiOldColumnFlags_NoBorder: ImGuiOldColumnFlags_ = 1;
pub const ImGuiOldColumnFlags_NoResize: ImGuiOldColumnFlags_ = 2;
pub const ImGuiOldColumnFlags_NoPreserveWidths: ImGuiOldColumnFlags_ = 4;
pub const ImGuiOldColumnFlags_NoForceWithinWindow: ImGuiOldColumnFlags_ = 8;
pub const ImGuiOldColumnFlags_GrowParentContentsSize: ImGuiOldColumnFlags_ = 16;
pub type ImGuiOldColumnFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiOldColumnData {
    pub OffsetNorm: f32,
    pub OffsetNormBeforeResize: f32,
    pub Flags: ImGuiOldColumnFlags,
    pub ClipRect: ImRect,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiOldColumnData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiOldColumnData,
}
impl Default for ImVector_ImGuiOldColumnData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiOldColumns {
    pub ID: ImGuiID,
    pub Flags: ImGuiOldColumnFlags,
    pub IsFirstFrame: bool,
    pub IsBeingResized: bool,
    pub Current: cty::c_int,
    pub Count: cty::c_int,
    pub OffMinX: f32,
    pub OffMaxX: f32,
    pub LineMinY: f32,
    pub LineMaxY: f32,
    pub HostCursorPosY: f32,
    pub HostCursorMaxPosX: f32,
    pub HostInitialClipRect: ImRect,
    pub HostBackupClipRect: ImRect,
    pub HostBackupParentWorkRect: ImRect,
    pub Columns: ImVector_ImGuiOldColumnData,
    pub Splitter: ImDrawListSplitter,
}
impl Default for ImGuiOldColumns {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiDockNodeFlags_DockSpace: ImGuiDockNodeFlagsPrivate_ = 1024;
pub const ImGuiDockNodeFlags_CentralNode: ImGuiDockNodeFlagsPrivate_ = 2048;
pub const ImGuiDockNodeFlags_NoTabBar: ImGuiDockNodeFlagsPrivate_ = 4096;
pub const ImGuiDockNodeFlags_HiddenTabBar: ImGuiDockNodeFlagsPrivate_ = 8192;
pub const ImGuiDockNodeFlags_NoWindowMenuButton: ImGuiDockNodeFlagsPrivate_ = 16384;
pub const ImGuiDockNodeFlags_NoCloseButton: ImGuiDockNodeFlagsPrivate_ = 32768;
pub const ImGuiDockNodeFlags_NoDocking: ImGuiDockNodeFlagsPrivate_ = 65536;
pub const ImGuiDockNodeFlags_NoDockingSplitMe: ImGuiDockNodeFlagsPrivate_ = 131072;
pub const ImGuiDockNodeFlags_NoDockingSplitOther: ImGuiDockNodeFlagsPrivate_ = 262144;
pub const ImGuiDockNodeFlags_NoDockingOverMe: ImGuiDockNodeFlagsPrivate_ = 524288;
pub const ImGuiDockNodeFlags_NoDockingOverOther: ImGuiDockNodeFlagsPrivate_ = 1048576;
pub const ImGuiDockNodeFlags_NoDockingOverEmpty: ImGuiDockNodeFlagsPrivate_ = 2097152;
pub const ImGuiDockNodeFlags_NoResizeX: ImGuiDockNodeFlagsPrivate_ = 4194304;
pub const ImGuiDockNodeFlags_NoResizeY: ImGuiDockNodeFlagsPrivate_ = 8388608;
pub const ImGuiDockNodeFlags_SharedFlagsInheritMask_: ImGuiDockNodeFlagsPrivate_ = -1;
pub const ImGuiDockNodeFlags_NoResizeFlagsMask_: ImGuiDockNodeFlagsPrivate_ = 12582944;
pub const ImGuiDockNodeFlags_LocalFlagsMask_: ImGuiDockNodeFlagsPrivate_ = 12713072;
pub const ImGuiDockNodeFlags_LocalFlagsTransferMask_: ImGuiDockNodeFlagsPrivate_ = 12712048;
pub const ImGuiDockNodeFlags_SavedFlagsMask_: ImGuiDockNodeFlagsPrivate_ = 12712992;
pub type ImGuiDockNodeFlagsPrivate_ = cty::c_int;
pub const ImGuiDataAuthority_Auto: ImGuiDataAuthority_ = 0;
pub const ImGuiDataAuthority_DockNode: ImGuiDataAuthority_ = 1;
pub const ImGuiDataAuthority_Window: ImGuiDataAuthority_ = 2;
pub type ImGuiDataAuthority_ = cty::c_uint;
pub const ImGuiDockNodeState_Unknown: ImGuiDockNodeState = 0;
pub const ImGuiDockNodeState_HostWindowHiddenBecauseSingleWindow: ImGuiDockNodeState = 1;
pub const ImGuiDockNodeState_HostWindowHiddenBecauseWindowsAreResizing: ImGuiDockNodeState = 2;
pub const ImGuiDockNodeState_HostWindowVisible: ImGuiDockNodeState = 3;
pub type ImGuiDockNodeState = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiWindowPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *mut ImGuiWindow,
}
impl Default for ImVector_ImGuiWindowPtr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiDockNode {
    pub ID: ImGuiID,
    pub SharedFlags: ImGuiDockNodeFlags,
    pub LocalFlags: ImGuiDockNodeFlags,
    pub LocalFlagsInWindows: ImGuiDockNodeFlags,
    pub MergedFlags: ImGuiDockNodeFlags,
    pub State: ImGuiDockNodeState,
    pub ParentNode: *mut ImGuiDockNode,
    pub ChildNodes: [*mut ImGuiDockNode; 2usize],
    pub Windows: ImVector_ImGuiWindowPtr,
    pub TabBar: *mut ImGuiTabBar,
    pub Pos: ImVec2,
    pub Size: ImVec2,
    pub SizeRef: ImVec2,
    pub SplitAxis: ImGuiAxis,
    pub WindowClass: ImGuiWindowClass,
    pub LastBgColor: ImU32,
    pub HostWindow: *mut ImGuiWindow,
    pub VisibleWindow: *mut ImGuiWindow,
    pub CentralNode: *mut ImGuiDockNode,
    pub OnlyNodeWithWindows: *mut ImGuiDockNode,
    pub CountNodeWithWindows: cty::c_int,
    pub LastFrameAlive: cty::c_int,
    pub LastFrameActive: cty::c_int,
    pub LastFrameFocused: cty::c_int,
    pub LastFocusedNodeId: ImGuiID,
    pub SelectedTabId: ImGuiID,
    pub WantCloseTabId: ImGuiID,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 3usize]>,
    pub __bindgen_padding_0: u8,
}
impl Default for ImGuiDockNode {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ImGuiDockNode {
    #[inline]
    pub fn AuthorityForPos(&self) -> ImGuiDataAuthority {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_AuthorityForPos(&mut self, val: ImGuiDataAuthority) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn AuthorityForSize(&self) -> ImGuiDataAuthority {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_AuthorityForSize(&mut self, val: ImGuiDataAuthority) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn AuthorityForViewport(&self) -> ImGuiDataAuthority {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(6usize, 3u8) as u32) }
    }
    #[inline]
    pub fn set_AuthorityForViewport(&mut self, val: ImGuiDataAuthority) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(6usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn IsVisible(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_IsVisible(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IsFocused(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_IsFocused(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IsBgDrawnThisFrame(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_IsBgDrawnThisFrame(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn HasCloseButton(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_HasCloseButton(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn HasWindowMenuButton(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_HasWindowMenuButton(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn HasCentralNodeChild(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_HasCentralNodeChild(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn WantCloseAll(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_WantCloseAll(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn WantLockSizeOnce(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_WantLockSizeOnce(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn WantMouseMove(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(17usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_WantMouseMove(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(17usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn WantHiddenTabBarUpdate(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(18usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_WantHiddenTabBarUpdate(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(18usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn WantHiddenTabBarToggle(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(19usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_WantHiddenTabBarToggle(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(19usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        AuthorityForPos: ImGuiDataAuthority,
        AuthorityForSize: ImGuiDataAuthority,
        AuthorityForViewport: ImGuiDataAuthority,
        IsVisible: bool,
        IsFocused: bool,
        IsBgDrawnThisFrame: bool,
        HasCloseButton: bool,
        HasWindowMenuButton: bool,
        HasCentralNodeChild: bool,
        WantCloseAll: bool,
        WantLockSizeOnce: bool,
        WantMouseMove: bool,
        WantHiddenTabBarUpdate: bool,
        WantHiddenTabBarToggle: bool,
    ) -> __BindgenBitfieldUnit<[u8; 3usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 3usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let AuthorityForPos: u32 = unsafe { ::core::mem::transmute(AuthorityForPos) };
            AuthorityForPos as u64
        });
        __bindgen_bitfield_unit.set(3usize, 3u8, {
            let AuthorityForSize: u32 = unsafe { ::core::mem::transmute(AuthorityForSize) };
            AuthorityForSize as u64
        });
        __bindgen_bitfield_unit.set(6usize, 3u8, {
            let AuthorityForViewport: u32 = unsafe { ::core::mem::transmute(AuthorityForViewport) };
            AuthorityForViewport as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let IsVisible: u8 = unsafe { ::core::mem::transmute(IsVisible) };
            IsVisible as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let IsFocused: u8 = unsafe { ::core::mem::transmute(IsFocused) };
            IsFocused as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let IsBgDrawnThisFrame: u8 = unsafe { ::core::mem::transmute(IsBgDrawnThisFrame) };
            IsBgDrawnThisFrame as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let HasCloseButton: u8 = unsafe { ::core::mem::transmute(HasCloseButton) };
            HasCloseButton as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let HasWindowMenuButton: u8 = unsafe { ::core::mem::transmute(HasWindowMenuButton) };
            HasWindowMenuButton as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let HasCentralNodeChild: u8 = unsafe { ::core::mem::transmute(HasCentralNodeChild) };
            HasCentralNodeChild as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let WantCloseAll: u8 = unsafe { ::core::mem::transmute(WantCloseAll) };
            WantCloseAll as u64
        });
        __bindgen_bitfield_unit.set(16usize, 1u8, {
            let WantLockSizeOnce: u8 = unsafe { ::core::mem::transmute(WantLockSizeOnce) };
            WantLockSizeOnce as u64
        });
        __bindgen_bitfield_unit.set(17usize, 1u8, {
            let WantMouseMove: u8 = unsafe { ::core::mem::transmute(WantMouseMove) };
            WantMouseMove as u64
        });
        __bindgen_bitfield_unit.set(18usize, 1u8, {
            let WantHiddenTabBarUpdate: u8 =
                unsafe { ::core::mem::transmute(WantHiddenTabBarUpdate) };
            WantHiddenTabBarUpdate as u64
        });
        __bindgen_bitfield_unit.set(19usize, 1u8, {
            let WantHiddenTabBarToggle: u8 =
                unsafe { ::core::mem::transmute(WantHiddenTabBarToggle) };
            WantHiddenTabBarToggle as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const ImGuiWindowDockStyleCol_Text: ImGuiWindowDockStyleCol = 0;
pub const ImGuiWindowDockStyleCol_Tab: ImGuiWindowDockStyleCol = 1;
pub const ImGuiWindowDockStyleCol_TabHovered: ImGuiWindowDockStyleCol = 2;
pub const ImGuiWindowDockStyleCol_TabActive: ImGuiWindowDockStyleCol = 3;
pub const ImGuiWindowDockStyleCol_TabUnfocused: ImGuiWindowDockStyleCol = 4;
pub const ImGuiWindowDockStyleCol_TabUnfocusedActive: ImGuiWindowDockStyleCol = 5;
pub const ImGuiWindowDockStyleCol_COUNT: ImGuiWindowDockStyleCol = 6;
pub type ImGuiWindowDockStyleCol = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiWindowDockStyle {
    pub Colors: [ImU32; 6usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiDockRequest {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiDockRequest,
}
impl Default for ImVector_ImGuiDockRequest {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiDockNodeSettings {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiDockNodeSettings,
}
impl Default for ImVector_ImGuiDockNodeSettings {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiDockContext {
    pub Nodes: ImGuiStorage,
    pub Requests: ImVector_ImGuiDockRequest,
    pub NodesSettings: ImVector_ImGuiDockNodeSettings,
    pub WantFullRebuild: bool,
}
impl Default for ImGuiDockContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiViewportP {
    pub _ImGuiViewport: ImGuiViewport,
    pub Idx: cty::c_int,
    pub LastFrameActive: cty::c_int,
    pub LastFrontMostStampCount: cty::c_int,
    pub LastNameHash: ImGuiID,
    pub LastPos: ImVec2,
    pub Alpha: f32,
    pub LastAlpha: f32,
    pub PlatformMonitor: cty::c_short,
    pub Window: *mut ImGuiWindow,
    pub DrawListsLastFrame: [cty::c_int; 2usize],
    pub DrawLists: [*mut ImDrawList; 2usize],
    pub DrawDataP: ImDrawData,
    pub DrawDataBuilder: ImDrawDataBuilder,
    pub LastPlatformPos: ImVec2,
    pub LastPlatformSize: ImVec2,
    pub LastRendererSize: ImVec2,
    pub WorkOffsetMin: ImVec2,
    pub WorkOffsetMax: ImVec2,
    pub BuildWorkOffsetMin: ImVec2,
    pub BuildWorkOffsetMax: ImVec2,
}
impl Default for ImGuiViewportP {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiWindowSettings {
    pub ID: ImGuiID,
    pub Pos: ImVec2ih,
    pub Size: ImVec2ih,
    pub ViewportPos: ImVec2ih,
    pub ViewportId: ImGuiID,
    pub DockId: ImGuiID,
    pub ClassId: ImGuiID,
    pub DockOrder: cty::c_short,
    pub Collapsed: bool,
    pub WantApply: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiSettingsHandler {
    pub TypeName: *const cty::c_char,
    pub TypeHash: ImGuiID,
    pub ClearAllFn: ::core::option::Option<
        unsafe extern "C" fn(ctx: *mut ImGuiContext, handler: *mut ImGuiSettingsHandler),
    >,
    pub ReadInitFn: ::core::option::Option<
        unsafe extern "C" fn(ctx: *mut ImGuiContext, handler: *mut ImGuiSettingsHandler),
    >,
    pub ReadOpenFn: ::core::option::Option<
        unsafe extern "C" fn(
            ctx: *mut ImGuiContext,
            handler: *mut ImGuiSettingsHandler,
            name: *const cty::c_char,
        ) -> *mut cty::c_void,
    >,
    pub ReadLineFn: ::core::option::Option<
        unsafe extern "C" fn(
            ctx: *mut ImGuiContext,
            handler: *mut ImGuiSettingsHandler,
            entry: *mut cty::c_void,
            line: *const cty::c_char,
        ),
    >,
    pub ApplyAllFn: ::core::option::Option<
        unsafe extern "C" fn(ctx: *mut ImGuiContext, handler: *mut ImGuiSettingsHandler),
    >,
    pub WriteAllFn: ::core::option::Option<
        unsafe extern "C" fn(
            ctx: *mut ImGuiContext,
            handler: *mut ImGuiSettingsHandler,
            out_buf: *mut ImGuiTextBuffer,
        ),
    >,
    pub UserData: *mut cty::c_void,
}
impl Default for ImGuiSettingsHandler {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiLocKey_TableSizeOne: ImGuiLocKey = 0;
pub const ImGuiLocKey_TableSizeAllFit: ImGuiLocKey = 1;
pub const ImGuiLocKey_TableSizeAllDefault: ImGuiLocKey = 2;
pub const ImGuiLocKey_TableResetOrder: ImGuiLocKey = 3;
pub const ImGuiLocKey_WindowingMainMenuBar: ImGuiLocKey = 4;
pub const ImGuiLocKey_WindowingPopup: ImGuiLocKey = 5;
pub const ImGuiLocKey_WindowingUntitled: ImGuiLocKey = 6;
pub const ImGuiLocKey_DockingHideTabBar: ImGuiLocKey = 7;
pub const ImGuiLocKey_COUNT: ImGuiLocKey = 8;
pub type ImGuiLocKey = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiLocEntry {
    pub Key: ImGuiLocKey,
    pub Text: *const cty::c_char,
}
impl Default for ImGuiLocEntry {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub const ImGuiDebugLogFlags_None: ImGuiDebugLogFlags_ = 0;
pub const ImGuiDebugLogFlags_EventActiveId: ImGuiDebugLogFlags_ = 1;
pub const ImGuiDebugLogFlags_EventFocus: ImGuiDebugLogFlags_ = 2;
pub const ImGuiDebugLogFlags_EventPopup: ImGuiDebugLogFlags_ = 4;
pub const ImGuiDebugLogFlags_EventNav: ImGuiDebugLogFlags_ = 8;
pub const ImGuiDebugLogFlags_EventClipper: ImGuiDebugLogFlags_ = 16;
pub const ImGuiDebugLogFlags_EventIO: ImGuiDebugLogFlags_ = 32;
pub const ImGuiDebugLogFlags_EventDocking: ImGuiDebugLogFlags_ = 64;
pub const ImGuiDebugLogFlags_EventViewport: ImGuiDebugLogFlags_ = 128;
pub const ImGuiDebugLogFlags_EventMask_: ImGuiDebugLogFlags_ = 255;
pub const ImGuiDebugLogFlags_OutputToTTY: ImGuiDebugLogFlags_ = 1024;
pub type ImGuiDebugLogFlags_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiMetricsConfig {
    pub ShowDebugLog: bool,
    pub ShowStackTool: bool,
    pub ShowWindowsRects: bool,
    pub ShowWindowsBeginOrder: bool,
    pub ShowTablesRects: bool,
    pub ShowDrawCmdMesh: bool,
    pub ShowDrawCmdBoundingBoxes: bool,
    pub ShowDockingNodes: bool,
    pub ShowWindowsRectsType: cty::c_int,
    pub ShowTablesRectsType: cty::c_int,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiStackLevelInfo {
    pub ID: ImGuiID,
    pub QueryFrameCount: ImS8,
    pub QuerySuccess: bool,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub Desc: [cty::c_char; 57usize],
}
impl Default for ImGuiStackLevelInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ImGuiStackLevelInfo {
    #[inline]
    pub fn DataType(&self) -> ImGuiDataType {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_DataType(&mut self, val: ImGuiDataType) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(DataType: ImGuiDataType) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let DataType: u32 = unsafe { ::core::mem::transmute(DataType) };
            DataType as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiStackLevelInfo {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiStackLevelInfo,
}
impl Default for ImVector_ImGuiStackLevelInfo {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiStackTool {
    pub LastActiveFrame: cty::c_int,
    pub StackLevel: cty::c_int,
    pub QueryId: ImGuiID,
    pub Results: ImVector_ImGuiStackLevelInfo,
    pub CopyToClipboardOnCtrlC: bool,
    pub CopyToClipboardLastTime: f32,
}
impl Default for ImGuiStackTool {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ImGuiContextHookCallback = ::core::option::Option<
    unsafe extern "C" fn(ctx: *mut ImGuiContext, hook: *mut ImGuiContextHook),
>;
pub const ImGuiContextHookType_NewFramePre: ImGuiContextHookType = 0;
pub const ImGuiContextHookType_NewFramePost: ImGuiContextHookType = 1;
pub const ImGuiContextHookType_EndFramePre: ImGuiContextHookType = 2;
pub const ImGuiContextHookType_EndFramePost: ImGuiContextHookType = 3;
pub const ImGuiContextHookType_RenderPre: ImGuiContextHookType = 4;
pub const ImGuiContextHookType_RenderPost: ImGuiContextHookType = 5;
pub const ImGuiContextHookType_Shutdown: ImGuiContextHookType = 6;
pub const ImGuiContextHookType_PendingRemoval_: ImGuiContextHookType = 7;
pub type ImGuiContextHookType = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiContextHook {
    pub HookId: ImGuiID,
    pub Type: ImGuiContextHookType,
    pub Owner: ImGuiID,
    pub Callback: ImGuiContextHookCallback,
    pub UserData: *mut cty::c_void,
}
impl Default for ImGuiContextHook {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiInputEvent {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiInputEvent,
}
impl Default for ImVector_ImGuiInputEvent {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiWindowStackData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiWindowStackData,
}
impl Default for ImVector_ImGuiWindowStackData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiColorMod {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiColorMod,
}
impl Default for ImVector_ImGuiColorMod {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiStyleMod {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiStyleMod,
}
impl Default for ImVector_ImGuiStyleMod {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiID {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiID,
}
impl Default for ImVector_ImGuiID {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiItemFlags {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiItemFlags,
}
impl Default for ImVector_ImGuiItemFlags {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiGroupData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiGroupData,
}
impl Default for ImVector_ImGuiGroupData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiPopupData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiPopupData,
}
impl Default for ImVector_ImGuiPopupData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiViewportPPtr {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut *mut ImGuiViewportP,
}
impl Default for ImVector_ImGuiViewportPPtr {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_unsigned_char {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut cty::c_uchar,
}
impl Default for ImVector_unsigned_char {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiListClipperData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiListClipperData,
}
impl Default for ImVector_ImGuiListClipperData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTableTempData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTableTempData,
}
impl Default for ImVector_ImGuiTableTempData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTable {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTable,
}
impl Default for ImVector_ImGuiTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImPool_ImGuiTable {
    pub Buf: ImVector_ImGuiTable,
    pub Map: ImGuiStorage,
    pub FreeIdx: ImPoolIdx,
    pub AliveCount: ImPoolIdx,
}
impl Default for ImPool_ImGuiTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTabBar {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTabBar,
}
impl Default for ImVector_ImGuiTabBar {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImPool_ImGuiTabBar {
    pub Buf: ImVector_ImGuiTabBar,
    pub Map: ImGuiStorage,
    pub FreeIdx: ImPoolIdx,
    pub AliveCount: ImPoolIdx,
}
impl Default for ImPool_ImGuiTabBar {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiPtrOrIndex {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiPtrOrIndex,
}
impl Default for ImVector_ImGuiPtrOrIndex {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiShrinkWidthItem {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiShrinkWidthItem,
}
impl Default for ImVector_ImGuiShrinkWidthItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiSettingsHandler {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiSettingsHandler,
}
impl Default for ImVector_ImGuiSettingsHandler {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImChunkStream_ImGuiWindowSettings {
    pub Buf: ImVector_char,
}
impl Default for ImChunkStream_ImGuiWindowSettings {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImChunkStream_ImGuiTableSettings {
    pub Buf: ImVector_char,
}
impl Default for ImChunkStream_ImGuiTableSettings {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiContextHook {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiContextHook,
}
impl Default for ImVector_ImGuiContextHook {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiContext {
    pub Initialized: bool,
    pub FontAtlasOwnedByContext: bool,
    pub IO: ImGuiIO,
    pub PlatformIO: ImGuiPlatformIO,
    pub InputEventsQueue: ImVector_ImGuiInputEvent,
    pub InputEventsTrail: ImVector_ImGuiInputEvent,
    pub Style: ImGuiStyle,
    pub ConfigFlagsCurrFrame: ImGuiConfigFlags,
    pub ConfigFlagsLastFrame: ImGuiConfigFlags,
    pub Font: *mut ImFont,
    pub FontSize: f32,
    pub FontBaseSize: f32,
    pub DrawListSharedData: ImDrawListSharedData,
    pub Time: f64,
    pub FrameCount: cty::c_int,
    pub FrameCountEnded: cty::c_int,
    pub FrameCountPlatformEnded: cty::c_int,
    pub FrameCountRendered: cty::c_int,
    pub WithinFrameScope: bool,
    pub WithinFrameScopeWithImplicitWindow: bool,
    pub WithinEndChild: bool,
    pub GcCompactAll: bool,
    pub TestEngineHookItems: bool,
    pub TestEngine: *mut cty::c_void,
    pub Windows: ImVector_ImGuiWindowPtr,
    pub WindowsFocusOrder: ImVector_ImGuiWindowPtr,
    pub WindowsTempSortBuffer: ImVector_ImGuiWindowPtr,
    pub CurrentWindowStack: ImVector_ImGuiWindowStackData,
    pub WindowsById: ImGuiStorage,
    pub WindowsActiveCount: cty::c_int,
    pub WindowsHoverPadding: ImVec2,
    pub CurrentWindow: *mut ImGuiWindow,
    pub HoveredWindow: *mut ImGuiWindow,
    pub HoveredWindowUnderMovingWindow: *mut ImGuiWindow,
    pub MovingWindow: *mut ImGuiWindow,
    pub WheelingWindow: *mut ImGuiWindow,
    pub WheelingWindowRefMousePos: ImVec2,
    pub WheelingWindowStartFrame: cty::c_int,
    pub WheelingWindowReleaseTimer: f32,
    pub WheelingWindowWheelRemainder: ImVec2,
    pub WheelingAxisAvg: ImVec2,
    pub DebugHookIdInfo: ImGuiID,
    pub HoveredId: ImGuiID,
    pub HoveredIdPreviousFrame: ImGuiID,
    pub HoveredIdAllowOverlap: bool,
    pub HoveredIdDisabled: bool,
    pub HoveredIdTimer: f32,
    pub HoveredIdNotActiveTimer: f32,
    pub ActiveId: ImGuiID,
    pub ActiveIdIsAlive: ImGuiID,
    pub ActiveIdTimer: f32,
    pub ActiveIdIsJustActivated: bool,
    pub ActiveIdAllowOverlap: bool,
    pub ActiveIdNoClearOnFocusLoss: bool,
    pub ActiveIdHasBeenPressedBefore: bool,
    pub ActiveIdHasBeenEditedBefore: bool,
    pub ActiveIdHasBeenEditedThisFrame: bool,
    pub ActiveIdClickOffset: ImVec2,
    pub ActiveIdWindow: *mut ImGuiWindow,
    pub ActiveIdSource: ImGuiInputSource,
    pub ActiveIdMouseButton: cty::c_int,
    pub ActiveIdPreviousFrame: ImGuiID,
    pub ActiveIdPreviousFrameIsAlive: bool,
    pub ActiveIdPreviousFrameHasBeenEditedBefore: bool,
    pub ActiveIdPreviousFrameWindow: *mut ImGuiWindow,
    pub LastActiveId: ImGuiID,
    pub LastActiveIdTimer: f32,
    pub KeysOwnerData: [ImGuiKeyOwnerData; 140usize],
    pub KeysRoutingTable: ImGuiKeyRoutingTable,
    pub ActiveIdUsingNavDirMask: ImU32,
    pub ActiveIdUsingAllKeyboardKeys: bool,
    pub ActiveIdUsingNavInputMask: ImU32,
    pub CurrentFocusScopeId: ImGuiID,
    pub CurrentItemFlags: ImGuiItemFlags,
    pub DebugLocateId: ImGuiID,
    pub NextItemData: ImGuiNextItemData,
    pub LastItemData: ImGuiLastItemData,
    pub NextWindowData: ImGuiNextWindowData,
    pub ColorStack: ImVector_ImGuiColorMod,
    pub StyleVarStack: ImVector_ImGuiStyleMod,
    pub FontStack: ImVector_ImFontPtr,
    pub FocusScopeStack: ImVector_ImGuiID,
    pub ItemFlagsStack: ImVector_ImGuiItemFlags,
    pub GroupStack: ImVector_ImGuiGroupData,
    pub OpenPopupStack: ImVector_ImGuiPopupData,
    pub BeginPopupStack: ImVector_ImGuiPopupData,
    pub BeginMenuCount: cty::c_int,
    pub Viewports: ImVector_ImGuiViewportPPtr,
    pub CurrentDpiScale: f32,
    pub CurrentViewport: *mut ImGuiViewportP,
    pub MouseViewport: *mut ImGuiViewportP,
    pub MouseLastHoveredViewport: *mut ImGuiViewportP,
    pub PlatformLastFocusedViewportId: ImGuiID,
    pub FallbackMonitor: ImGuiPlatformMonitor,
    pub ViewportFrontMostStampCount: cty::c_int,
    pub NavWindow: *mut ImGuiWindow,
    pub NavId: ImGuiID,
    pub NavFocusScopeId: ImGuiID,
    pub NavActivateId: ImGuiID,
    pub NavActivateDownId: ImGuiID,
    pub NavActivatePressedId: ImGuiID,
    pub NavActivateInputId: ImGuiID,
    pub NavActivateFlags: ImGuiActivateFlags,
    pub NavJustMovedToId: ImGuiID,
    pub NavJustMovedToFocusScopeId: ImGuiID,
    pub NavJustMovedToKeyMods: ImGuiKeyChord,
    pub NavNextActivateId: ImGuiID,
    pub NavNextActivateFlags: ImGuiActivateFlags,
    pub NavInputSource: ImGuiInputSource,
    pub NavLayer: ImGuiNavLayer,
    pub NavIdIsAlive: bool,
    pub NavMousePosDirty: bool,
    pub NavDisableHighlight: bool,
    pub NavDisableMouseHover: bool,
    pub NavAnyRequest: bool,
    pub NavInitRequest: bool,
    pub NavInitRequestFromMove: bool,
    pub NavInitResultId: ImGuiID,
    pub NavInitResultRectRel: ImRect,
    pub NavMoveSubmitted: bool,
    pub NavMoveScoringItems: bool,
    pub NavMoveForwardToNextFrame: bool,
    pub NavMoveFlags: ImGuiNavMoveFlags,
    pub NavMoveScrollFlags: ImGuiScrollFlags,
    pub NavMoveKeyMods: ImGuiKeyChord,
    pub NavMoveDir: ImGuiDir,
    pub NavMoveDirForDebug: ImGuiDir,
    pub NavMoveClipDir: ImGuiDir,
    pub NavScoringRect: ImRect,
    pub NavScoringNoClipRect: ImRect,
    pub NavScoringDebugCount: cty::c_int,
    pub NavTabbingDir: cty::c_int,
    pub NavTabbingCounter: cty::c_int,
    pub NavMoveResultLocal: ImGuiNavItemData,
    pub NavMoveResultLocalVisible: ImGuiNavItemData,
    pub NavMoveResultOther: ImGuiNavItemData,
    pub NavTabbingResultFirst: ImGuiNavItemData,
    pub ConfigNavWindowingKeyNext: ImGuiKeyChord,
    pub ConfigNavWindowingKeyPrev: ImGuiKeyChord,
    pub NavWindowingTarget: *mut ImGuiWindow,
    pub NavWindowingTargetAnim: *mut ImGuiWindow,
    pub NavWindowingListWindow: *mut ImGuiWindow,
    pub NavWindowingTimer: f32,
    pub NavWindowingHighlightAlpha: f32,
    pub NavWindowingToggleLayer: bool,
    pub NavWindowingAccumDeltaPos: ImVec2,
    pub NavWindowingAccumDeltaSize: ImVec2,
    pub DimBgRatio: f32,
    pub MouseCursor: ImGuiMouseCursor,
    pub DragDropActive: bool,
    pub DragDropWithinSource: bool,
    pub DragDropWithinTarget: bool,
    pub DragDropSourceFlags: ImGuiDragDropFlags,
    pub DragDropSourceFrameCount: cty::c_int,
    pub DragDropMouseButton: cty::c_int,
    pub DragDropPayload: ImGuiPayload,
    pub DragDropTargetRect: ImRect,
    pub DragDropTargetId: ImGuiID,
    pub DragDropAcceptFlags: ImGuiDragDropFlags,
    pub DragDropAcceptIdCurrRectSurface: f32,
    pub DragDropAcceptIdCurr: ImGuiID,
    pub DragDropAcceptIdPrev: ImGuiID,
    pub DragDropAcceptFrameCount: cty::c_int,
    pub DragDropHoldJustPressedId: ImGuiID,
    pub DragDropPayloadBufHeap: ImVector_unsigned_char,
    pub DragDropPayloadBufLocal: [cty::c_uchar; 16usize],
    pub ClipperTempDataStacked: cty::c_int,
    pub ClipperTempData: ImVector_ImGuiListClipperData,
    pub CurrentTable: *mut ImGuiTable,
    pub TablesTempDataStacked: cty::c_int,
    pub TablesTempData: ImVector_ImGuiTableTempData,
    pub Tables: ImPool_ImGuiTable,
    pub TablesLastTimeActive: ImVector_float,
    pub DrawChannelsTempMergeBuffer: ImVector_ImDrawChannel,
    pub CurrentTabBar: *mut ImGuiTabBar,
    pub TabBars: ImPool_ImGuiTabBar,
    pub CurrentTabBarStack: ImVector_ImGuiPtrOrIndex,
    pub ShrinkWidthBuffer: ImVector_ImGuiShrinkWidthItem,
    pub HoverDelayId: ImGuiID,
    pub HoverDelayIdPreviousFrame: ImGuiID,
    pub HoverDelayTimer: f32,
    pub HoverDelayClearTimer: f32,
    pub MouseLastValidPos: ImVec2,
    pub InputTextState: ImGuiInputTextState,
    pub InputTextPasswordFont: ImFont,
    pub TempInputId: ImGuiID,
    pub ColorEditOptions: ImGuiColorEditFlags,
    pub ColorEditLastHue: f32,
    pub ColorEditLastSat: f32,
    pub ColorEditLastColor: ImU32,
    pub ColorPickerRef: ImVec4,
    pub ComboPreviewData: ImGuiComboPreviewData,
    pub SliderGrabClickOffset: f32,
    pub SliderCurrentAccum: f32,
    pub SliderCurrentAccumDirty: bool,
    pub DragCurrentAccumDirty: bool,
    pub DragCurrentAccum: f32,
    pub DragSpeedDefaultRatio: f32,
    pub ScrollbarClickDeltaToGrabCenter: f32,
    pub DisabledAlphaBackup: f32,
    pub DisabledStackSize: cty::c_short,
    pub TooltipOverrideCount: cty::c_short,
    pub ClipboardHandlerData: ImVector_char,
    pub MenusIdSubmittedThisFrame: ImVector_ImGuiID,
    pub PlatformImeData: ImGuiPlatformImeData,
    pub PlatformImeDataPrev: ImGuiPlatformImeData,
    pub PlatformImeViewport: ImGuiID,
    pub PlatformLocaleDecimalPoint: cty::c_char,
    pub DockContext: ImGuiDockContext,
    pub SettingsLoaded: bool,
    pub SettingsDirtyTimer: f32,
    pub SettingsIniData: ImGuiTextBuffer,
    pub SettingsHandlers: ImVector_ImGuiSettingsHandler,
    pub SettingsWindows: ImChunkStream_ImGuiWindowSettings,
    pub SettingsTables: ImChunkStream_ImGuiTableSettings,
    pub Hooks: ImVector_ImGuiContextHook,
    pub HookIdNext: ImGuiID,
    pub LocalizationTable: [*const cty::c_char; 8usize],
    pub LogEnabled: bool,
    pub LogType: ImGuiLogType,
    pub LogFile: ImFileHandle,
    pub LogBuffer: ImGuiTextBuffer,
    pub LogNextPrefix: *const cty::c_char,
    pub LogNextSuffix: *const cty::c_char,
    pub LogLinePosY: f32,
    pub LogLineFirstItem: bool,
    pub LogDepthRef: cty::c_int,
    pub LogDepthToExpand: cty::c_int,
    pub LogDepthToExpandDefault: cty::c_int,
    pub DebugLogFlags: ImGuiDebugLogFlags,
    pub DebugLogBuf: ImGuiTextBuffer,
    pub DebugLogIndex: ImGuiTextIndex,
    pub DebugLocateFrames: ImU8,
    pub DebugItemPickerActive: bool,
    pub DebugItemPickerMouseButton: ImU8,
    pub DebugItemPickerBreakId: ImGuiID,
    pub DebugMetricsConfig: ImGuiMetricsConfig,
    pub DebugStackTool: ImGuiStackTool,
    pub DebugHoveredDockNode: *mut ImGuiDockNode,
    pub FramerateSecPerFrame: [f32; 60usize],
    pub FramerateSecPerFrameIdx: cty::c_int,
    pub FramerateSecPerFrameCount: cty::c_int,
    pub FramerateSecPerFrameAccum: f32,
    pub WantCaptureMouseNextFrame: cty::c_int,
    pub WantCaptureKeyboardNextFrame: cty::c_int,
    pub WantTextInputNextFrame: cty::c_int,
    pub TempBuffer: ImVector_char,
}
impl Default for ImGuiContext {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiWindowTempData {
    pub CursorPos: ImVec2,
    pub CursorPosPrevLine: ImVec2,
    pub CursorStartPos: ImVec2,
    pub CursorMaxPos: ImVec2,
    pub IdealMaxPos: ImVec2,
    pub CurrLineSize: ImVec2,
    pub PrevLineSize: ImVec2,
    pub CurrLineTextBaseOffset: f32,
    pub PrevLineTextBaseOffset: f32,
    pub IsSameLine: bool,
    pub IsSetPos: bool,
    pub Indent: ImVec1,
    pub ColumnsOffset: ImVec1,
    pub GroupOffset: ImVec1,
    pub CursorStartPosLossyness: ImVec2,
    pub NavLayerCurrent: ImGuiNavLayer,
    pub NavLayersActiveMask: cty::c_short,
    pub NavLayersActiveMaskNext: cty::c_short,
    pub NavHideHighlightOneFrame: bool,
    pub NavHasScroll: bool,
    pub MenuBarAppending: bool,
    pub MenuBarOffset: ImVec2,
    pub MenuColumns: ImGuiMenuColumns,
    pub TreeDepth: cty::c_int,
    pub TreeJumpToParentOnPopMask: ImU32,
    pub ChildWindows: ImVector_ImGuiWindowPtr,
    pub StateStorage: *mut ImGuiStorage,
    pub CurrentColumns: *mut ImGuiOldColumns,
    pub CurrentTableIdx: cty::c_int,
    pub LayoutType: ImGuiLayoutType,
    pub ParentLayoutType: ImGuiLayoutType,
    pub ItemWidth: f32,
    pub TextWrapPos: f32,
    pub ItemWidthStack: ImVector_float,
    pub TextWrapPosStack: ImVector_float,
}
impl Default for ImGuiWindowTempData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiOldColumns {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiOldColumns,
}
impl Default for ImVector_ImGuiOldColumns {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiWindow {
    pub Name: *mut cty::c_char,
    pub ID: ImGuiID,
    pub Flags: ImGuiWindowFlags,
    pub FlagsPreviousFrame: ImGuiWindowFlags,
    pub WindowClass: ImGuiWindowClass,
    pub Viewport: *mut ImGuiViewportP,
    pub ViewportId: ImGuiID,
    pub ViewportPos: ImVec2,
    pub ViewportAllowPlatformMonitorExtend: cty::c_int,
    pub Pos: ImVec2,
    pub Size: ImVec2,
    pub SizeFull: ImVec2,
    pub ContentSize: ImVec2,
    pub ContentSizeIdeal: ImVec2,
    pub ContentSizeExplicit: ImVec2,
    pub WindowPadding: ImVec2,
    pub WindowRounding: f32,
    pub WindowBorderSize: f32,
    pub DecoOuterSizeX1: f32,
    pub DecoOuterSizeY1: f32,
    pub DecoOuterSizeX2: f32,
    pub DecoOuterSizeY2: f32,
    pub DecoInnerSizeX1: f32,
    pub DecoInnerSizeY1: f32,
    pub NameBufLen: cty::c_int,
    pub MoveId: ImGuiID,
    pub TabId: ImGuiID,
    pub ChildId: ImGuiID,
    pub Scroll: ImVec2,
    pub ScrollMax: ImVec2,
    pub ScrollTarget: ImVec2,
    pub ScrollTargetCenterRatio: ImVec2,
    pub ScrollTargetEdgeSnapDist: ImVec2,
    pub ScrollbarSizes: ImVec2,
    pub ScrollbarX: bool,
    pub ScrollbarY: bool,
    pub ViewportOwned: bool,
    pub Active: bool,
    pub WasActive: bool,
    pub WriteAccessed: bool,
    pub Collapsed: bool,
    pub WantCollapseToggle: bool,
    pub SkipItems: bool,
    pub Appearing: bool,
    pub Hidden: bool,
    pub IsFallbackWindow: bool,
    pub IsExplicitChild: bool,
    pub HasCloseButton: bool,
    pub ResizeBorderHeld: cty::c_schar,
    pub BeginCount: cty::c_short,
    pub BeginCountPreviousFrame: cty::c_short,
    pub BeginOrderWithinParent: cty::c_short,
    pub BeginOrderWithinContext: cty::c_short,
    pub FocusOrder: cty::c_short,
    pub PopupId: ImGuiID,
    pub AutoFitFramesX: ImS8,
    pub AutoFitFramesY: ImS8,
    pub AutoFitChildAxises: ImS8,
    pub AutoFitOnlyGrows: bool,
    pub AutoPosLastDirection: ImGuiDir,
    pub HiddenFramesCanSkipItems: ImS8,
    pub HiddenFramesCannotSkipItems: ImS8,
    pub HiddenFramesForRenderOnly: ImS8,
    pub DisableInputsFrames: ImS8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub SetWindowPosVal: ImVec2,
    pub SetWindowPosPivot: ImVec2,
    pub IDStack: ImVector_ImGuiID,
    pub DC: ImGuiWindowTempData,
    pub OuterRectClipped: ImRect,
    pub InnerRect: ImRect,
    pub InnerClipRect: ImRect,
    pub WorkRect: ImRect,
    pub ParentWorkRect: ImRect,
    pub ClipRect: ImRect,
    pub ContentRegionRect: ImRect,
    pub HitTestHoleSize: ImVec2ih,
    pub HitTestHoleOffset: ImVec2ih,
    pub LastFrameActive: cty::c_int,
    pub LastFrameJustFocused: cty::c_int,
    pub LastTimeActive: f32,
    pub ItemWidthDefault: f32,
    pub StateStorage: ImGuiStorage,
    pub ColumnsStorage: ImVector_ImGuiOldColumns,
    pub FontWindowScale: f32,
    pub FontDpiScale: f32,
    pub SettingsOffset: cty::c_int,
    pub DrawList: *mut ImDrawList,
    pub DrawListInst: ImDrawList,
    pub ParentWindow: *mut ImGuiWindow,
    pub ParentWindowInBeginStack: *mut ImGuiWindow,
    pub RootWindow: *mut ImGuiWindow,
    pub RootWindowPopupTree: *mut ImGuiWindow,
    pub RootWindowDockTree: *mut ImGuiWindow,
    pub RootWindowForTitleBarHighlight: *mut ImGuiWindow,
    pub RootWindowForNav: *mut ImGuiWindow,
    pub NavLastChildNavWindow: *mut ImGuiWindow,
    pub NavLastIds: [ImGuiID; 2usize],
    pub NavRectRel: [ImRect; 2usize],
    pub NavRootFocusScopeId: ImGuiID,
    pub MemoryDrawListIdxCapacity: cty::c_int,
    pub MemoryDrawListVtxCapacity: cty::c_int,
    pub MemoryCompacted: bool,
    pub _bitfield_align_2: [u8; 0],
    pub _bitfield_2: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub DockOrder: cty::c_short,
    pub DockStyle: ImGuiWindowDockStyle,
    pub DockNode: *mut ImGuiDockNode,
    pub DockNodeAsHost: *mut ImGuiDockNode,
    pub DockId: ImGuiID,
    pub DockTabItemStatusFlags: ImGuiItemStatusFlags,
    pub DockTabItemRect: ImRect,
}
impl Default for ImGuiWindow {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ImGuiWindow {
    #[inline]
    pub fn SetWindowPosAllowFlags(&self) -> ImGuiCond {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_SetWindowPosAllowFlags(&mut self, val: ImGuiCond) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn SetWindowSizeAllowFlags(&self) -> ImGuiCond {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_SetWindowSizeAllowFlags(&mut self, val: ImGuiCond) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn SetWindowCollapsedAllowFlags(&self) -> ImGuiCond {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_SetWindowCollapsedAllowFlags(&mut self, val: ImGuiCond) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn SetWindowDockAllowFlags(&self) -> ImGuiCond {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_SetWindowDockAllowFlags(&mut self, val: ImGuiCond) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        SetWindowPosAllowFlags: ImGuiCond,
        SetWindowSizeAllowFlags: ImGuiCond,
        SetWindowCollapsedAllowFlags: ImGuiCond,
        SetWindowDockAllowFlags: ImGuiCond,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let SetWindowPosAllowFlags: u32 =
                unsafe { ::core::mem::transmute(SetWindowPosAllowFlags) };
            SetWindowPosAllowFlags as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let SetWindowSizeAllowFlags: u32 =
                unsafe { ::core::mem::transmute(SetWindowSizeAllowFlags) };
            SetWindowSizeAllowFlags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let SetWindowCollapsedAllowFlags: u32 =
                unsafe { ::core::mem::transmute(SetWindowCollapsedAllowFlags) };
            SetWindowCollapsedAllowFlags as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let SetWindowDockAllowFlags: u32 =
                unsafe { ::core::mem::transmute(SetWindowDockAllowFlags) };
            SetWindowDockAllowFlags as u64
        });
        __bindgen_bitfield_unit
    }
    #[inline]
    pub fn DockIsActive(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_2.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_DockIsActive(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_2.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn DockNodeIsVisible(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_2.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_DockNodeIsVisible(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_2.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn DockTabIsVisible(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_2.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_DockTabIsVisible(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_2.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn DockTabWantClose(&self) -> bool {
        unsafe { ::core::mem::transmute(self._bitfield_2.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_DockTabWantClose(&mut self, val: bool) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_2.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_2(
        DockIsActive: bool,
        DockNodeIsVisible: bool,
        DockTabIsVisible: bool,
        DockTabWantClose: bool,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let DockIsActive: u8 = unsafe { ::core::mem::transmute(DockIsActive) };
            DockIsActive as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let DockNodeIsVisible: u8 = unsafe { ::core::mem::transmute(DockNodeIsVisible) };
            DockNodeIsVisible as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let DockTabIsVisible: u8 = unsafe { ::core::mem::transmute(DockTabIsVisible) };
            DockTabIsVisible as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let DockTabWantClose: u8 = unsafe { ::core::mem::transmute(DockTabWantClose) };
            DockTabWantClose as u64
        });
        __bindgen_bitfield_unit
    }
}
pub const ImGuiTabBarFlags_DockNode: ImGuiTabBarFlagsPrivate_ = 1048576;
pub const ImGuiTabBarFlags_IsFocused: ImGuiTabBarFlagsPrivate_ = 2097152;
pub const ImGuiTabBarFlags_SaveSettings: ImGuiTabBarFlagsPrivate_ = 4194304;
pub type ImGuiTabBarFlagsPrivate_ = cty::c_uint;
pub const ImGuiTabItemFlags_SectionMask_: ImGuiTabItemFlagsPrivate_ = 192;
pub const ImGuiTabItemFlags_NoCloseButton: ImGuiTabItemFlagsPrivate_ = 1048576;
pub const ImGuiTabItemFlags_Button: ImGuiTabItemFlagsPrivate_ = 2097152;
pub const ImGuiTabItemFlags_Unsorted: ImGuiTabItemFlagsPrivate_ = 4194304;
pub const ImGuiTabItemFlags_Preview: ImGuiTabItemFlagsPrivate_ = 8388608;
pub type ImGuiTabItemFlagsPrivate_ = cty::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiTabItem {
    pub ID: ImGuiID,
    pub Flags: ImGuiTabItemFlags,
    pub Window: *mut ImGuiWindow,
    pub LastFrameVisible: cty::c_int,
    pub LastFrameSelected: cty::c_int,
    pub Offset: f32,
    pub Width: f32,
    pub ContentWidth: f32,
    pub RequestedWidth: f32,
    pub NameOffset: ImS32,
    pub BeginOrder: ImS16,
    pub IndexDuringLayout: ImS16,
    pub WantClose: bool,
}
impl Default for ImGuiTabItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTabItem {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTabItem,
}
impl Default for ImVector_ImGuiTabItem {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiTabBar {
    pub Tabs: ImVector_ImGuiTabItem,
    pub Flags: ImGuiTabBarFlags,
    pub ID: ImGuiID,
    pub SelectedTabId: ImGuiID,
    pub NextSelectedTabId: ImGuiID,
    pub VisibleTabId: ImGuiID,
    pub CurrFrameVisible: cty::c_int,
    pub PrevFrameVisible: cty::c_int,
    pub BarRect: ImRect,
    pub CurrTabsContentsHeight: f32,
    pub PrevTabsContentsHeight: f32,
    pub WidthAllTabs: f32,
    pub WidthAllTabsIdeal: f32,
    pub ScrollingAnim: f32,
    pub ScrollingTarget: f32,
    pub ScrollingTargetDistToVisibility: f32,
    pub ScrollingSpeed: f32,
    pub ScrollingRectMinX: f32,
    pub ScrollingRectMaxX: f32,
    pub ReorderRequestTabId: ImGuiID,
    pub ReorderRequestOffset: ImS16,
    pub BeginCount: ImS8,
    pub WantLayout: bool,
    pub VisibleTabWasSubmitted: bool,
    pub TabsAddedNew: bool,
    pub TabsActiveCount: ImS16,
    pub LastTabItemIdx: ImS16,
    pub ItemSpacingY: f32,
    pub FramePadding: ImVec2,
    pub BackupCursorPos: ImVec2,
    pub TabsNames: ImGuiTextBuffer,
}
impl Default for ImGuiTabBar {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ImGuiTableColumnIdx = ImS8;
pub type ImGuiTableDrawChannelIdx = ImU8;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiTableColumn {
    pub Flags: ImGuiTableColumnFlags,
    pub WidthGiven: f32,
    pub MinX: f32,
    pub MaxX: f32,
    pub WidthRequest: f32,
    pub WidthAuto: f32,
    pub StretchWeight: f32,
    pub InitStretchWeightOrWidth: f32,
    pub ClipRect: ImRect,
    pub UserID: ImGuiID,
    pub WorkMinX: f32,
    pub WorkMaxX: f32,
    pub ItemWidth: f32,
    pub ContentMaxXFrozen: f32,
    pub ContentMaxXUnfrozen: f32,
    pub ContentMaxXHeadersUsed: f32,
    pub ContentMaxXHeadersIdeal: f32,
    pub NameOffset: ImS16,
    pub DisplayOrder: ImGuiTableColumnIdx,
    pub IndexWithinEnabledSet: ImGuiTableColumnIdx,
    pub PrevEnabledColumn: ImGuiTableColumnIdx,
    pub NextEnabledColumn: ImGuiTableColumnIdx,
    pub SortOrder: ImGuiTableColumnIdx,
    pub DrawChannelCurrent: ImGuiTableDrawChannelIdx,
    pub DrawChannelFrozen: ImGuiTableDrawChannelIdx,
    pub DrawChannelUnfrozen: ImGuiTableDrawChannelIdx,
    pub IsEnabled: bool,
    pub IsUserEnabled: bool,
    pub IsUserEnabledNextFrame: bool,
    pub IsVisibleX: bool,
    pub IsVisibleY: bool,
    pub IsRequestOutput: bool,
    pub IsSkipItems: bool,
    pub IsPreserveWidthAuto: bool,
    pub NavLayerCurrent: ImS8,
    pub AutoFitQueue: ImU8,
    pub CannotSkipItemsQueue: ImU8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub SortDirectionsAvailList: ImU8,
}
impl ImGuiTableColumn {
    #[inline]
    pub fn SortDirection(&self) -> ImU8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u8) }
    }
    #[inline]
    pub fn set_SortDirection(&mut self, val: ImU8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn SortDirectionsAvailCount(&self) -> ImU8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 2u8) as u8) }
    }
    #[inline]
    pub fn set_SortDirectionsAvailCount(&mut self, val: ImU8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn SortDirectionsAvailMask(&self) -> ImU8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(4usize, 4u8) as u8) }
    }
    #[inline]
    pub fn set_SortDirectionsAvailMask(&mut self, val: ImU8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(4usize, 4u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        SortDirection: ImU8,
        SortDirectionsAvailCount: ImU8,
        SortDirectionsAvailMask: ImU8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let SortDirection: u8 = unsafe { ::core::mem::transmute(SortDirection) };
            SortDirection as u64
        });
        __bindgen_bitfield_unit.set(2usize, 2u8, {
            let SortDirectionsAvailCount: u8 =
                unsafe { ::core::mem::transmute(SortDirectionsAvailCount) };
            SortDirectionsAvailCount as u64
        });
        __bindgen_bitfield_unit.set(4usize, 4u8, {
            let SortDirectionsAvailMask: u8 =
                unsafe { ::core::mem::transmute(SortDirectionsAvailMask) };
            SortDirectionsAvailMask as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImGuiTableCellData {
    pub BgColor: ImU32,
    pub Column: ImGuiTableColumnIdx,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiTableInstanceData {
    pub LastOuterHeight: f32,
    pub LastFirstRowHeight: f32,
    pub LastFrozenHeight: f32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImSpan_ImGuiTableColumn {
    pub Data: *mut ImGuiTableColumn,
    pub DataEnd: *mut ImGuiTableColumn,
}
impl Default for ImSpan_ImGuiTableColumn {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImSpan_ImGuiTableColumnIdx {
    pub Data: *mut ImGuiTableColumnIdx,
    pub DataEnd: *mut ImGuiTableColumnIdx,
}
impl Default for ImSpan_ImGuiTableColumnIdx {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImSpan_ImGuiTableCellData {
    pub Data: *mut ImGuiTableCellData,
    pub DataEnd: *mut ImGuiTableCellData,
}
impl Default for ImSpan_ImGuiTableCellData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTableInstanceData {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTableInstanceData,
}
impl Default for ImVector_ImGuiTableInstanceData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImVector_ImGuiTableColumnSortSpecs {
    pub Size: cty::c_int,
    pub Capacity: cty::c_int,
    pub Data: *mut ImGuiTableColumnSortSpecs,
}
impl Default for ImVector_ImGuiTableColumnSortSpecs {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiTable {
    pub ID: ImGuiID,
    pub Flags: ImGuiTableFlags,
    pub RawData: *mut cty::c_void,
    pub TempData: *mut ImGuiTableTempData,
    pub Columns: ImSpan_ImGuiTableColumn,
    pub DisplayOrderToIndex: ImSpan_ImGuiTableColumnIdx,
    pub RowCellData: ImSpan_ImGuiTableCellData,
    pub EnabledMaskByDisplayOrder: ImU64,
    pub EnabledMaskByIndex: ImU64,
    pub VisibleMaskByIndex: ImU64,
    pub RequestOutputMaskByIndex: ImU64,
    pub SettingsLoadedFlags: ImGuiTableFlags,
    pub SettingsOffset: cty::c_int,
    pub LastFrameActive: cty::c_int,
    pub ColumnsCount: cty::c_int,
    pub CurrentRow: cty::c_int,
    pub CurrentColumn: cty::c_int,
    pub InstanceCurrent: ImS16,
    pub InstanceInteracted: ImS16,
    pub RowPosY1: f32,
    pub RowPosY2: f32,
    pub RowMinHeight: f32,
    pub RowTextBaseline: f32,
    pub RowIndentOffsetX: f32,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub RowBgColorCounter: cty::c_int,
    pub RowBgColor: [ImU32; 2usize],
    pub BorderColorStrong: ImU32,
    pub BorderColorLight: ImU32,
    pub BorderX1: f32,
    pub BorderX2: f32,
    pub HostIndentX: f32,
    pub MinColumnWidth: f32,
    pub OuterPaddingX: f32,
    pub CellPaddingX: f32,
    pub CellPaddingY: f32,
    pub CellSpacingX1: f32,
    pub CellSpacingX2: f32,
    pub InnerWidth: f32,
    pub ColumnsGivenWidth: f32,
    pub ColumnsAutoFitWidth: f32,
    pub ColumnsStretchSumWeights: f32,
    pub ResizedColumnNextWidth: f32,
    pub ResizeLockMinContentsX2: f32,
    pub RefScale: f32,
    pub OuterRect: ImRect,
    pub InnerRect: ImRect,
    pub WorkRect: ImRect,
    pub InnerClipRect: ImRect,
    pub BgClipRect: ImRect,
    pub Bg0ClipRectForDrawCmd: ImRect,
    pub Bg2ClipRectForDrawCmd: ImRect,
    pub HostClipRect: ImRect,
    pub HostBackupInnerClipRect: ImRect,
    pub OuterWindow: *mut ImGuiWindow,
    pub InnerWindow: *mut ImGuiWindow,
    pub ColumnsNames: ImGuiTextBuffer,
    pub DrawSplitter: *mut ImDrawListSplitter,
    pub InstanceDataFirst: ImGuiTableInstanceData,
    pub InstanceDataExtra: ImVector_ImGuiTableInstanceData,
    pub SortSpecsSingle: ImGuiTableColumnSortSpecs,
    pub SortSpecsMulti: ImVector_ImGuiTableColumnSortSpecs,
    pub SortSpecs: ImGuiTableSortSpecs,
    pub SortSpecsCount: ImGuiTableColumnIdx,
    pub ColumnsEnabledCount: ImGuiTableColumnIdx,
    pub ColumnsEnabledFixedCount: ImGuiTableColumnIdx,
    pub DeclColumnsCount: ImGuiTableColumnIdx,
    pub HoveredColumnBody: ImGuiTableColumnIdx,
    pub HoveredColumnBorder: ImGuiTableColumnIdx,
    pub AutoFitSingleColumn: ImGuiTableColumnIdx,
    pub ResizedColumn: ImGuiTableColumnIdx,
    pub LastResizedColumn: ImGuiTableColumnIdx,
    pub HeldHeaderColumn: ImGuiTableColumnIdx,
    pub ReorderColumn: ImGuiTableColumnIdx,
    pub ReorderColumnDir: ImGuiTableColumnIdx,
    pub LeftMostEnabledColumn: ImGuiTableColumnIdx,
    pub RightMostEnabledColumn: ImGuiTableColumnIdx,
    pub LeftMostStretchedColumn: ImGuiTableColumnIdx,
    pub RightMostStretchedColumn: ImGuiTableColumnIdx,
    pub ContextPopupColumn: ImGuiTableColumnIdx,
    pub FreezeRowsRequest: ImGuiTableColumnIdx,
    pub FreezeRowsCount: ImGuiTableColumnIdx,
    pub FreezeColumnsRequest: ImGuiTableColumnIdx,
    pub FreezeColumnsCount: ImGuiTableColumnIdx,
    pub RowCellDataCurrent: ImGuiTableColumnIdx,
    pub DummyDrawChannel: ImGuiTableDrawChannelIdx,
    pub Bg2DrawChannelCurrent: ImGuiTableDrawChannelIdx,
    pub Bg2DrawChannelUnfrozen: ImGuiTableDrawChannelIdx,
    pub IsLayoutLocked: bool,
    pub IsInsideRow: bool,
    pub IsInitializing: bool,
    pub IsSortSpecsDirty: bool,
    pub IsUsingHeaders: bool,
    pub IsContextPopupOpen: bool,
    pub IsSettingsRequestLoad: bool,
    pub IsSettingsDirty: bool,
    pub IsDefaultDisplayOrder: bool,
    pub IsResetAllRequest: bool,
    pub IsResetDisplayOrderRequest: bool,
    pub IsUnfrozenRows: bool,
    pub IsDefaultSizingPolicy: bool,
    pub HasScrollbarYCurr: bool,
    pub HasScrollbarYPrev: bool,
    pub MemoryCompacted: bool,
    pub HostSkipItems: bool,
}
impl Default for ImGuiTable {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl ImGuiTable {
    #[inline]
    pub fn RowFlags(&self) -> ImGuiTableRowFlags {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_RowFlags(&mut self, val: ImGuiTableRowFlags) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn LastRowFlags(&self) -> ImGuiTableRowFlags {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_LastRowFlags(&mut self, val: ImGuiTableRowFlags) {
        unsafe {
            let val: u32 = ::core::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        RowFlags: ImGuiTableRowFlags,
        LastRowFlags: ImGuiTableRowFlags,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let RowFlags: u32 = unsafe { ::core::mem::transmute(RowFlags) };
            RowFlags as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let LastRowFlags: u32 = unsafe { ::core::mem::transmute(LastRowFlags) };
            LastRowFlags as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq)]
pub struct ImGuiTableTempData {
    pub TableIndex: cty::c_int,
    pub LastTimeActive: f32,
    pub UserOuterSize: ImVec2,
    pub DrawSplitter: ImDrawListSplitter,
    pub HostBackupWorkRect: ImRect,
    pub HostBackupParentWorkRect: ImRect,
    pub HostBackupPrevLineSize: ImVec2,
    pub HostBackupCurrLineSize: ImVec2,
    pub HostBackupCursorMaxPos: ImVec2,
    pub HostBackupColumnsOffset: ImVec1,
    pub HostBackupItemWidth: f32,
    pub HostBackupItemWidthStackSize: cty::c_int,
}
impl Default for ImGuiTableTempData {
    fn default() -> Self {
        let mut s = ::core::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::core::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiTableColumnSettings {
    pub WidthOrWeight: f32,
    pub UserID: ImGuiID,
    pub Index: ImGuiTableColumnIdx,
    pub DisplayOrder: ImGuiTableColumnIdx,
    pub SortOrder: ImGuiTableColumnIdx,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
}
impl ImGuiTableColumnSettings {
    #[inline]
    pub fn SortDirection(&self) -> ImU8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u8) }
    }
    #[inline]
    pub fn set_SortDirection(&mut self, val: ImU8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn IsEnabled(&self) -> ImU8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_IsEnabled(&mut self, val: ImU8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn IsStretch(&self) -> ImU8 {
        unsafe { ::core::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_IsStretch(&mut self, val: ImU8) {
        unsafe {
            let val: u8 = ::core::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        SortDirection: ImU8,
        IsEnabled: ImU8,
        IsStretch: ImU8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let SortDirection: u8 = unsafe { ::core::mem::transmute(SortDirection) };
            SortDirection as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let IsEnabled: u8 = unsafe { ::core::mem::transmute(IsEnabled) };
            IsEnabled as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let IsStretch: u8 = unsafe { ::core::mem::transmute(IsStretch) };
            IsStretch as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq)]
pub struct ImGuiTableSettings {
    pub ID: ImGuiID,
    pub SaveFlags: ImGuiTableFlags,
    pub RefScale: f32,
    pub ColumnsCount: ImGuiTableColumnIdx,
    pub ColumnsCountMax: ImGuiTableColumnIdx,
    pub WantApply: bool,
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, Hash, PartialEq, Eq)]
pub struct ImFontBuilderIO {
    pub FontBuilder_Build:
        ::core::option::Option<unsafe extern "C" fn(atlas: *mut ImFontAtlas) -> bool>,
}
extern "C" {
    pub fn ImVec2_ImVec2_Nil() -> *mut ImVec2;
}
extern "C" {
    pub fn ImVec2_destroy(self_: *mut ImVec2);
}
extern "C" {
    pub fn ImVec2_ImVec2_Float(_x: f32, _y: f32) -> *mut ImVec2;
}
extern "C" {
    pub fn ImVec4_ImVec4_Nil() -> *mut ImVec4;
}
extern "C" {
    pub fn ImVec4_destroy(self_: *mut ImVec4);
}
extern "C" {
    pub fn ImVec4_ImVec4_Float(_x: f32, _y: f32, _z: f32, _w: f32) -> *mut ImVec4;
}
extern "C" {
    pub fn igCreateContext(shared_font_atlas: *mut ImFontAtlas) -> *mut ImGuiContext;
}
extern "C" {
    pub fn igDestroyContext(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igGetCurrentContext() -> *mut ImGuiContext;
}
extern "C" {
    pub fn igSetCurrentContext(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igGetIO() -> *mut ImGuiIO;
}
extern "C" {
    pub fn igGetStyle() -> *mut ImGuiStyle;
}
extern "C" {
    pub fn igNewFrame();
}
extern "C" {
    pub fn igEndFrame();
}
extern "C" {
    pub fn igRender();
}
extern "C" {
    pub fn igGetDrawData() -> *mut ImDrawData;
}
extern "C" {
    pub fn igShowDemoWindow(p_open: *mut bool);
}
extern "C" {
    pub fn igShowMetricsWindow(p_open: *mut bool);
}
extern "C" {
    pub fn igShowDebugLogWindow(p_open: *mut bool);
}
extern "C" {
    pub fn igShowStackToolWindow(p_open: *mut bool);
}
extern "C" {
    pub fn igShowAboutWindow(p_open: *mut bool);
}
extern "C" {
    pub fn igShowStyleEditor(ref_: *mut ImGuiStyle);
}
extern "C" {
    pub fn igShowStyleSelector(label: *const cty::c_char) -> bool;
}
extern "C" {
    pub fn igShowFontSelector(label: *const cty::c_char);
}
extern "C" {
    pub fn igShowUserGuide();
}
extern "C" {
    pub fn igGetVersion() -> *const cty::c_char;
}
extern "C" {
    pub fn igStyleColorsDark(dst: *mut ImGuiStyle);
}
extern "C" {
    pub fn igStyleColorsLight(dst: *mut ImGuiStyle);
}
extern "C" {
    pub fn igStyleColorsClassic(dst: *mut ImGuiStyle);
}
extern "C" {
    pub fn igBegin(name: *const cty::c_char, p_open: *mut bool, flags: ImGuiWindowFlags) -> bool;
}
extern "C" {
    pub fn igEnd();
}
extern "C" {
    pub fn igBeginChild_Str(
        str_id: *const cty::c_char,
        size: ImVec2,
        border: bool,
        flags: ImGuiWindowFlags,
    ) -> bool;
}
extern "C" {
    pub fn igBeginChild_ID(
        id: ImGuiID,
        size: ImVec2,
        border: bool,
        flags: ImGuiWindowFlags,
    ) -> bool;
}
extern "C" {
    pub fn igEndChild();
}
extern "C" {
    pub fn igIsWindowAppearing() -> bool;
}
extern "C" {
    pub fn igIsWindowCollapsed() -> bool;
}
extern "C" {
    pub fn igIsWindowFocused(flags: ImGuiFocusedFlags) -> bool;
}
extern "C" {
    pub fn igIsWindowHovered(flags: ImGuiHoveredFlags) -> bool;
}
extern "C" {
    pub fn igGetWindowDrawList() -> *mut ImDrawList;
}
extern "C" {
    pub fn igGetWindowDpiScale() -> f32;
}
extern "C" {
    pub fn igGetWindowPos(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetWindowSize(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetWindowWidth() -> f32;
}
extern "C" {
    pub fn igGetWindowHeight() -> f32;
}
extern "C" {
    pub fn igGetWindowViewport() -> *mut ImGuiViewport;
}
extern "C" {
    pub fn igSetNextWindowPos(pos: ImVec2, cond: ImGuiCond, pivot: ImVec2);
}
extern "C" {
    pub fn igSetNextWindowSize(size: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetNextWindowSizeConstraints(
        size_min: ImVec2,
        size_max: ImVec2,
        custom_callback: ImGuiSizeCallback,
        custom_callback_data: *mut cty::c_void,
    );
}
extern "C" {
    pub fn igSetNextWindowContentSize(size: ImVec2);
}
extern "C" {
    pub fn igSetNextWindowCollapsed(collapsed: bool, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetNextWindowFocus();
}
extern "C" {
    pub fn igSetNextWindowScroll(scroll: ImVec2);
}
extern "C" {
    pub fn igSetNextWindowBgAlpha(alpha: f32);
}
extern "C" {
    pub fn igSetNextWindowViewport(viewport_id: ImGuiID);
}
extern "C" {
    pub fn igSetWindowPos_Vec2(pos: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowSize_Vec2(size: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowCollapsed_Bool(collapsed: bool, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowFocus_Nil();
}
extern "C" {
    pub fn igSetWindowFontScale(scale: f32);
}
extern "C" {
    pub fn igSetWindowPos_Str(name: *const cty::c_char, pos: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowSize_Str(name: *const cty::c_char, size: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowCollapsed_Str(name: *const cty::c_char, collapsed: bool, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowFocus_Str(name: *const cty::c_char);
}
extern "C" {
    pub fn igGetContentRegionAvail(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetContentRegionMax(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetWindowContentRegionMin(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetWindowContentRegionMax(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetScrollX() -> f32;
}
extern "C" {
    pub fn igGetScrollY() -> f32;
}
extern "C" {
    pub fn igSetScrollX_Float(scroll_x: f32);
}
extern "C" {
    pub fn igSetScrollY_Float(scroll_y: f32);
}
extern "C" {
    pub fn igGetScrollMaxX() -> f32;
}
extern "C" {
    pub fn igGetScrollMaxY() -> f32;
}
extern "C" {
    pub fn igSetScrollHereX(center_x_ratio: f32);
}
extern "C" {
    pub fn igSetScrollHereY(center_y_ratio: f32);
}
extern "C" {
    pub fn igSetScrollFromPosX_Float(local_x: f32, center_x_ratio: f32);
}
extern "C" {
    pub fn igSetScrollFromPosY_Float(local_y: f32, center_y_ratio: f32);
}
extern "C" {
    pub fn igPushFont(font: *mut ImFont);
}
extern "C" {
    pub fn igPopFont();
}
extern "C" {
    pub fn igPushStyleColor_U32(idx: ImGuiCol, col: ImU32);
}
extern "C" {
    pub fn igPushStyleColor_Vec4(idx: ImGuiCol, col: ImVec4);
}
extern "C" {
    pub fn igPopStyleColor(count: cty::c_int);
}
extern "C" {
    pub fn igPushStyleVar_Float(idx: ImGuiStyleVar, val: f32);
}
extern "C" {
    pub fn igPushStyleVar_Vec2(idx: ImGuiStyleVar, val: ImVec2);
}
extern "C" {
    pub fn igPopStyleVar(count: cty::c_int);
}
extern "C" {
    pub fn igPushAllowKeyboardFocus(allow_keyboard_focus: bool);
}
extern "C" {
    pub fn igPopAllowKeyboardFocus();
}
extern "C" {
    pub fn igPushButtonRepeat(repeat: bool);
}
extern "C" {
    pub fn igPopButtonRepeat();
}
extern "C" {
    pub fn igPushItemWidth(item_width: f32);
}
extern "C" {
    pub fn igPopItemWidth();
}
extern "C" {
    pub fn igSetNextItemWidth(item_width: f32);
}
extern "C" {
    pub fn igCalcItemWidth() -> f32;
}
extern "C" {
    pub fn igPushTextWrapPos(wrap_local_pos_x: f32);
}
extern "C" {
    pub fn igPopTextWrapPos();
}
extern "C" {
    pub fn igGetFont() -> *mut ImFont;
}
extern "C" {
    pub fn igGetFontSize() -> f32;
}
extern "C" {
    pub fn igGetFontTexUvWhitePixel(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetColorU32_Col(idx: ImGuiCol, alpha_mul: f32) -> ImU32;
}
extern "C" {
    pub fn igGetColorU32_Vec4(col: ImVec4) -> ImU32;
}
extern "C" {
    pub fn igGetColorU32_U32(col: ImU32) -> ImU32;
}
extern "C" {
    pub fn igGetStyleColorVec4(idx: ImGuiCol) -> *const ImVec4;
}
extern "C" {
    pub fn igSeparator();
}
extern "C" {
    pub fn igSameLine(offset_from_start_x: f32, spacing: f32);
}
extern "C" {
    pub fn igNewLine();
}
extern "C" {
    pub fn igSpacing();
}
extern "C" {
    pub fn igDummy(size: ImVec2);
}
extern "C" {
    pub fn igIndent(indent_w: f32);
}
extern "C" {
    pub fn igUnindent(indent_w: f32);
}
extern "C" {
    pub fn igBeginGroup();
}
extern "C" {
    pub fn igEndGroup();
}
extern "C" {
    pub fn igGetCursorPos(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetCursorPosX() -> f32;
}
extern "C" {
    pub fn igGetCursorPosY() -> f32;
}
extern "C" {
    pub fn igSetCursorPos(local_pos: ImVec2);
}
extern "C" {
    pub fn igSetCursorPosX(local_x: f32);
}
extern "C" {
    pub fn igSetCursorPosY(local_y: f32);
}
extern "C" {
    pub fn igGetCursorStartPos(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetCursorScreenPos(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igSetCursorScreenPos(pos: ImVec2);
}
extern "C" {
    pub fn igAlignTextToFramePadding();
}
extern "C" {
    pub fn igGetTextLineHeight() -> f32;
}
extern "C" {
    pub fn igGetTextLineHeightWithSpacing() -> f32;
}
extern "C" {
    pub fn igGetFrameHeight() -> f32;
}
extern "C" {
    pub fn igGetFrameHeightWithSpacing() -> f32;
}
extern "C" {
    pub fn igPushID_Str(str_id: *const cty::c_char);
}
extern "C" {
    pub fn igPushID_StrStr(str_id_begin: *const cty::c_char, str_id_end: *const cty::c_char);
}
extern "C" {
    pub fn igPushID_Ptr(ptr_id: *const cty::c_void);
}
extern "C" {
    pub fn igPushID_Int(int_id: cty::c_int);
}
extern "C" {
    pub fn igPopID();
}
extern "C" {
    pub fn igGetID_Str(str_id: *const cty::c_char) -> ImGuiID;
}
extern "C" {
    pub fn igGetID_StrStr(
        str_id_begin: *const cty::c_char,
        str_id_end: *const cty::c_char,
    ) -> ImGuiID;
}
extern "C" {
    pub fn igGetID_Ptr(ptr_id: *const cty::c_void) -> ImGuiID;
}
extern "C" {
    pub fn igTextUnformatted(text: *const cty::c_char, text_end: *const cty::c_char);
}
extern "C" {
    pub fn igText(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igTextColored(col: ImVec4, fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igTextDisabled(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igTextWrapped(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igLabelText(label: *const cty::c_char, fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igBulletText(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igButton(label: *const cty::c_char, size: ImVec2) -> bool;
}
extern "C" {
    pub fn igSmallButton(label: *const cty::c_char) -> bool;
}
extern "C" {
    pub fn igInvisibleButton(
        str_id: *const cty::c_char,
        size: ImVec2,
        flags: ImGuiButtonFlags,
    ) -> bool;
}
extern "C" {
    pub fn igArrowButton(str_id: *const cty::c_char, dir: ImGuiDir) -> bool;
}
extern "C" {
    pub fn igCheckbox(label: *const cty::c_char, v: *mut bool) -> bool;
}
extern "C" {
    pub fn igCheckboxFlags_IntPtr(
        label: *const cty::c_char,
        flags: *mut cty::c_int,
        flags_value: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igCheckboxFlags_UintPtr(
        label: *const cty::c_char,
        flags: *mut cty::c_uint,
        flags_value: cty::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn igRadioButton_Bool(label: *const cty::c_char, active: bool) -> bool;
}
extern "C" {
    pub fn igRadioButton_IntPtr(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_button: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igProgressBar(fraction: f32, size_arg: ImVec2, overlay: *const cty::c_char);
}
extern "C" {
    pub fn igBullet();
}
extern "C" {
    pub fn igImage(
        user_texture_id: ImTextureID,
        size: ImVec2,
        uv0: ImVec2,
        uv1: ImVec2,
        tint_col: ImVec4,
        border_col: ImVec4,
    );
}
extern "C" {
    pub fn igImageButton(
        str_id: *const cty::c_char,
        user_texture_id: ImTextureID,
        size: ImVec2,
        uv0: ImVec2,
        uv1: ImVec2,
        bg_col: ImVec4,
        tint_col: ImVec4,
    ) -> bool;
}
extern "C" {
    pub fn igBeginCombo(
        label: *const cty::c_char,
        preview_value: *const cty::c_char,
        flags: ImGuiComboFlags,
    ) -> bool;
}
extern "C" {
    pub fn igEndCombo();
}
extern "C" {
    pub fn igCombo_Str_arr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items: *const *const cty::c_char,
        items_count: cty::c_int,
        popup_max_height_in_items: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igCombo_Str(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items_separated_by_zeros: *const cty::c_char,
        popup_max_height_in_items: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igCombo_FnBoolPtr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items_getter: ::core::option::Option<
            unsafe extern "C" fn(
                data: *mut cty::c_void,
                idx: cty::c_int,
                out_text: *mut *const cty::c_char,
            ) -> bool,
        >,
        data: *mut cty::c_void,
        items_count: cty::c_int,
        popup_max_height_in_items: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igDragFloat(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragFloat2(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragFloat3(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragFloat4(
        label: *const cty::c_char,
        v: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragFloatRange2(
        label: *const cty::c_char,
        v_current_min: *mut f32,
        v_current_max: *mut f32,
        v_speed: f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        format_max: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragInt(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragInt2(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragInt3(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragInt4(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragIntRange2(
        label: *const cty::c_char,
        v_current_min: *mut cty::c_int,
        v_current_max: *mut cty::c_int,
        v_speed: f32,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        format_max: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragScalar(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        v_speed: f32,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragScalarN(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        components: cty::c_int,
        v_speed: f32,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderFloat(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderFloat2(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderFloat3(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderFloat4(
        label: *const cty::c_char,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderAngle(
        label: *const cty::c_char,
        v_rad: *mut f32,
        v_degrees_min: f32,
        v_degrees_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderInt(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderInt2(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderInt3(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderInt4(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderScalar(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderScalarN(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        components: cty::c_int,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igVSliderFloat(
        label: *const cty::c_char,
        size: ImVec2,
        v: *mut f32,
        v_min: f32,
        v_max: f32,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igVSliderInt(
        label: *const cty::c_char,
        size: ImVec2,
        v: *mut cty::c_int,
        v_min: cty::c_int,
        v_max: cty::c_int,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igVSliderScalar(
        label: *const cty::c_char,
        size: ImVec2,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputText(
        label: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
extern "C" {
    pub fn igInputTextMultiline(
        label: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
        size: ImVec2,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
extern "C" {
    pub fn igInputTextWithHint(
        label: *const cty::c_char,
        hint: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
extern "C" {
    pub fn igInputFloat(
        label: *const cty::c_char,
        v: *mut f32,
        step: f32,
        step_fast: f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputFloat2(
        label: *const cty::c_char,
        v: *mut f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputFloat3(
        label: *const cty::c_char,
        v: *mut f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputFloat4(
        label: *const cty::c_char,
        v: *mut f32,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputInt(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        step: cty::c_int,
        step_fast: cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputInt2(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputInt3(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputInt4(
        label: *const cty::c_char,
        v: *mut cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputDouble(
        label: *const cty::c_char,
        v: *mut f64,
        step: f64,
        step_fast: f64,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputScalar(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_step: *const cty::c_void,
        p_step_fast: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igInputScalarN(
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        components: cty::c_int,
        p_step: *const cty::c_void,
        p_step_fast: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igColorEdit3(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
    ) -> bool;
}
extern "C" {
    pub fn igColorEdit4(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
    ) -> bool;
}
extern "C" {
    pub fn igColorPicker3(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
    ) -> bool;
}
extern "C" {
    pub fn igColorPicker4(
        label: *const cty::c_char,
        col: *mut f32,
        flags: ImGuiColorEditFlags,
        ref_col: *const f32,
    ) -> bool;
}
extern "C" {
    pub fn igColorButton(
        desc_id: *const cty::c_char,
        col: ImVec4,
        flags: ImGuiColorEditFlags,
        size: ImVec2,
    ) -> bool;
}
extern "C" {
    pub fn igSetColorEditOptions(flags: ImGuiColorEditFlags);
}
extern "C" {
    pub fn igTreeNode_Str(label: *const cty::c_char) -> bool;
}
extern "C" {
    pub fn igTreeNode_StrStr(str_id: *const cty::c_char, fmt: *const cty::c_char, ...) -> bool;
}
extern "C" {
    pub fn igTreeNode_Ptr(ptr_id: *const cty::c_void, fmt: *const cty::c_char, ...) -> bool;
}
extern "C" {
    pub fn igTreeNodeEx_Str(label: *const cty::c_char, flags: ImGuiTreeNodeFlags) -> bool;
}
extern "C" {
    pub fn igTreeNodeEx_StrStr(
        str_id: *const cty::c_char,
        flags: ImGuiTreeNodeFlags,
        fmt: *const cty::c_char,
        ...
    ) -> bool;
}
extern "C" {
    pub fn igTreeNodeEx_Ptr(
        ptr_id: *const cty::c_void,
        flags: ImGuiTreeNodeFlags,
        fmt: *const cty::c_char,
        ...
    ) -> bool;
}
extern "C" {
    pub fn igTreePush_Str(str_id: *const cty::c_char);
}
extern "C" {
    pub fn igTreePush_Ptr(ptr_id: *const cty::c_void);
}
extern "C" {
    pub fn igTreePop();
}
extern "C" {
    pub fn igGetTreeNodeToLabelSpacing() -> f32;
}
extern "C" {
    pub fn igCollapsingHeader_TreeNodeFlags(
        label: *const cty::c_char,
        flags: ImGuiTreeNodeFlags,
    ) -> bool;
}
extern "C" {
    pub fn igCollapsingHeader_BoolPtr(
        label: *const cty::c_char,
        p_visible: *mut bool,
        flags: ImGuiTreeNodeFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSetNextItemOpen(is_open: bool, cond: ImGuiCond);
}
extern "C" {
    pub fn igSelectable_Bool(
        label: *const cty::c_char,
        selected: bool,
        flags: ImGuiSelectableFlags,
        size: ImVec2,
    ) -> bool;
}
extern "C" {
    pub fn igSelectable_BoolPtr(
        label: *const cty::c_char,
        p_selected: *mut bool,
        flags: ImGuiSelectableFlags,
        size: ImVec2,
    ) -> bool;
}
extern "C" {
    pub fn igBeginListBox(label: *const cty::c_char, size: ImVec2) -> bool;
}
extern "C" {
    pub fn igEndListBox();
}
extern "C" {
    pub fn igListBox_Str_arr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items: *const *const cty::c_char,
        items_count: cty::c_int,
        height_in_items: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igListBox_FnBoolPtr(
        label: *const cty::c_char,
        current_item: *mut cty::c_int,
        items_getter: ::core::option::Option<
            unsafe extern "C" fn(
                data: *mut cty::c_void,
                idx: cty::c_int,
                out_text: *mut *const cty::c_char,
            ) -> bool,
        >,
        data: *mut cty::c_void,
        items_count: cty::c_int,
        height_in_items: cty::c_int,
    ) -> bool;
}
extern "C" {
    pub fn igPlotLines_FloatPtr(
        label: *const cty::c_char,
        values: *const f32,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
        stride: cty::c_int,
    );
}
extern "C" {
    pub fn igPlotLines_FnFloatPtr(
        label: *const cty::c_char,
        values_getter: ::core::option::Option<
            unsafe extern "C" fn(data: *mut cty::c_void, idx: cty::c_int) -> f32,
        >,
        data: *mut cty::c_void,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
    );
}
extern "C" {
    pub fn igPlotHistogram_FloatPtr(
        label: *const cty::c_char,
        values: *const f32,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
        stride: cty::c_int,
    );
}
extern "C" {
    pub fn igPlotHistogram_FnFloatPtr(
        label: *const cty::c_char,
        values_getter: ::core::option::Option<
            unsafe extern "C" fn(data: *mut cty::c_void, idx: cty::c_int) -> f32,
        >,
        data: *mut cty::c_void,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        graph_size: ImVec2,
    );
}
extern "C" {
    pub fn igValue_Bool(prefix: *const cty::c_char, b: bool);
}
extern "C" {
    pub fn igValue_Int(prefix: *const cty::c_char, v: cty::c_int);
}
extern "C" {
    pub fn igValue_Uint(prefix: *const cty::c_char, v: cty::c_uint);
}
extern "C" {
    pub fn igValue_Float(prefix: *const cty::c_char, v: f32, float_format: *const cty::c_char);
}
extern "C" {
    pub fn igBeginMenuBar() -> bool;
}
extern "C" {
    pub fn igEndMenuBar();
}
extern "C" {
    pub fn igBeginMainMenuBar() -> bool;
}
extern "C" {
    pub fn igEndMainMenuBar();
}
extern "C" {
    pub fn igBeginMenu(label: *const cty::c_char, enabled: bool) -> bool;
}
extern "C" {
    pub fn igEndMenu();
}
extern "C" {
    pub fn igMenuItem_Bool(
        label: *const cty::c_char,
        shortcut: *const cty::c_char,
        selected: bool,
        enabled: bool,
    ) -> bool;
}
extern "C" {
    pub fn igMenuItem_BoolPtr(
        label: *const cty::c_char,
        shortcut: *const cty::c_char,
        p_selected: *mut bool,
        enabled: bool,
    ) -> bool;
}
extern "C" {
    pub fn igBeginTooltip();
}
extern "C" {
    pub fn igEndTooltip();
}
extern "C" {
    pub fn igSetTooltip(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igBeginPopup(str_id: *const cty::c_char, flags: ImGuiWindowFlags) -> bool;
}
extern "C" {
    pub fn igBeginPopupModal(
        name: *const cty::c_char,
        p_open: *mut bool,
        flags: ImGuiWindowFlags,
    ) -> bool;
}
extern "C" {
    pub fn igEndPopup();
}
extern "C" {
    pub fn igOpenPopup_Str(str_id: *const cty::c_char, popup_flags: ImGuiPopupFlags);
}
extern "C" {
    pub fn igOpenPopup_ID(id: ImGuiID, popup_flags: ImGuiPopupFlags);
}
extern "C" {
    pub fn igOpenPopupOnItemClick(str_id: *const cty::c_char, popup_flags: ImGuiPopupFlags);
}
extern "C" {
    pub fn igCloseCurrentPopup();
}
extern "C" {
    pub fn igBeginPopupContextItem(
        str_id: *const cty::c_char,
        popup_flags: ImGuiPopupFlags,
    ) -> bool;
}
extern "C" {
    pub fn igBeginPopupContextWindow(
        str_id: *const cty::c_char,
        popup_flags: ImGuiPopupFlags,
    ) -> bool;
}
extern "C" {
    pub fn igBeginPopupContextVoid(
        str_id: *const cty::c_char,
        popup_flags: ImGuiPopupFlags,
    ) -> bool;
}
extern "C" {
    pub fn igIsPopupOpen_Str(str_id: *const cty::c_char, flags: ImGuiPopupFlags) -> bool;
}
extern "C" {
    pub fn igBeginTable(
        str_id: *const cty::c_char,
        column: cty::c_int,
        flags: ImGuiTableFlags,
        outer_size: ImVec2,
        inner_width: f32,
    ) -> bool;
}
extern "C" {
    pub fn igEndTable();
}
extern "C" {
    pub fn igTableNextRow(row_flags: ImGuiTableRowFlags, min_row_height: f32);
}
extern "C" {
    pub fn igTableNextColumn() -> bool;
}
extern "C" {
    pub fn igTableSetColumnIndex(column_n: cty::c_int) -> bool;
}
extern "C" {
    pub fn igTableSetupColumn(
        label: *const cty::c_char,
        flags: ImGuiTableColumnFlags,
        init_width_or_weight: f32,
        user_id: ImGuiID,
    );
}
extern "C" {
    pub fn igTableSetupScrollFreeze(cols: cty::c_int, rows: cty::c_int);
}
extern "C" {
    pub fn igTableHeadersRow();
}
extern "C" {
    pub fn igTableHeader(label: *const cty::c_char);
}
extern "C" {
    pub fn igTableGetSortSpecs() -> *mut ImGuiTableSortSpecs;
}
extern "C" {
    pub fn igTableGetColumnCount() -> cty::c_int;
}
extern "C" {
    pub fn igTableGetColumnIndex() -> cty::c_int;
}
extern "C" {
    pub fn igTableGetRowIndex() -> cty::c_int;
}
extern "C" {
    pub fn igTableGetColumnName_Int(column_n: cty::c_int) -> *const cty::c_char;
}
extern "C" {
    pub fn igTableGetColumnFlags(column_n: cty::c_int) -> ImGuiTableColumnFlags;
}
extern "C" {
    pub fn igTableSetColumnEnabled(column_n: cty::c_int, v: bool);
}
extern "C" {
    pub fn igTableSetBgColor(target: ImGuiTableBgTarget, color: ImU32, column_n: cty::c_int);
}
extern "C" {
    pub fn igColumns(count: cty::c_int, id: *const cty::c_char, border: bool);
}
extern "C" {
    pub fn igNextColumn();
}
extern "C" {
    pub fn igGetColumnIndex() -> cty::c_int;
}
extern "C" {
    pub fn igGetColumnWidth(column_index: cty::c_int) -> f32;
}
extern "C" {
    pub fn igSetColumnWidth(column_index: cty::c_int, width: f32);
}
extern "C" {
    pub fn igGetColumnOffset(column_index: cty::c_int) -> f32;
}
extern "C" {
    pub fn igSetColumnOffset(column_index: cty::c_int, offset_x: f32);
}
extern "C" {
    pub fn igGetColumnsCount() -> cty::c_int;
}
extern "C" {
    pub fn igBeginTabBar(str_id: *const cty::c_char, flags: ImGuiTabBarFlags) -> bool;
}
extern "C" {
    pub fn igEndTabBar();
}
extern "C" {
    pub fn igBeginTabItem(
        label: *const cty::c_char,
        p_open: *mut bool,
        flags: ImGuiTabItemFlags,
    ) -> bool;
}
extern "C" {
    pub fn igEndTabItem();
}
extern "C" {
    pub fn igTabItemButton(label: *const cty::c_char, flags: ImGuiTabItemFlags) -> bool;
}
extern "C" {
    pub fn igSetTabItemClosed(tab_or_docked_window_label: *const cty::c_char);
}
extern "C" {
    pub fn igDockSpace(
        id: ImGuiID,
        size: ImVec2,
        flags: ImGuiDockNodeFlags,
        window_class: *const ImGuiWindowClass,
    ) -> ImGuiID;
}
extern "C" {
    pub fn igDockSpaceOverViewport(
        viewport: *const ImGuiViewport,
        flags: ImGuiDockNodeFlags,
        window_class: *const ImGuiWindowClass,
    ) -> ImGuiID;
}
extern "C" {
    pub fn igSetNextWindowDockID(dock_id: ImGuiID, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetNextWindowClass(window_class: *const ImGuiWindowClass);
}
extern "C" {
    pub fn igGetWindowDockID() -> ImGuiID;
}
extern "C" {
    pub fn igIsWindowDocked() -> bool;
}
extern "C" {
    pub fn igLogToTTY(auto_open_depth: cty::c_int);
}
extern "C" {
    pub fn igLogToFile(auto_open_depth: cty::c_int, filename: *const cty::c_char);
}
extern "C" {
    pub fn igLogToClipboard(auto_open_depth: cty::c_int);
}
extern "C" {
    pub fn igLogFinish();
}
extern "C" {
    pub fn igLogButtons();
}
extern "C" {
    pub fn igBeginDragDropSource(flags: ImGuiDragDropFlags) -> bool;
}
extern "C" {
    pub fn igSetDragDropPayload(
        type_: *const cty::c_char,
        data: *const cty::c_void,
        sz: usize,
        cond: ImGuiCond,
    ) -> bool;
}
extern "C" {
    pub fn igEndDragDropSource();
}
extern "C" {
    pub fn igBeginDragDropTarget() -> bool;
}
extern "C" {
    pub fn igAcceptDragDropPayload(
        type_: *const cty::c_char,
        flags: ImGuiDragDropFlags,
    ) -> *const ImGuiPayload;
}
extern "C" {
    pub fn igEndDragDropTarget();
}
extern "C" {
    pub fn igGetDragDropPayload() -> *const ImGuiPayload;
}
extern "C" {
    pub fn igBeginDisabled(disabled: bool);
}
extern "C" {
    pub fn igEndDisabled();
}
extern "C" {
    pub fn igPushClipRect(
        clip_rect_min: ImVec2,
        clip_rect_max: ImVec2,
        intersect_with_current_clip_rect: bool,
    );
}
extern "C" {
    pub fn igPopClipRect();
}
extern "C" {
    pub fn igSetItemDefaultFocus();
}
extern "C" {
    pub fn igSetKeyboardFocusHere(offset: cty::c_int);
}
extern "C" {
    pub fn igIsItemHovered(flags: ImGuiHoveredFlags) -> bool;
}
extern "C" {
    pub fn igIsItemActive() -> bool;
}
extern "C" {
    pub fn igIsItemFocused() -> bool;
}
extern "C" {
    pub fn igIsItemClicked(mouse_button: ImGuiMouseButton) -> bool;
}
extern "C" {
    pub fn igIsItemVisible() -> bool;
}
extern "C" {
    pub fn igIsItemEdited() -> bool;
}
extern "C" {
    pub fn igIsItemActivated() -> bool;
}
extern "C" {
    pub fn igIsItemDeactivated() -> bool;
}
extern "C" {
    pub fn igIsItemDeactivatedAfterEdit() -> bool;
}
extern "C" {
    pub fn igIsItemToggledOpen() -> bool;
}
extern "C" {
    pub fn igIsAnyItemHovered() -> bool;
}
extern "C" {
    pub fn igIsAnyItemActive() -> bool;
}
extern "C" {
    pub fn igIsAnyItemFocused() -> bool;
}
extern "C" {
    pub fn igGetItemID() -> ImGuiID;
}
extern "C" {
    pub fn igGetItemRectMin(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetItemRectMax(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetItemRectSize(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igSetItemAllowOverlap();
}
extern "C" {
    pub fn igGetMainViewport() -> *mut ImGuiViewport;
}
extern "C" {
    pub fn igGetBackgroundDrawList_Nil() -> *mut ImDrawList;
}
extern "C" {
    pub fn igGetForegroundDrawList_Nil() -> *mut ImDrawList;
}
extern "C" {
    pub fn igGetBackgroundDrawList_ViewportPtr(viewport: *mut ImGuiViewport) -> *mut ImDrawList;
}
extern "C" {
    pub fn igGetForegroundDrawList_ViewportPtr(viewport: *mut ImGuiViewport) -> *mut ImDrawList;
}
extern "C" {
    pub fn igIsRectVisible_Nil(size: ImVec2) -> bool;
}
extern "C" {
    pub fn igIsRectVisible_Vec2(rect_min: ImVec2, rect_max: ImVec2) -> bool;
}
extern "C" {
    pub fn igGetTime() -> f64;
}
extern "C" {
    pub fn igGetFrameCount() -> cty::c_int;
}
extern "C" {
    pub fn igGetDrawListSharedData() -> *mut ImDrawListSharedData;
}
extern "C" {
    pub fn igGetStyleColorName(idx: ImGuiCol) -> *const cty::c_char;
}
extern "C" {
    pub fn igSetStateStorage(storage: *mut ImGuiStorage);
}
extern "C" {
    pub fn igGetStateStorage() -> *mut ImGuiStorage;
}
extern "C" {
    pub fn igBeginChildFrame(id: ImGuiID, size: ImVec2, flags: ImGuiWindowFlags) -> bool;
}
extern "C" {
    pub fn igEndChildFrame();
}
extern "C" {
    pub fn igCalcTextSize(
        pOut: *mut ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        hide_text_after_double_hash: bool,
        wrap_width: f32,
    );
}
extern "C" {
    pub fn igColorConvertU32ToFloat4(pOut: *mut ImVec4, in_: ImU32);
}
extern "C" {
    pub fn igColorConvertFloat4ToU32(in_: ImVec4) -> ImU32;
}
extern "C" {
    pub fn igColorConvertRGBtoHSV(
        r: f32,
        g: f32,
        b: f32,
        out_h: *mut f32,
        out_s: *mut f32,
        out_v: *mut f32,
    );
}
extern "C" {
    pub fn igColorConvertHSVtoRGB(
        h: f32,
        s: f32,
        v: f32,
        out_r: *mut f32,
        out_g: *mut f32,
        out_b: *mut f32,
    );
}
extern "C" {
    pub fn igIsKeyDown_Nil(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsKeyPressed_Bool(key: ImGuiKey, repeat: bool) -> bool;
}
extern "C" {
    pub fn igIsKeyReleased_Nil(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igGetKeyPressedAmount(key: ImGuiKey, repeat_delay: f32, rate: f32) -> cty::c_int;
}
extern "C" {
    pub fn igGetKeyName(key: ImGuiKey) -> *const cty::c_char;
}
extern "C" {
    pub fn igSetNextFrameWantCaptureKeyboard(want_capture_keyboard: bool);
}
extern "C" {
    pub fn igIsMouseDown_Nil(button: ImGuiMouseButton) -> bool;
}
extern "C" {
    pub fn igIsMouseClicked_Bool(button: ImGuiMouseButton, repeat: bool) -> bool;
}
extern "C" {
    pub fn igIsMouseReleased_Nil(button: ImGuiMouseButton) -> bool;
}
extern "C" {
    pub fn igIsMouseDoubleClicked(button: ImGuiMouseButton) -> bool;
}
extern "C" {
    pub fn igGetMouseClickedCount(button: ImGuiMouseButton) -> cty::c_int;
}
extern "C" {
    pub fn igIsMouseHoveringRect(r_min: ImVec2, r_max: ImVec2, clip: bool) -> bool;
}
extern "C" {
    pub fn igIsMousePosValid(mouse_pos: *const ImVec2) -> bool;
}
extern "C" {
    pub fn igIsAnyMouseDown() -> bool;
}
extern "C" {
    pub fn igGetMousePos(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igGetMousePosOnOpeningCurrentPopup(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igIsMouseDragging(button: ImGuiMouseButton, lock_threshold: f32) -> bool;
}
extern "C" {
    pub fn igGetMouseDragDelta(pOut: *mut ImVec2, button: ImGuiMouseButton, lock_threshold: f32);
}
extern "C" {
    pub fn igResetMouseDragDelta(button: ImGuiMouseButton);
}
extern "C" {
    pub fn igGetMouseCursor() -> ImGuiMouseCursor;
}
extern "C" {
    pub fn igSetMouseCursor(cursor_type: ImGuiMouseCursor);
}
extern "C" {
    pub fn igSetNextFrameWantCaptureMouse(want_capture_mouse: bool);
}
extern "C" {
    pub fn igGetClipboardText() -> *const cty::c_char;
}
extern "C" {
    pub fn igSetClipboardText(text: *const cty::c_char);
}
extern "C" {
    pub fn igLoadIniSettingsFromDisk(ini_filename: *const cty::c_char);
}
extern "C" {
    pub fn igLoadIniSettingsFromMemory(ini_data: *const cty::c_char, ini_size: usize);
}
extern "C" {
    pub fn igSaveIniSettingsToDisk(ini_filename: *const cty::c_char);
}
extern "C" {
    pub fn igSaveIniSettingsToMemory(out_ini_size: *mut usize) -> *const cty::c_char;
}
extern "C" {
    pub fn igDebugTextEncoding(text: *const cty::c_char);
}
extern "C" {
    pub fn igDebugCheckVersionAndDataLayout(
        version_str: *const cty::c_char,
        sz_io: usize,
        sz_style: usize,
        sz_vec2: usize,
        sz_vec4: usize,
        sz_drawvert: usize,
        sz_drawidx: usize,
    ) -> bool;
}
extern "C" {
    pub fn igSetAllocatorFunctions(
        alloc_func: ImGuiMemAllocFunc,
        free_func: ImGuiMemFreeFunc,
        user_data: *mut cty::c_void,
    );
}
extern "C" {
    pub fn igGetAllocatorFunctions(
        p_alloc_func: *mut ImGuiMemAllocFunc,
        p_free_func: *mut ImGuiMemFreeFunc,
        p_user_data: *mut *mut cty::c_void,
    );
}
extern "C" {
    pub fn igMemAlloc(size: usize) -> *mut cty::c_void;
}
extern "C" {
    pub fn igMemFree(ptr: *mut cty::c_void);
}
extern "C" {
    pub fn igGetPlatformIO() -> *mut ImGuiPlatformIO;
}
extern "C" {
    pub fn igUpdatePlatformWindows();
}
extern "C" {
    pub fn igRenderPlatformWindowsDefault(
        platform_render_arg: *mut cty::c_void,
        renderer_render_arg: *mut cty::c_void,
    );
}
extern "C" {
    pub fn igDestroyPlatformWindows();
}
extern "C" {
    pub fn igFindViewportByID(id: ImGuiID) -> *mut ImGuiViewport;
}
extern "C" {
    pub fn igFindViewportByPlatformHandle(platform_handle: *mut cty::c_void) -> *mut ImGuiViewport;
}
extern "C" {
    pub fn ImGuiStyle_ImGuiStyle() -> *mut ImGuiStyle;
}
extern "C" {
    pub fn ImGuiStyle_destroy(self_: *mut ImGuiStyle);
}
extern "C" {
    pub fn ImGuiStyle_ScaleAllSizes(self_: *mut ImGuiStyle, scale_factor: f32);
}
extern "C" {
    pub fn ImGuiIO_AddKeyEvent(self_: *mut ImGuiIO, key: ImGuiKey, down: bool);
}
extern "C" {
    pub fn ImGuiIO_AddKeyAnalogEvent(self_: *mut ImGuiIO, key: ImGuiKey, down: bool, v: f32);
}
extern "C" {
    pub fn ImGuiIO_AddMousePosEvent(self_: *mut ImGuiIO, x: f32, y: f32);
}
extern "C" {
    pub fn ImGuiIO_AddMouseButtonEvent(self_: *mut ImGuiIO, button: cty::c_int, down: bool);
}
extern "C" {
    pub fn ImGuiIO_AddMouseWheelEvent(self_: *mut ImGuiIO, wh_x: f32, wh_y: f32);
}
extern "C" {
    pub fn ImGuiIO_AddMouseViewportEvent(self_: *mut ImGuiIO, id: ImGuiID);
}
extern "C" {
    pub fn ImGuiIO_AddFocusEvent(self_: *mut ImGuiIO, focused: bool);
}
extern "C" {
    pub fn ImGuiIO_AddInputCharacter(self_: *mut ImGuiIO, c: cty::c_uint);
}
extern "C" {
    pub fn ImGuiIO_AddInputCharacterUTF16(self_: *mut ImGuiIO, c: ImWchar16);
}
extern "C" {
    pub fn ImGuiIO_AddInputCharactersUTF8(self_: *mut ImGuiIO, str_: *const cty::c_char);
}
extern "C" {
    pub fn ImGuiIO_SetKeyEventNativeData(
        self_: *mut ImGuiIO,
        key: ImGuiKey,
        native_keycode: cty::c_int,
        native_scancode: cty::c_int,
        native_legacy_index: cty::c_int,
    );
}
extern "C" {
    pub fn ImGuiIO_SetAppAcceptingEvents(self_: *mut ImGuiIO, accepting_events: bool);
}
extern "C" {
    pub fn ImGuiIO_ClearInputCharacters(self_: *mut ImGuiIO);
}
extern "C" {
    pub fn ImGuiIO_ClearInputKeys(self_: *mut ImGuiIO);
}
extern "C" {
    pub fn ImGuiIO_ImGuiIO() -> *mut ImGuiIO;
}
extern "C" {
    pub fn ImGuiIO_destroy(self_: *mut ImGuiIO);
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_ImGuiInputTextCallbackData() -> *mut ImGuiInputTextCallbackData;
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_destroy(self_: *mut ImGuiInputTextCallbackData);
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_DeleteChars(
        self_: *mut ImGuiInputTextCallbackData,
        pos: cty::c_int,
        bytes_count: cty::c_int,
    );
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_InsertChars(
        self_: *mut ImGuiInputTextCallbackData,
        pos: cty::c_int,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_SelectAll(self_: *mut ImGuiInputTextCallbackData);
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_ClearSelection(self_: *mut ImGuiInputTextCallbackData);
}
extern "C" {
    pub fn ImGuiInputTextCallbackData_HasSelection(self_: *mut ImGuiInputTextCallbackData) -> bool;
}
extern "C" {
    pub fn ImGuiWindowClass_ImGuiWindowClass() -> *mut ImGuiWindowClass;
}
extern "C" {
    pub fn ImGuiWindowClass_destroy(self_: *mut ImGuiWindowClass);
}
extern "C" {
    pub fn ImGuiPayload_ImGuiPayload() -> *mut ImGuiPayload;
}
extern "C" {
    pub fn ImGuiPayload_destroy(self_: *mut ImGuiPayload);
}
extern "C" {
    pub fn ImGuiPayload_Clear(self_: *mut ImGuiPayload);
}
extern "C" {
    pub fn ImGuiPayload_IsDataType(self_: *mut ImGuiPayload, type_: *const cty::c_char) -> bool;
}
extern "C" {
    pub fn ImGuiPayload_IsPreview(self_: *mut ImGuiPayload) -> bool;
}
extern "C" {
    pub fn ImGuiPayload_IsDelivery(self_: *mut ImGuiPayload) -> bool;
}
extern "C" {
    pub fn ImGuiTableColumnSortSpecs_ImGuiTableColumnSortSpecs() -> *mut ImGuiTableColumnSortSpecs;
}
extern "C" {
    pub fn ImGuiTableColumnSortSpecs_destroy(self_: *mut ImGuiTableColumnSortSpecs);
}
extern "C" {
    pub fn ImGuiTableSortSpecs_ImGuiTableSortSpecs() -> *mut ImGuiTableSortSpecs;
}
extern "C" {
    pub fn ImGuiTableSortSpecs_destroy(self_: *mut ImGuiTableSortSpecs);
}
extern "C" {
    pub fn ImGuiOnceUponAFrame_ImGuiOnceUponAFrame() -> *mut ImGuiOnceUponAFrame;
}
extern "C" {
    pub fn ImGuiOnceUponAFrame_destroy(self_: *mut ImGuiOnceUponAFrame);
}
extern "C" {
    pub fn ImGuiTextFilter_ImGuiTextFilter(
        default_filter: *const cty::c_char,
    ) -> *mut ImGuiTextFilter;
}
extern "C" {
    pub fn ImGuiTextFilter_destroy(self_: *mut ImGuiTextFilter);
}
extern "C" {
    pub fn ImGuiTextFilter_Draw(
        self_: *mut ImGuiTextFilter,
        label: *const cty::c_char,
        width: f32,
    ) -> bool;
}
extern "C" {
    pub fn ImGuiTextFilter_PassFilter(
        self_: *mut ImGuiTextFilter,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    ) -> bool;
}
extern "C" {
    pub fn ImGuiTextFilter_Build(self_: *mut ImGuiTextFilter);
}
extern "C" {
    pub fn ImGuiTextFilter_Clear(self_: *mut ImGuiTextFilter);
}
extern "C" {
    pub fn ImGuiTextFilter_IsActive(self_: *mut ImGuiTextFilter) -> bool;
}
extern "C" {
    pub fn ImGuiTextRange_ImGuiTextRange_Nil() -> *mut ImGuiTextRange;
}
extern "C" {
    pub fn ImGuiTextRange_destroy(self_: *mut ImGuiTextRange);
}
extern "C" {
    pub fn ImGuiTextRange_ImGuiTextRange_Str(
        _b: *const cty::c_char,
        _e: *const cty::c_char,
    ) -> *mut ImGuiTextRange;
}
extern "C" {
    pub fn ImGuiTextRange_empty(self_: *mut ImGuiTextRange) -> bool;
}
extern "C" {
    pub fn ImGuiTextRange_split(
        self_: *mut ImGuiTextRange,
        separator: cty::c_char,
        out: *mut ImVector_ImGuiTextRange,
    );
}
extern "C" {
    pub fn ImGuiTextBuffer_ImGuiTextBuffer() -> *mut ImGuiTextBuffer;
}
extern "C" {
    pub fn ImGuiTextBuffer_destroy(self_: *mut ImGuiTextBuffer);
}
extern "C" {
    pub fn ImGuiTextBuffer_begin(self_: *mut ImGuiTextBuffer) -> *const cty::c_char;
}
extern "C" {
    pub fn ImGuiTextBuffer_end(self_: *mut ImGuiTextBuffer) -> *const cty::c_char;
}
extern "C" {
    pub fn ImGuiTextBuffer_size(self_: *mut ImGuiTextBuffer) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiTextBuffer_empty(self_: *mut ImGuiTextBuffer) -> bool;
}
extern "C" {
    pub fn ImGuiTextBuffer_clear(self_: *mut ImGuiTextBuffer);
}
extern "C" {
    pub fn ImGuiTextBuffer_reserve(self_: *mut ImGuiTextBuffer, capacity: cty::c_int);
}
extern "C" {
    pub fn ImGuiTextBuffer_c_str(self_: *mut ImGuiTextBuffer) -> *const cty::c_char;
}
extern "C" {
    pub fn ImGuiTextBuffer_append(
        self_: *mut ImGuiTextBuffer,
        str_: *const cty::c_char,
        str_end: *const cty::c_char,
    );
}
extern "C" {
    pub fn ImGuiStoragePair_ImGuiStoragePair_Int(
        _key: ImGuiID,
        _val_i: cty::c_int,
    ) -> *mut ImGuiStoragePair;
}
extern "C" {
    pub fn ImGuiStoragePair_destroy(self_: *mut ImGuiStoragePair);
}
extern "C" {
    pub fn ImGuiStoragePair_ImGuiStoragePair_Float(
        _key: ImGuiID,
        _val_f: f32,
    ) -> *mut ImGuiStoragePair;
}
extern "C" {
    pub fn ImGuiStoragePair_ImGuiStoragePair_Ptr(
        _key: ImGuiID,
        _val_p: *mut cty::c_void,
    ) -> *mut ImGuiStoragePair;
}
extern "C" {
    pub fn ImGuiStorage_Clear(self_: *mut ImGuiStorage);
}
extern "C" {
    pub fn ImGuiStorage_GetInt(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: cty::c_int,
    ) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiStorage_SetInt(self_: *mut ImGuiStorage, key: ImGuiID, val: cty::c_int);
}
extern "C" {
    pub fn ImGuiStorage_GetBool(self_: *mut ImGuiStorage, key: ImGuiID, default_val: bool) -> bool;
}
extern "C" {
    pub fn ImGuiStorage_SetBool(self_: *mut ImGuiStorage, key: ImGuiID, val: bool);
}
extern "C" {
    pub fn ImGuiStorage_GetFloat(self_: *mut ImGuiStorage, key: ImGuiID, default_val: f32) -> f32;
}
extern "C" {
    pub fn ImGuiStorage_SetFloat(self_: *mut ImGuiStorage, key: ImGuiID, val: f32);
}
extern "C" {
    pub fn ImGuiStorage_GetVoidPtr(self_: *mut ImGuiStorage, key: ImGuiID) -> *mut cty::c_void;
}
extern "C" {
    pub fn ImGuiStorage_SetVoidPtr(self_: *mut ImGuiStorage, key: ImGuiID, val: *mut cty::c_void);
}
extern "C" {
    pub fn ImGuiStorage_GetIntRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: cty::c_int,
    ) -> *mut cty::c_int;
}
extern "C" {
    pub fn ImGuiStorage_GetBoolRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: bool,
    ) -> *mut bool;
}
extern "C" {
    pub fn ImGuiStorage_GetFloatRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: f32,
    ) -> *mut f32;
}
extern "C" {
    pub fn ImGuiStorage_GetVoidPtrRef(
        self_: *mut ImGuiStorage,
        key: ImGuiID,
        default_val: *mut cty::c_void,
    ) -> *mut *mut cty::c_void;
}
extern "C" {
    pub fn ImGuiStorage_SetAllInt(self_: *mut ImGuiStorage, val: cty::c_int);
}
extern "C" {
    pub fn ImGuiStorage_BuildSortByKey(self_: *mut ImGuiStorage);
}
extern "C" {
    pub fn ImGuiListClipper_ImGuiListClipper() -> *mut ImGuiListClipper;
}
extern "C" {
    pub fn ImGuiListClipper_destroy(self_: *mut ImGuiListClipper);
}
extern "C" {
    pub fn ImGuiListClipper_Begin(
        self_: *mut ImGuiListClipper,
        items_count: cty::c_int,
        items_height: f32,
    );
}
extern "C" {
    pub fn ImGuiListClipper_End(self_: *mut ImGuiListClipper);
}
extern "C" {
    pub fn ImGuiListClipper_Step(self_: *mut ImGuiListClipper) -> bool;
}
extern "C" {
    pub fn ImGuiListClipper_ForceDisplayRangeByIndices(
        self_: *mut ImGuiListClipper,
        item_min: cty::c_int,
        item_max: cty::c_int,
    );
}
extern "C" {
    pub fn ImColor_ImColor_Nil() -> *mut ImColor;
}
extern "C" {
    pub fn ImColor_destroy(self_: *mut ImColor);
}
extern "C" {
    pub fn ImColor_ImColor_Float(r: f32, g: f32, b: f32, a: f32) -> *mut ImColor;
}
extern "C" {
    pub fn ImColor_ImColor_Vec4(col: ImVec4) -> *mut ImColor;
}
extern "C" {
    pub fn ImColor_ImColor_Int(
        r: cty::c_int,
        g: cty::c_int,
        b: cty::c_int,
        a: cty::c_int,
    ) -> *mut ImColor;
}
extern "C" {
    pub fn ImColor_ImColor_U32(rgba: ImU32) -> *mut ImColor;
}
extern "C" {
    pub fn ImColor_SetHSV(self_: *mut ImColor, h: f32, s: f32, v: f32, a: f32);
}
extern "C" {
    pub fn ImColor_HSV(pOut: *mut ImColor, h: f32, s: f32, v: f32, a: f32);
}
extern "C" {
    pub fn ImDrawCmd_ImDrawCmd() -> *mut ImDrawCmd;
}
extern "C" {
    pub fn ImDrawCmd_destroy(self_: *mut ImDrawCmd);
}
extern "C" {
    pub fn ImDrawCmd_GetTexID(self_: *mut ImDrawCmd) -> ImTextureID;
}
extern "C" {
    pub fn ImDrawListSplitter_ImDrawListSplitter() -> *mut ImDrawListSplitter;
}
extern "C" {
    pub fn ImDrawListSplitter_destroy(self_: *mut ImDrawListSplitter);
}
extern "C" {
    pub fn ImDrawListSplitter_Clear(self_: *mut ImDrawListSplitter);
}
extern "C" {
    pub fn ImDrawListSplitter_ClearFreeMemory(self_: *mut ImDrawListSplitter);
}
extern "C" {
    pub fn ImDrawListSplitter_Split(
        self_: *mut ImDrawListSplitter,
        draw_list: *mut ImDrawList,
        count: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawListSplitter_Merge(self_: *mut ImDrawListSplitter, draw_list: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawListSplitter_SetCurrentChannel(
        self_: *mut ImDrawListSplitter,
        draw_list: *mut ImDrawList,
        channel_idx: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_ImDrawList(shared_data: *mut ImDrawListSharedData) -> *mut ImDrawList;
}
extern "C" {
    pub fn ImDrawList_destroy(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_PushClipRect(
        self_: *mut ImDrawList,
        clip_rect_min: ImVec2,
        clip_rect_max: ImVec2,
        intersect_with_current_clip_rect: bool,
    );
}
extern "C" {
    pub fn ImDrawList_PushClipRectFullScreen(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_PopClipRect(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_PushTextureID(self_: *mut ImDrawList, texture_id: ImTextureID);
}
extern "C" {
    pub fn ImDrawList_PopTextureID(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_GetClipRectMin(pOut: *mut ImVec2, self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_GetClipRectMax(pOut: *mut ImVec2, self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_AddLine(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        col: ImU32,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddRect(
        self_: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        col: ImU32,
        rounding: f32,
        flags: ImDrawFlags,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddRectFilled(
        self_: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        col: ImU32,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
extern "C" {
    pub fn ImDrawList_AddRectFilledMultiColor(
        self_: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        col_upr_left: ImU32,
        col_upr_right: ImU32,
        col_bot_right: ImU32,
        col_bot_left: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_AddQuad(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        col: ImU32,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddQuadFilled(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_AddTriangle(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        col: ImU32,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddTriangleFilled(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_AddCircle(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddCircleFilled(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_AddNgon(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddNgonFilled(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        col: ImU32,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_AddText_Vec2(
        self_: *mut ImDrawList,
        pos: ImVec2,
        col: ImU32,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
extern "C" {
    pub fn ImDrawList_AddText_FontPtr(
        self_: *mut ImDrawList,
        font: *const ImFont,
        font_size: f32,
        pos: ImVec2,
        col: ImU32,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
        cpu_fine_clip_rect: *const ImVec4,
    );
}
extern "C" {
    pub fn ImDrawList_AddPolyline(
        self_: *mut ImDrawList,
        points: *const ImVec2,
        num_points: cty::c_int,
        col: ImU32,
        flags: ImDrawFlags,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_AddConvexPolyFilled(
        self_: *mut ImDrawList,
        points: *const ImVec2,
        num_points: cty::c_int,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_AddBezierCubic(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        col: ImU32,
        thickness: f32,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_AddBezierQuadratic(
        self_: *mut ImDrawList,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        col: ImU32,
        thickness: f32,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_AddImage(
        self_: *mut ImDrawList,
        user_texture_id: ImTextureID,
        p_min: ImVec2,
        p_max: ImVec2,
        uv_min: ImVec2,
        uv_max: ImVec2,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_AddImageQuad(
        self_: *mut ImDrawList,
        user_texture_id: ImTextureID,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        uv1: ImVec2,
        uv2: ImVec2,
        uv3: ImVec2,
        uv4: ImVec2,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_AddImageRounded(
        self_: *mut ImDrawList,
        user_texture_id: ImTextureID,
        p_min: ImVec2,
        p_max: ImVec2,
        uv_min: ImVec2,
        uv_max: ImVec2,
        col: ImU32,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
extern "C" {
    pub fn ImDrawList_PathClear(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_PathLineTo(self_: *mut ImDrawList, pos: ImVec2);
}
extern "C" {
    pub fn ImDrawList_PathLineToMergeDuplicate(self_: *mut ImDrawList, pos: ImVec2);
}
extern "C" {
    pub fn ImDrawList_PathFillConvex(self_: *mut ImDrawList, col: ImU32);
}
extern "C" {
    pub fn ImDrawList_PathStroke(
        self_: *mut ImDrawList,
        col: ImU32,
        flags: ImDrawFlags,
        thickness: f32,
    );
}
extern "C" {
    pub fn ImDrawList_PathArcTo(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min: f32,
        a_max: f32,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_PathArcToFast(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min_of_12: cty::c_int,
        a_max_of_12: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_PathBezierCubicCurveTo(
        self_: *mut ImDrawList,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_PathBezierQuadraticCurveTo(
        self_: *mut ImDrawList,
        p2: ImVec2,
        p3: ImVec2,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_PathRect(
        self_: *mut ImDrawList,
        rect_min: ImVec2,
        rect_max: ImVec2,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
extern "C" {
    pub fn ImDrawList_AddCallback(
        self_: *mut ImDrawList,
        callback: ImDrawCallback,
        callback_data: *mut cty::c_void,
    );
}
extern "C" {
    pub fn ImDrawList_AddDrawCmd(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_CloneOutput(self_: *mut ImDrawList) -> *mut ImDrawList;
}
extern "C" {
    pub fn ImDrawList_ChannelsSplit(self_: *mut ImDrawList, count: cty::c_int);
}
extern "C" {
    pub fn ImDrawList_ChannelsMerge(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList_ChannelsSetCurrent(self_: *mut ImDrawList, n: cty::c_int);
}
extern "C" {
    pub fn ImDrawList_PrimReserve(
        self_: *mut ImDrawList,
        idx_count: cty::c_int,
        vtx_count: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_PrimUnreserve(
        self_: *mut ImDrawList,
        idx_count: cty::c_int,
        vtx_count: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList_PrimRect(self_: *mut ImDrawList, a: ImVec2, b: ImVec2, col: ImU32);
}
extern "C" {
    pub fn ImDrawList_PrimRectUV(
        self_: *mut ImDrawList,
        a: ImVec2,
        b: ImVec2,
        uv_a: ImVec2,
        uv_b: ImVec2,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_PrimQuadUV(
        self_: *mut ImDrawList,
        a: ImVec2,
        b: ImVec2,
        c: ImVec2,
        d: ImVec2,
        uv_a: ImVec2,
        uv_b: ImVec2,
        uv_c: ImVec2,
        uv_d: ImVec2,
        col: ImU32,
    );
}
extern "C" {
    pub fn ImDrawList_PrimWriteVtx(self_: *mut ImDrawList, pos: ImVec2, uv: ImVec2, col: ImU32);
}
extern "C" {
    pub fn ImDrawList_PrimWriteIdx(self_: *mut ImDrawList, idx: ImDrawIdx);
}
extern "C" {
    pub fn ImDrawList_PrimVtx(self_: *mut ImDrawList, pos: ImVec2, uv: ImVec2, col: ImU32);
}
extern "C" {
    pub fn ImDrawList__ResetForNewFrame(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__ClearFreeMemory(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__PopUnusedDrawCmd(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__TryMergeDrawCmds(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__OnChangedClipRect(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__OnChangedTextureID(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__OnChangedVtxOffset(self_: *mut ImDrawList);
}
extern "C" {
    pub fn ImDrawList__CalcCircleAutoSegmentCount(
        self_: *mut ImDrawList,
        radius: f32,
    ) -> cty::c_int;
}
extern "C" {
    pub fn ImDrawList__PathArcToFastEx(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min_sample: cty::c_int,
        a_max_sample: cty::c_int,
        a_step: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawList__PathArcToN(
        self_: *mut ImDrawList,
        center: ImVec2,
        radius: f32,
        a_min: f32,
        a_max: f32,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawData_ImDrawData() -> *mut ImDrawData;
}
extern "C" {
    pub fn ImDrawData_destroy(self_: *mut ImDrawData);
}
extern "C" {
    pub fn ImDrawData_Clear(self_: *mut ImDrawData);
}
extern "C" {
    pub fn ImDrawData_DeIndexAllBuffers(self_: *mut ImDrawData);
}
extern "C" {
    pub fn ImDrawData_ScaleClipRects(self_: *mut ImDrawData, fb_scale: ImVec2);
}
extern "C" {
    pub fn ImFontConfig_ImFontConfig() -> *mut ImFontConfig;
}
extern "C" {
    pub fn ImFontConfig_destroy(self_: *mut ImFontConfig);
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_ImFontGlyphRangesBuilder() -> *mut ImFontGlyphRangesBuilder;
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_destroy(self_: *mut ImFontGlyphRangesBuilder);
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_Clear(self_: *mut ImFontGlyphRangesBuilder);
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_GetBit(self_: *mut ImFontGlyphRangesBuilder, n: usize) -> bool;
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_SetBit(self_: *mut ImFontGlyphRangesBuilder, n: usize);
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_AddChar(self_: *mut ImFontGlyphRangesBuilder, c: ImWchar);
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_AddText(
        self_: *mut ImFontGlyphRangesBuilder,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_AddRanges(
        self_: *mut ImFontGlyphRangesBuilder,
        ranges: *const ImWchar,
    );
}
extern "C" {
    pub fn ImFontGlyphRangesBuilder_BuildRanges(
        self_: *mut ImFontGlyphRangesBuilder,
        out_ranges: *mut ImVector_ImWchar,
    );
}
extern "C" {
    pub fn ImFontAtlasCustomRect_ImFontAtlasCustomRect() -> *mut ImFontAtlasCustomRect;
}
extern "C" {
    pub fn ImFontAtlasCustomRect_destroy(self_: *mut ImFontAtlasCustomRect);
}
extern "C" {
    pub fn ImFontAtlasCustomRect_IsPacked(self_: *mut ImFontAtlasCustomRect) -> bool;
}
extern "C" {
    pub fn ImFontAtlas_ImFontAtlas() -> *mut ImFontAtlas;
}
extern "C" {
    pub fn ImFontAtlas_destroy(self_: *mut ImFontAtlas);
}
extern "C" {
    pub fn ImFontAtlas_AddFont(
        self_: *mut ImFontAtlas,
        font_cfg: *const ImFontConfig,
    ) -> *mut ImFont;
}
extern "C" {
    pub fn ImFontAtlas_AddFontDefault(
        self_: *mut ImFontAtlas,
        font_cfg: *const ImFontConfig,
    ) -> *mut ImFont;
}
extern "C" {
    pub fn ImFontAtlas_AddFontFromFileTTF(
        self_: *mut ImFontAtlas,
        filename: *const cty::c_char,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
extern "C" {
    pub fn ImFontAtlas_AddFontFromMemoryTTF(
        self_: *mut ImFontAtlas,
        font_data: *mut cty::c_void,
        font_size: cty::c_int,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
extern "C" {
    pub fn ImFontAtlas_AddFontFromMemoryCompressedTTF(
        self_: *mut ImFontAtlas,
        compressed_font_data: *const cty::c_void,
        compressed_font_size: cty::c_int,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
extern "C" {
    pub fn ImFontAtlas_AddFontFromMemoryCompressedBase85TTF(
        self_: *mut ImFontAtlas,
        compressed_font_data_base85: *const cty::c_char,
        size_pixels: f32,
        font_cfg: *const ImFontConfig,
        glyph_ranges: *const ImWchar,
    ) -> *mut ImFont;
}
extern "C" {
    pub fn ImFontAtlas_ClearInputData(self_: *mut ImFontAtlas);
}
extern "C" {
    pub fn ImFontAtlas_ClearTexData(self_: *mut ImFontAtlas);
}
extern "C" {
    pub fn ImFontAtlas_ClearFonts(self_: *mut ImFontAtlas);
}
extern "C" {
    pub fn ImFontAtlas_Clear(self_: *mut ImFontAtlas);
}
extern "C" {
    pub fn ImFontAtlas_Build(self_: *mut ImFontAtlas) -> bool;
}
extern "C" {
    pub fn ImFontAtlas_GetTexDataAsAlpha8(
        self_: *mut ImFontAtlas,
        out_pixels: *mut *mut cty::c_uchar,
        out_width: *mut cty::c_int,
        out_height: *mut cty::c_int,
        out_bytes_per_pixel: *mut cty::c_int,
    );
}
extern "C" {
    pub fn ImFontAtlas_GetTexDataAsRGBA32(
        self_: *mut ImFontAtlas,
        out_pixels: *mut *mut cty::c_uchar,
        out_width: *mut cty::c_int,
        out_height: *mut cty::c_int,
        out_bytes_per_pixel: *mut cty::c_int,
    );
}
extern "C" {
    pub fn ImFontAtlas_IsBuilt(self_: *mut ImFontAtlas) -> bool;
}
extern "C" {
    pub fn ImFontAtlas_SetTexID(self_: *mut ImFontAtlas, id: ImTextureID);
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesDefault(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesGreek(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesKorean(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesJapanese(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesChineseFull(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesChineseSimplifiedCommon(
        self_: *mut ImFontAtlas,
    ) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesCyrillic(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesThai(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_GetGlyphRangesVietnamese(self_: *mut ImFontAtlas) -> *const ImWchar;
}
extern "C" {
    pub fn ImFontAtlas_AddCustomRectRegular(
        self_: *mut ImFontAtlas,
        width: cty::c_int,
        height: cty::c_int,
    ) -> cty::c_int;
}
extern "C" {
    pub fn ImFontAtlas_AddCustomRectFontGlyph(
        self_: *mut ImFontAtlas,
        font: *mut ImFont,
        id: ImWchar,
        width: cty::c_int,
        height: cty::c_int,
        advance_x: f32,
        offset: ImVec2,
    ) -> cty::c_int;
}
extern "C" {
    pub fn ImFontAtlas_GetCustomRectByIndex(
        self_: *mut ImFontAtlas,
        index: cty::c_int,
    ) -> *mut ImFontAtlasCustomRect;
}
extern "C" {
    pub fn ImFontAtlas_CalcCustomRectUV(
        self_: *mut ImFontAtlas,
        rect: *const ImFontAtlasCustomRect,
        out_uv_min: *mut ImVec2,
        out_uv_max: *mut ImVec2,
    );
}
extern "C" {
    pub fn ImFontAtlas_GetMouseCursorTexData(
        self_: *mut ImFontAtlas,
        cursor: ImGuiMouseCursor,
        out_offset: *mut ImVec2,
        out_size: *mut ImVec2,
        out_uv_border: *mut ImVec2,
        out_uv_fill: *mut ImVec2,
    ) -> bool;
}
extern "C" {
    pub fn ImFont_ImFont() -> *mut ImFont;
}
extern "C" {
    pub fn ImFont_destroy(self_: *mut ImFont);
}
extern "C" {
    pub fn ImFont_FindGlyph(self_: *mut ImFont, c: ImWchar) -> *const ImFontGlyph;
}
extern "C" {
    pub fn ImFont_FindGlyphNoFallback(self_: *mut ImFont, c: ImWchar) -> *const ImFontGlyph;
}
extern "C" {
    pub fn ImFont_GetCharAdvance(self_: *mut ImFont, c: ImWchar) -> f32;
}
extern "C" {
    pub fn ImFont_IsLoaded(self_: *mut ImFont) -> bool;
}
extern "C" {
    pub fn ImFont_GetDebugName(self_: *mut ImFont) -> *const cty::c_char;
}
extern "C" {
    pub fn ImFont_CalcTextSizeA(
        pOut: *mut ImVec2,
        self_: *mut ImFont,
        size: f32,
        max_width: f32,
        wrap_width: f32,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
        remaining: *mut *const cty::c_char,
    );
}
extern "C" {
    pub fn ImFont_CalcWordWrapPositionA(
        self_: *mut ImFont,
        scale: f32,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn ImFont_RenderChar(
        self_: *mut ImFont,
        draw_list: *mut ImDrawList,
        size: f32,
        pos: ImVec2,
        col: ImU32,
        c: ImWchar,
    );
}
extern "C" {
    pub fn ImFont_RenderText(
        self_: *mut ImFont,
        draw_list: *mut ImDrawList,
        size: f32,
        pos: ImVec2,
        col: ImU32,
        clip_rect: ImVec4,
        text_begin: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
        cpu_fine_clip: bool,
    );
}
extern "C" {
    pub fn ImFont_BuildLookupTable(self_: *mut ImFont);
}
extern "C" {
    pub fn ImFont_ClearOutputData(self_: *mut ImFont);
}
extern "C" {
    pub fn ImFont_GrowIndex(self_: *mut ImFont, new_size: cty::c_int);
}
extern "C" {
    pub fn ImFont_AddGlyph(
        self_: *mut ImFont,
        src_cfg: *const ImFontConfig,
        c: ImWchar,
        x0: f32,
        y0: f32,
        x1: f32,
        y1: f32,
        u0: f32,
        v0: f32,
        u1: f32,
        v1: f32,
        advance_x: f32,
    );
}
extern "C" {
    pub fn ImFont_AddRemapChar(self_: *mut ImFont, dst: ImWchar, src: ImWchar, overwrite_dst: bool);
}
extern "C" {
    pub fn ImFont_SetGlyphVisible(self_: *mut ImFont, c: ImWchar, visible: bool);
}
extern "C" {
    pub fn ImFont_IsGlyphRangeUnused(
        self_: *mut ImFont,
        c_begin: cty::c_uint,
        c_last: cty::c_uint,
    ) -> bool;
}
extern "C" {
    pub fn ImGuiViewport_ImGuiViewport() -> *mut ImGuiViewport;
}
extern "C" {
    pub fn ImGuiViewport_destroy(self_: *mut ImGuiViewport);
}
extern "C" {
    pub fn ImGuiViewport_GetCenter(pOut: *mut ImVec2, self_: *mut ImGuiViewport);
}
extern "C" {
    pub fn ImGuiViewport_GetWorkCenter(pOut: *mut ImVec2, self_: *mut ImGuiViewport);
}
extern "C" {
    pub fn ImGuiPlatformIO_ImGuiPlatformIO() -> *mut ImGuiPlatformIO;
}
extern "C" {
    pub fn ImGuiPlatformIO_destroy(self_: *mut ImGuiPlatformIO);
}
extern "C" {
    pub fn ImGuiPlatformMonitor_ImGuiPlatformMonitor() -> *mut ImGuiPlatformMonitor;
}
extern "C" {
    pub fn ImGuiPlatformMonitor_destroy(self_: *mut ImGuiPlatformMonitor);
}
extern "C" {
    pub fn ImGuiPlatformImeData_ImGuiPlatformImeData() -> *mut ImGuiPlatformImeData;
}
extern "C" {
    pub fn ImGuiPlatformImeData_destroy(self_: *mut ImGuiPlatformImeData);
}
extern "C" {
    pub fn igGetKeyIndex(key: ImGuiKey) -> ImGuiKey;
}
extern "C" {
    pub fn igImHashData(data: *const cty::c_void, data_size: usize, seed: ImU32) -> ImGuiID;
}
extern "C" {
    pub fn igImHashStr(data: *const cty::c_char, data_size: usize, seed: ImU32) -> ImGuiID;
}
extern "C" {
    pub fn igImQsort(
        base: *mut cty::c_void,
        count: usize,
        size_of_element: usize,
        compare_func: ::core::option::Option<
            unsafe extern "C" fn(arg1: *const cty::c_void, arg2: *const cty::c_void) -> cty::c_int,
        >,
    );
}
extern "C" {
    pub fn igImAlphaBlendColors(col_a: ImU32, col_b: ImU32) -> ImU32;
}
extern "C" {
    pub fn igImIsPowerOfTwo_Int(v: cty::c_int) -> bool;
}
extern "C" {
    pub fn igImIsPowerOfTwo_U64(v: ImU64) -> bool;
}
extern "C" {
    pub fn igImUpperPowerOfTwo(v: cty::c_int) -> cty::c_int;
}
extern "C" {
    pub fn igImStricmp(str1: *const cty::c_char, str2: *const cty::c_char) -> cty::c_int;
}
extern "C" {
    pub fn igImStrnicmp(
        str1: *const cty::c_char,
        str2: *const cty::c_char,
        count: usize,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImStrncpy(dst: *mut cty::c_char, src: *const cty::c_char, count: usize);
}
extern "C" {
    pub fn igImStrdup(str_: *const cty::c_char) -> *mut cty::c_char;
}
extern "C" {
    pub fn igImStrdupcpy(
        dst: *mut cty::c_char,
        p_dst_size: *mut usize,
        str_: *const cty::c_char,
    ) -> *mut cty::c_char;
}
extern "C" {
    pub fn igImStrchrRange(
        str_begin: *const cty::c_char,
        str_end: *const cty::c_char,
        c: cty::c_char,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igImStrlenW(str_: *const ImWchar) -> cty::c_int;
}
extern "C" {
    pub fn igImStreolRange(
        str_: *const cty::c_char,
        str_end: *const cty::c_char,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igImStrbolW(buf_mid_line: *const ImWchar, buf_begin: *const ImWchar) -> *const ImWchar;
}
extern "C" {
    pub fn igImStristr(
        haystack: *const cty::c_char,
        haystack_end: *const cty::c_char,
        needle: *const cty::c_char,
        needle_end: *const cty::c_char,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igImStrTrimBlanks(str_: *mut cty::c_char);
}
extern "C" {
    pub fn igImStrSkipBlank(str_: *const cty::c_char) -> *const cty::c_char;
}
extern "C" {
    pub fn igImToUpper(c: cty::c_char) -> cty::c_char;
}
extern "C" {
    pub fn igImCharIsBlankA(c: cty::c_char) -> bool;
}
extern "C" {
    pub fn igImCharIsBlankW(c: cty::c_uint) -> bool;
}
extern "C" {
    pub fn igImFormatString(
        buf: *mut cty::c_char,
        buf_size: usize,
        fmt: *const cty::c_char,
        ...
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImFormatStringToTempBuffer(
        out_buf: *mut *const cty::c_char,
        out_buf_end: *mut *const cty::c_char,
        fmt: *const cty::c_char,
        ...
    );
}
extern "C" {
    pub fn igImParseFormatFindStart(format: *const cty::c_char) -> *const cty::c_char;
}
extern "C" {
    pub fn igImParseFormatFindEnd(format: *const cty::c_char) -> *const cty::c_char;
}
extern "C" {
    pub fn igImParseFormatTrimDecorations(
        format: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: usize,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igImParseFormatSanitizeForPrinting(
        fmt_in: *const cty::c_char,
        fmt_out: *mut cty::c_char,
        fmt_out_size: usize,
    );
}
extern "C" {
    pub fn igImParseFormatSanitizeForScanning(
        fmt_in: *const cty::c_char,
        fmt_out: *mut cty::c_char,
        fmt_out_size: usize,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igImParseFormatPrecision(
        format: *const cty::c_char,
        default_value: cty::c_int,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImTextCharToUtf8(out_buf: *mut cty::c_char, c: cty::c_uint) -> *const cty::c_char;
}
extern "C" {
    pub fn igImTextStrToUtf8(
        out_buf: *mut cty::c_char,
        out_buf_size: cty::c_int,
        in_text: *const ImWchar,
        in_text_end: *const ImWchar,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImTextCharFromUtf8(
        out_char: *mut cty::c_uint,
        in_text: *const cty::c_char,
        in_text_end: *const cty::c_char,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImTextStrFromUtf8(
        out_buf: *mut ImWchar,
        out_buf_size: cty::c_int,
        in_text: *const cty::c_char,
        in_text_end: *const cty::c_char,
        in_remaining: *mut *const cty::c_char,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImTextCountCharsFromUtf8(
        in_text: *const cty::c_char,
        in_text_end: *const cty::c_char,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImTextCountUtf8BytesFromChar(
        in_text: *const cty::c_char,
        in_text_end: *const cty::c_char,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImTextCountUtf8BytesFromStr(
        in_text: *const ImWchar,
        in_text_end: *const ImWchar,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igImFileOpen(filename: *const cty::c_char, mode: *const cty::c_char) -> ImFileHandle;
}
extern "C" {
    pub fn igImFileClose(file: ImFileHandle) -> bool;
}
extern "C" {
    pub fn igImFileGetSize(file: ImFileHandle) -> ImU64;
}
extern "C" {
    pub fn igImFileRead(
        data: *mut cty::c_void,
        size: ImU64,
        count: ImU64,
        file: ImFileHandle,
    ) -> ImU64;
}
extern "C" {
    pub fn igImFileWrite(
        data: *const cty::c_void,
        size: ImU64,
        count: ImU64,
        file: ImFileHandle,
    ) -> ImU64;
}
extern "C" {
    pub fn igImFileLoadToMemory(
        filename: *const cty::c_char,
        mode: *const cty::c_char,
        out_file_size: *mut usize,
        padding_bytes: cty::c_int,
    ) -> *mut cty::c_void;
}
extern "C" {
    pub fn igImPow_Float(x: f32, y: f32) -> f32;
}
extern "C" {
    pub fn igImPow_double(x: f64, y: f64) -> f64;
}
extern "C" {
    pub fn igImLog_Float(x: f32) -> f32;
}
extern "C" {
    pub fn igImLog_double(x: f64) -> f64;
}
extern "C" {
    pub fn igImAbs_Int(x: cty::c_int) -> cty::c_int;
}
extern "C" {
    pub fn igImAbs_Float(x: f32) -> f32;
}
extern "C" {
    pub fn igImAbs_double(x: f64) -> f64;
}
extern "C" {
    pub fn igImSign_Float(x: f32) -> f32;
}
extern "C" {
    pub fn igImSign_double(x: f64) -> f64;
}
extern "C" {
    pub fn igImRsqrt_Float(x: f32) -> f32;
}
extern "C" {
    pub fn igImRsqrt_double(x: f64) -> f64;
}
extern "C" {
    pub fn igImMin(pOut: *mut ImVec2, lhs: ImVec2, rhs: ImVec2);
}
extern "C" {
    pub fn igImMax(pOut: *mut ImVec2, lhs: ImVec2, rhs: ImVec2);
}
extern "C" {
    pub fn igImClamp(pOut: *mut ImVec2, v: ImVec2, mn: ImVec2, mx: ImVec2);
}
extern "C" {
    pub fn igImLerp_Vec2Float(pOut: *mut ImVec2, a: ImVec2, b: ImVec2, t: f32);
}
extern "C" {
    pub fn igImLerp_Vec2Vec2(pOut: *mut ImVec2, a: ImVec2, b: ImVec2, t: ImVec2);
}
extern "C" {
    pub fn igImLerp_Vec4(pOut: *mut ImVec4, a: ImVec4, b: ImVec4, t: f32);
}
extern "C" {
    pub fn igImSaturate(f: f32) -> f32;
}
extern "C" {
    pub fn igImLengthSqr_Vec2(lhs: ImVec2) -> f32;
}
extern "C" {
    pub fn igImLengthSqr_Vec4(lhs: ImVec4) -> f32;
}
extern "C" {
    pub fn igImInvLength(lhs: ImVec2, fail_value: f32) -> f32;
}
extern "C" {
    pub fn igImFloor_Float(f: f32) -> f32;
}
extern "C" {
    pub fn igImFloorSigned_Float(f: f32) -> f32;
}
extern "C" {
    pub fn igImFloor_Vec2(pOut: *mut ImVec2, v: ImVec2);
}
extern "C" {
    pub fn igImFloorSigned_Vec2(pOut: *mut ImVec2, v: ImVec2);
}
extern "C" {
    pub fn igImModPositive(a: cty::c_int, b: cty::c_int) -> cty::c_int;
}
extern "C" {
    pub fn igImDot(a: ImVec2, b: ImVec2) -> f32;
}
extern "C" {
    pub fn igImRotate(pOut: *mut ImVec2, v: ImVec2, cos_a: f32, sin_a: f32);
}
extern "C" {
    pub fn igImLinearSweep(current: f32, target: f32, speed: f32) -> f32;
}
extern "C" {
    pub fn igImMul(pOut: *mut ImVec2, lhs: ImVec2, rhs: ImVec2);
}
extern "C" {
    pub fn igImIsFloatAboveGuaranteedIntegerPrecision(f: f32) -> bool;
}
extern "C" {
    pub fn igImExponentialMovingAverage(avg: f32, sample: f32, n: cty::c_int) -> f32;
}
extern "C" {
    pub fn igImBezierCubicCalc(
        pOut: *mut ImVec2,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        t: f32,
    );
}
extern "C" {
    pub fn igImBezierCubicClosestPoint(
        pOut: *mut ImVec2,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        p: ImVec2,
        num_segments: cty::c_int,
    );
}
extern "C" {
    pub fn igImBezierCubicClosestPointCasteljau(
        pOut: *mut ImVec2,
        p1: ImVec2,
        p2: ImVec2,
        p3: ImVec2,
        p4: ImVec2,
        p: ImVec2,
        tess_tol: f32,
    );
}
extern "C" {
    pub fn igImBezierQuadraticCalc(pOut: *mut ImVec2, p1: ImVec2, p2: ImVec2, p3: ImVec2, t: f32);
}
extern "C" {
    pub fn igImLineClosestPoint(pOut: *mut ImVec2, a: ImVec2, b: ImVec2, p: ImVec2);
}
extern "C" {
    pub fn igImTriangleContainsPoint(a: ImVec2, b: ImVec2, c: ImVec2, p: ImVec2) -> bool;
}
extern "C" {
    pub fn igImTriangleClosestPoint(pOut: *mut ImVec2, a: ImVec2, b: ImVec2, c: ImVec2, p: ImVec2);
}
extern "C" {
    pub fn igImTriangleBarycentricCoords(
        a: ImVec2,
        b: ImVec2,
        c: ImVec2,
        p: ImVec2,
        out_u: *mut f32,
        out_v: *mut f32,
        out_w: *mut f32,
    );
}
extern "C" {
    pub fn igImTriangleArea(a: ImVec2, b: ImVec2, c: ImVec2) -> f32;
}
extern "C" {
    pub fn igImGetDirQuadrantFromDelta(dx: f32, dy: f32) -> ImGuiDir;
}
extern "C" {
    pub fn ImVec1_ImVec1_Nil() -> *mut ImVec1;
}
extern "C" {
    pub fn ImVec1_destroy(self_: *mut ImVec1);
}
extern "C" {
    pub fn ImVec1_ImVec1_Float(_x: f32) -> *mut ImVec1;
}
extern "C" {
    pub fn ImVec2ih_ImVec2ih_Nil() -> *mut ImVec2ih;
}
extern "C" {
    pub fn ImVec2ih_destroy(self_: *mut ImVec2ih);
}
extern "C" {
    pub fn ImVec2ih_ImVec2ih_short(_x: cty::c_short, _y: cty::c_short) -> *mut ImVec2ih;
}
extern "C" {
    pub fn ImVec2ih_ImVec2ih_Vec2(rhs: ImVec2) -> *mut ImVec2ih;
}
extern "C" {
    pub fn ImRect_ImRect_Nil() -> *mut ImRect;
}
extern "C" {
    pub fn ImRect_destroy(self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_ImRect_Vec2(min: ImVec2, max: ImVec2) -> *mut ImRect;
}
extern "C" {
    pub fn ImRect_ImRect_Vec4(v: ImVec4) -> *mut ImRect;
}
extern "C" {
    pub fn ImRect_ImRect_Float(x1: f32, y1: f32, x2: f32, y2: f32) -> *mut ImRect;
}
extern "C" {
    pub fn ImRect_GetCenter(pOut: *mut ImVec2, self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_GetSize(pOut: *mut ImVec2, self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_GetWidth(self_: *mut ImRect) -> f32;
}
extern "C" {
    pub fn ImRect_GetHeight(self_: *mut ImRect) -> f32;
}
extern "C" {
    pub fn ImRect_GetArea(self_: *mut ImRect) -> f32;
}
extern "C" {
    pub fn ImRect_GetTL(pOut: *mut ImVec2, self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_GetTR(pOut: *mut ImVec2, self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_GetBL(pOut: *mut ImVec2, self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_GetBR(pOut: *mut ImVec2, self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_Contains_Vec2(self_: *mut ImRect, p: ImVec2) -> bool;
}
extern "C" {
    pub fn ImRect_Contains_Rect(self_: *mut ImRect, r: ImRect) -> bool;
}
extern "C" {
    pub fn ImRect_Overlaps(self_: *mut ImRect, r: ImRect) -> bool;
}
extern "C" {
    pub fn ImRect_Add_Vec2(self_: *mut ImRect, p: ImVec2);
}
extern "C" {
    pub fn ImRect_Add_Rect(self_: *mut ImRect, r: ImRect);
}
extern "C" {
    pub fn ImRect_Expand_Float(self_: *mut ImRect, amount: f32);
}
extern "C" {
    pub fn ImRect_Expand_Vec2(self_: *mut ImRect, amount: ImVec2);
}
extern "C" {
    pub fn ImRect_Translate(self_: *mut ImRect, d: ImVec2);
}
extern "C" {
    pub fn ImRect_TranslateX(self_: *mut ImRect, dx: f32);
}
extern "C" {
    pub fn ImRect_TranslateY(self_: *mut ImRect, dy: f32);
}
extern "C" {
    pub fn ImRect_ClipWith(self_: *mut ImRect, r: ImRect);
}
extern "C" {
    pub fn ImRect_ClipWithFull(self_: *mut ImRect, r: ImRect);
}
extern "C" {
    pub fn ImRect_Floor(self_: *mut ImRect);
}
extern "C" {
    pub fn ImRect_IsInverted(self_: *mut ImRect) -> bool;
}
extern "C" {
    pub fn ImRect_ToVec4(pOut: *mut ImVec4, self_: *mut ImRect);
}
extern "C" {
    pub fn igImBitArrayTestBit(arr: *const ImU32, n: cty::c_int) -> bool;
}
extern "C" {
    pub fn igImBitArrayClearBit(arr: *mut ImU32, n: cty::c_int);
}
extern "C" {
    pub fn igImBitArraySetBit(arr: *mut ImU32, n: cty::c_int);
}
extern "C" {
    pub fn igImBitArraySetBitRange(arr: *mut ImU32, n: cty::c_int, n2: cty::c_int);
}
extern "C" {
    pub fn ImBitVector_Create(self_: *mut ImBitVector, sz: cty::c_int);
}
extern "C" {
    pub fn ImBitVector_Clear(self_: *mut ImBitVector);
}
extern "C" {
    pub fn ImBitVector_TestBit(self_: *mut ImBitVector, n: cty::c_int) -> bool;
}
extern "C" {
    pub fn ImBitVector_SetBit(self_: *mut ImBitVector, n: cty::c_int);
}
extern "C" {
    pub fn ImBitVector_ClearBit(self_: *mut ImBitVector, n: cty::c_int);
}
extern "C" {
    pub fn ImGuiTextIndex_clear(self_: *mut ImGuiTextIndex);
}
extern "C" {
    pub fn ImGuiTextIndex_size(self_: *mut ImGuiTextIndex) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiTextIndex_get_line_begin(
        self_: *mut ImGuiTextIndex,
        base: *const cty::c_char,
        n: cty::c_int,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn ImGuiTextIndex_get_line_end(
        self_: *mut ImGuiTextIndex,
        base: *const cty::c_char,
        n: cty::c_int,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn ImGuiTextIndex_append(
        self_: *mut ImGuiTextIndex,
        base: *const cty::c_char,
        old_size: cty::c_int,
        new_size: cty::c_int,
    );
}
extern "C" {
    pub fn ImDrawListSharedData_ImDrawListSharedData() -> *mut ImDrawListSharedData;
}
extern "C" {
    pub fn ImDrawListSharedData_destroy(self_: *mut ImDrawListSharedData);
}
extern "C" {
    pub fn ImDrawListSharedData_SetCircleTessellationMaxError(
        self_: *mut ImDrawListSharedData,
        max_error: f32,
    );
}
extern "C" {
    pub fn ImDrawDataBuilder_Clear(self_: *mut ImDrawDataBuilder);
}
extern "C" {
    pub fn ImDrawDataBuilder_ClearFreeMemory(self_: *mut ImDrawDataBuilder);
}
extern "C" {
    pub fn ImDrawDataBuilder_GetDrawListCount(self_: *mut ImDrawDataBuilder) -> cty::c_int;
}
extern "C" {
    pub fn ImDrawDataBuilder_FlattenIntoSingleLayer(self_: *mut ImDrawDataBuilder);
}
extern "C" {
    pub fn ImGuiStyleMod_ImGuiStyleMod_Int(idx: ImGuiStyleVar, v: cty::c_int)
        -> *mut ImGuiStyleMod;
}
extern "C" {
    pub fn ImGuiStyleMod_destroy(self_: *mut ImGuiStyleMod);
}
extern "C" {
    pub fn ImGuiStyleMod_ImGuiStyleMod_Float(idx: ImGuiStyleVar, v: f32) -> *mut ImGuiStyleMod;
}
extern "C" {
    pub fn ImGuiStyleMod_ImGuiStyleMod_Vec2(idx: ImGuiStyleVar, v: ImVec2) -> *mut ImGuiStyleMod;
}
extern "C" {
    pub fn ImGuiComboPreviewData_ImGuiComboPreviewData() -> *mut ImGuiComboPreviewData;
}
extern "C" {
    pub fn ImGuiComboPreviewData_destroy(self_: *mut ImGuiComboPreviewData);
}
extern "C" {
    pub fn ImGuiMenuColumns_ImGuiMenuColumns() -> *mut ImGuiMenuColumns;
}
extern "C" {
    pub fn ImGuiMenuColumns_destroy(self_: *mut ImGuiMenuColumns);
}
extern "C" {
    pub fn ImGuiMenuColumns_Update(
        self_: *mut ImGuiMenuColumns,
        spacing: f32,
        window_reappearing: bool,
    );
}
extern "C" {
    pub fn ImGuiMenuColumns_DeclColumns(
        self_: *mut ImGuiMenuColumns,
        w_icon: f32,
        w_label: f32,
        w_shortcut: f32,
        w_mark: f32,
    ) -> f32;
}
extern "C" {
    pub fn ImGuiMenuColumns_CalcNextTotalWidth(self_: *mut ImGuiMenuColumns, update_offsets: bool);
}
extern "C" {
    pub fn ImGuiInputTextState_ImGuiInputTextState(
        ctx: *mut ImGuiContext,
    ) -> *mut ImGuiInputTextState;
}
extern "C" {
    pub fn ImGuiInputTextState_destroy(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiInputTextState_ClearText(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiInputTextState_ClearFreeMemory(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiInputTextState_GetUndoAvailCount(self_: *mut ImGuiInputTextState) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiInputTextState_GetRedoAvailCount(self_: *mut ImGuiInputTextState) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiInputTextState_OnKeyPressed(self_: *mut ImGuiInputTextState, key: cty::c_int);
}
extern "C" {
    pub fn ImGuiInputTextState_CursorAnimReset(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiInputTextState_CursorClamp(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiInputTextState_HasSelection(self_: *mut ImGuiInputTextState) -> bool;
}
extern "C" {
    pub fn ImGuiInputTextState_ClearSelection(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiInputTextState_GetCursorPos(self_: *mut ImGuiInputTextState) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiInputTextState_GetSelectionStart(self_: *mut ImGuiInputTextState) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiInputTextState_GetSelectionEnd(self_: *mut ImGuiInputTextState) -> cty::c_int;
}
extern "C" {
    pub fn ImGuiInputTextState_SelectAll(self_: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn ImGuiPopupData_ImGuiPopupData() -> *mut ImGuiPopupData;
}
extern "C" {
    pub fn ImGuiPopupData_destroy(self_: *mut ImGuiPopupData);
}
extern "C" {
    pub fn ImGuiNextWindowData_ImGuiNextWindowData() -> *mut ImGuiNextWindowData;
}
extern "C" {
    pub fn ImGuiNextWindowData_destroy(self_: *mut ImGuiNextWindowData);
}
extern "C" {
    pub fn ImGuiNextWindowData_ClearFlags(self_: *mut ImGuiNextWindowData);
}
extern "C" {
    pub fn ImGuiNextItemData_ImGuiNextItemData() -> *mut ImGuiNextItemData;
}
extern "C" {
    pub fn ImGuiNextItemData_destroy(self_: *mut ImGuiNextItemData);
}
extern "C" {
    pub fn ImGuiNextItemData_ClearFlags(self_: *mut ImGuiNextItemData);
}
extern "C" {
    pub fn ImGuiLastItemData_ImGuiLastItemData() -> *mut ImGuiLastItemData;
}
extern "C" {
    pub fn ImGuiLastItemData_destroy(self_: *mut ImGuiLastItemData);
}
extern "C" {
    pub fn ImGuiStackSizes_ImGuiStackSizes() -> *mut ImGuiStackSizes;
}
extern "C" {
    pub fn ImGuiStackSizes_destroy(self_: *mut ImGuiStackSizes);
}
extern "C" {
    pub fn ImGuiStackSizes_SetToCurrentState(self_: *mut ImGuiStackSizes);
}
extern "C" {
    pub fn ImGuiStackSizes_CompareWithCurrentState(self_: *mut ImGuiStackSizes);
}
extern "C" {
    pub fn ImGuiPtrOrIndex_ImGuiPtrOrIndex_Ptr(ptr: *mut cty::c_void) -> *mut ImGuiPtrOrIndex;
}
extern "C" {
    pub fn ImGuiPtrOrIndex_destroy(self_: *mut ImGuiPtrOrIndex);
}
extern "C" {
    pub fn ImGuiPtrOrIndex_ImGuiPtrOrIndex_Int(index: cty::c_int) -> *mut ImGuiPtrOrIndex;
}
extern "C" {
    pub fn ImGuiInputEvent_ImGuiInputEvent() -> *mut ImGuiInputEvent;
}
extern "C" {
    pub fn ImGuiInputEvent_destroy(self_: *mut ImGuiInputEvent);
}
extern "C" {
    pub fn ImGuiKeyRoutingData_ImGuiKeyRoutingData() -> *mut ImGuiKeyRoutingData;
}
extern "C" {
    pub fn ImGuiKeyRoutingData_destroy(self_: *mut ImGuiKeyRoutingData);
}
extern "C" {
    pub fn ImGuiKeyRoutingTable_ImGuiKeyRoutingTable() -> *mut ImGuiKeyRoutingTable;
}
extern "C" {
    pub fn ImGuiKeyRoutingTable_destroy(self_: *mut ImGuiKeyRoutingTable);
}
extern "C" {
    pub fn ImGuiKeyRoutingTable_Clear(self_: *mut ImGuiKeyRoutingTable);
}
extern "C" {
    pub fn ImGuiKeyOwnerData_ImGuiKeyOwnerData() -> *mut ImGuiKeyOwnerData;
}
extern "C" {
    pub fn ImGuiKeyOwnerData_destroy(self_: *mut ImGuiKeyOwnerData);
}
extern "C" {
    pub fn ImGuiListClipperRange_FromIndices(
        min: cty::c_int,
        max: cty::c_int,
    ) -> ImGuiListClipperRange;
}
extern "C" {
    pub fn ImGuiListClipperRange_FromPositions(
        y1: f32,
        y2: f32,
        off_min: cty::c_int,
        off_max: cty::c_int,
    ) -> ImGuiListClipperRange;
}
extern "C" {
    pub fn ImGuiListClipperData_ImGuiListClipperData() -> *mut ImGuiListClipperData;
}
extern "C" {
    pub fn ImGuiListClipperData_destroy(self_: *mut ImGuiListClipperData);
}
extern "C" {
    pub fn ImGuiListClipperData_Reset(
        self_: *mut ImGuiListClipperData,
        clipper: *mut ImGuiListClipper,
    );
}
extern "C" {
    pub fn ImGuiNavItemData_ImGuiNavItemData() -> *mut ImGuiNavItemData;
}
extern "C" {
    pub fn ImGuiNavItemData_destroy(self_: *mut ImGuiNavItemData);
}
extern "C" {
    pub fn ImGuiNavItemData_Clear(self_: *mut ImGuiNavItemData);
}
extern "C" {
    pub fn ImGuiOldColumnData_ImGuiOldColumnData() -> *mut ImGuiOldColumnData;
}
extern "C" {
    pub fn ImGuiOldColumnData_destroy(self_: *mut ImGuiOldColumnData);
}
extern "C" {
    pub fn ImGuiOldColumns_ImGuiOldColumns() -> *mut ImGuiOldColumns;
}
extern "C" {
    pub fn ImGuiOldColumns_destroy(self_: *mut ImGuiOldColumns);
}
extern "C" {
    pub fn ImGuiDockNode_ImGuiDockNode(id: ImGuiID) -> *mut ImGuiDockNode;
}
extern "C" {
    pub fn ImGuiDockNode_destroy(self_: *mut ImGuiDockNode);
}
extern "C" {
    pub fn ImGuiDockNode_IsRootNode(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsDockSpace(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsFloatingNode(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsCentralNode(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsHiddenTabBar(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsNoTabBar(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsSplitNode(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsLeafNode(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_IsEmpty(self_: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn ImGuiDockNode_Rect(pOut: *mut ImRect, self_: *mut ImGuiDockNode);
}
extern "C" {
    pub fn ImGuiDockNode_SetLocalFlags(self_: *mut ImGuiDockNode, flags: ImGuiDockNodeFlags);
}
extern "C" {
    pub fn ImGuiDockNode_UpdateMergedFlags(self_: *mut ImGuiDockNode);
}
extern "C" {
    pub fn ImGuiDockContext_ImGuiDockContext() -> *mut ImGuiDockContext;
}
extern "C" {
    pub fn ImGuiDockContext_destroy(self_: *mut ImGuiDockContext);
}
extern "C" {
    pub fn ImGuiViewportP_ImGuiViewportP() -> *mut ImGuiViewportP;
}
extern "C" {
    pub fn ImGuiViewportP_destroy(self_: *mut ImGuiViewportP);
}
extern "C" {
    pub fn ImGuiViewportP_ClearRequestFlags(self_: *mut ImGuiViewportP);
}
extern "C" {
    pub fn ImGuiViewportP_CalcWorkRectPos(
        pOut: *mut ImVec2,
        self_: *mut ImGuiViewportP,
        off_min: ImVec2,
    );
}
extern "C" {
    pub fn ImGuiViewportP_CalcWorkRectSize(
        pOut: *mut ImVec2,
        self_: *mut ImGuiViewportP,
        off_min: ImVec2,
        off_max: ImVec2,
    );
}
extern "C" {
    pub fn ImGuiViewportP_UpdateWorkRect(self_: *mut ImGuiViewportP);
}
extern "C" {
    pub fn ImGuiViewportP_GetMainRect(pOut: *mut ImRect, self_: *mut ImGuiViewportP);
}
extern "C" {
    pub fn ImGuiViewportP_GetWorkRect(pOut: *mut ImRect, self_: *mut ImGuiViewportP);
}
extern "C" {
    pub fn ImGuiViewportP_GetBuildWorkRect(pOut: *mut ImRect, self_: *mut ImGuiViewportP);
}
extern "C" {
    pub fn ImGuiWindowSettings_ImGuiWindowSettings() -> *mut ImGuiWindowSettings;
}
extern "C" {
    pub fn ImGuiWindowSettings_destroy(self_: *mut ImGuiWindowSettings);
}
extern "C" {
    pub fn ImGuiWindowSettings_GetName(self_: *mut ImGuiWindowSettings) -> *mut cty::c_char;
}
extern "C" {
    pub fn ImGuiSettingsHandler_ImGuiSettingsHandler() -> *mut ImGuiSettingsHandler;
}
extern "C" {
    pub fn ImGuiSettingsHandler_destroy(self_: *mut ImGuiSettingsHandler);
}
extern "C" {
    pub fn ImGuiMetricsConfig_ImGuiMetricsConfig() -> *mut ImGuiMetricsConfig;
}
extern "C" {
    pub fn ImGuiMetricsConfig_destroy(self_: *mut ImGuiMetricsConfig);
}
extern "C" {
    pub fn ImGuiStackLevelInfo_ImGuiStackLevelInfo() -> *mut ImGuiStackLevelInfo;
}
extern "C" {
    pub fn ImGuiStackLevelInfo_destroy(self_: *mut ImGuiStackLevelInfo);
}
extern "C" {
    pub fn ImGuiStackTool_ImGuiStackTool() -> *mut ImGuiStackTool;
}
extern "C" {
    pub fn ImGuiStackTool_destroy(self_: *mut ImGuiStackTool);
}
extern "C" {
    pub fn ImGuiContextHook_ImGuiContextHook() -> *mut ImGuiContextHook;
}
extern "C" {
    pub fn ImGuiContextHook_destroy(self_: *mut ImGuiContextHook);
}
extern "C" {
    pub fn ImGuiContext_ImGuiContext(shared_font_atlas: *mut ImFontAtlas) -> *mut ImGuiContext;
}
extern "C" {
    pub fn ImGuiContext_destroy(self_: *mut ImGuiContext);
}
extern "C" {
    pub fn ImGuiWindow_ImGuiWindow(
        context: *mut ImGuiContext,
        name: *const cty::c_char,
    ) -> *mut ImGuiWindow;
}
extern "C" {
    pub fn ImGuiWindow_destroy(self_: *mut ImGuiWindow);
}
extern "C" {
    pub fn ImGuiWindow_GetID_Str(
        self_: *mut ImGuiWindow,
        str_: *const cty::c_char,
        str_end: *const cty::c_char,
    ) -> ImGuiID;
}
extern "C" {
    pub fn ImGuiWindow_GetID_Ptr(self_: *mut ImGuiWindow, ptr: *const cty::c_void) -> ImGuiID;
}
extern "C" {
    pub fn ImGuiWindow_GetID_Int(self_: *mut ImGuiWindow, n: cty::c_int) -> ImGuiID;
}
extern "C" {
    pub fn ImGuiWindow_GetIDFromRectangle(self_: *mut ImGuiWindow, r_abs: ImRect) -> ImGuiID;
}
extern "C" {
    pub fn ImGuiWindow_Rect(pOut: *mut ImRect, self_: *mut ImGuiWindow);
}
extern "C" {
    pub fn ImGuiWindow_CalcFontSize(self_: *mut ImGuiWindow) -> f32;
}
extern "C" {
    pub fn ImGuiWindow_TitleBarHeight(self_: *mut ImGuiWindow) -> f32;
}
extern "C" {
    pub fn ImGuiWindow_TitleBarRect(pOut: *mut ImRect, self_: *mut ImGuiWindow);
}
extern "C" {
    pub fn ImGuiWindow_MenuBarHeight(self_: *mut ImGuiWindow) -> f32;
}
extern "C" {
    pub fn ImGuiWindow_MenuBarRect(pOut: *mut ImRect, self_: *mut ImGuiWindow);
}
extern "C" {
    pub fn ImGuiTabItem_ImGuiTabItem() -> *mut ImGuiTabItem;
}
extern "C" {
    pub fn ImGuiTabItem_destroy(self_: *mut ImGuiTabItem);
}
extern "C" {
    pub fn ImGuiTabBar_ImGuiTabBar() -> *mut ImGuiTabBar;
}
extern "C" {
    pub fn ImGuiTabBar_destroy(self_: *mut ImGuiTabBar);
}
extern "C" {
    pub fn ImGuiTabBar_GetTabOrder(self_: *mut ImGuiTabBar, tab: *const ImGuiTabItem)
        -> cty::c_int;
}
extern "C" {
    pub fn ImGuiTabBar_GetTabName(
        self_: *mut ImGuiTabBar,
        tab: *const ImGuiTabItem,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn ImGuiTableColumn_ImGuiTableColumn() -> *mut ImGuiTableColumn;
}
extern "C" {
    pub fn ImGuiTableColumn_destroy(self_: *mut ImGuiTableColumn);
}
extern "C" {
    pub fn ImGuiTableInstanceData_ImGuiTableInstanceData() -> *mut ImGuiTableInstanceData;
}
extern "C" {
    pub fn ImGuiTableInstanceData_destroy(self_: *mut ImGuiTableInstanceData);
}
extern "C" {
    pub fn ImGuiTable_ImGuiTable() -> *mut ImGuiTable;
}
extern "C" {
    pub fn ImGuiTable_destroy(self_: *mut ImGuiTable);
}
extern "C" {
    pub fn ImGuiTableTempData_ImGuiTableTempData() -> *mut ImGuiTableTempData;
}
extern "C" {
    pub fn ImGuiTableTempData_destroy(self_: *mut ImGuiTableTempData);
}
extern "C" {
    pub fn ImGuiTableColumnSettings_ImGuiTableColumnSettings() -> *mut ImGuiTableColumnSettings;
}
extern "C" {
    pub fn ImGuiTableColumnSettings_destroy(self_: *mut ImGuiTableColumnSettings);
}
extern "C" {
    pub fn ImGuiTableSettings_ImGuiTableSettings() -> *mut ImGuiTableSettings;
}
extern "C" {
    pub fn ImGuiTableSettings_destroy(self_: *mut ImGuiTableSettings);
}
extern "C" {
    pub fn ImGuiTableSettings_GetColumnSettings(
        self_: *mut ImGuiTableSettings,
    ) -> *mut ImGuiTableColumnSettings;
}
extern "C" {
    pub fn igGetCurrentWindowRead() -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igGetCurrentWindow() -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igFindWindowByID(id: ImGuiID) -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igFindWindowByName(name: *const cty::c_char) -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igUpdateWindowParentAndRootLinks(
        window: *mut ImGuiWindow,
        flags: ImGuiWindowFlags,
        parent_window: *mut ImGuiWindow,
    );
}
extern "C" {
    pub fn igCalcWindowNextAutoFitSize(pOut: *mut ImVec2, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igIsWindowChildOf(
        window: *mut ImGuiWindow,
        potential_parent: *mut ImGuiWindow,
        popup_hierarchy: bool,
        dock_hierarchy: bool,
    ) -> bool;
}
extern "C" {
    pub fn igIsWindowWithinBeginStackOf(
        window: *mut ImGuiWindow,
        potential_parent: *mut ImGuiWindow,
    ) -> bool;
}
extern "C" {
    pub fn igIsWindowAbove(
        potential_above: *mut ImGuiWindow,
        potential_below: *mut ImGuiWindow,
    ) -> bool;
}
extern "C" {
    pub fn igIsWindowNavFocusable(window: *mut ImGuiWindow) -> bool;
}
extern "C" {
    pub fn igSetWindowPos_WindowPtr(window: *mut ImGuiWindow, pos: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowSize_WindowPtr(window: *mut ImGuiWindow, size: ImVec2, cond: ImGuiCond);
}
extern "C" {
    pub fn igSetWindowCollapsed_WindowPtr(
        window: *mut ImGuiWindow,
        collapsed: bool,
        cond: ImGuiCond,
    );
}
extern "C" {
    pub fn igSetWindowHitTestHole(window: *mut ImGuiWindow, pos: ImVec2, size: ImVec2);
}
extern "C" {
    pub fn igWindowRectAbsToRel(pOut: *mut ImRect, window: *mut ImGuiWindow, r: ImRect);
}
extern "C" {
    pub fn igWindowRectRelToAbs(pOut: *mut ImRect, window: *mut ImGuiWindow, r: ImRect);
}
extern "C" {
    pub fn igFocusWindow(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igFocusTopMostWindowUnderOne(
        under_this_window: *mut ImGuiWindow,
        ignore_window: *mut ImGuiWindow,
    );
}
extern "C" {
    pub fn igBringWindowToFocusFront(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igBringWindowToDisplayFront(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igBringWindowToDisplayBack(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igBringWindowToDisplayBehind(window: *mut ImGuiWindow, above_window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igFindWindowDisplayIndex(window: *mut ImGuiWindow) -> cty::c_int;
}
extern "C" {
    pub fn igFindBottomMostVisibleWindowWithinBeginStack(
        window: *mut ImGuiWindow,
    ) -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igSetCurrentFont(font: *mut ImFont);
}
extern "C" {
    pub fn igGetDefaultFont() -> *mut ImFont;
}
extern "C" {
    pub fn igGetForegroundDrawList_WindowPtr(window: *mut ImGuiWindow) -> *mut ImDrawList;
}
extern "C" {
    pub fn igInitialize();
}
extern "C" {
    pub fn igShutdown();
}
extern "C" {
    pub fn igUpdateInputEvents(trickle_fast_inputs: bool);
}
extern "C" {
    pub fn igUpdateHoveredWindowAndCaptureFlags();
}
extern "C" {
    pub fn igStartMouseMovingWindow(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igStartMouseMovingWindowOrNode(
        window: *mut ImGuiWindow,
        node: *mut ImGuiDockNode,
        undock_floating_node: bool,
    );
}
extern "C" {
    pub fn igUpdateMouseMovingWindowNewFrame();
}
extern "C" {
    pub fn igUpdateMouseMovingWindowEndFrame();
}
extern "C" {
    pub fn igAddContextHook(context: *mut ImGuiContext, hook: *const ImGuiContextHook) -> ImGuiID;
}
extern "C" {
    pub fn igRemoveContextHook(context: *mut ImGuiContext, hook_to_remove: ImGuiID);
}
extern "C" {
    pub fn igCallContextHooks(context: *mut ImGuiContext, type_: ImGuiContextHookType);
}
extern "C" {
    pub fn igTranslateWindowsInViewport(
        viewport: *mut ImGuiViewportP,
        old_pos: ImVec2,
        new_pos: ImVec2,
    );
}
extern "C" {
    pub fn igScaleWindowsInViewport(viewport: *mut ImGuiViewportP, scale: f32);
}
extern "C" {
    pub fn igDestroyPlatformWindow(viewport: *mut ImGuiViewportP);
}
extern "C" {
    pub fn igSetWindowViewport(window: *mut ImGuiWindow, viewport: *mut ImGuiViewportP);
}
extern "C" {
    pub fn igSetCurrentViewport(window: *mut ImGuiWindow, viewport: *mut ImGuiViewportP);
}
extern "C" {
    pub fn igGetViewportPlatformMonitor(
        viewport: *mut ImGuiViewport,
    ) -> *const ImGuiPlatformMonitor;
}
extern "C" {
    pub fn igFindHoveredViewportFromPlatformWindowStack(
        mouse_platform_pos: ImVec2,
    ) -> *mut ImGuiViewportP;
}
extern "C" {
    pub fn igMarkIniSettingsDirty_Nil();
}
extern "C" {
    pub fn igMarkIniSettingsDirty_WindowPtr(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igClearIniSettings();
}
extern "C" {
    pub fn igCreateNewWindowSettings(name: *const cty::c_char) -> *mut ImGuiWindowSettings;
}
extern "C" {
    pub fn igFindWindowSettings(id: ImGuiID) -> *mut ImGuiWindowSettings;
}
extern "C" {
    pub fn igFindOrCreateWindowSettings(name: *const cty::c_char) -> *mut ImGuiWindowSettings;
}
extern "C" {
    pub fn igAddSettingsHandler(handler: *const ImGuiSettingsHandler);
}
extern "C" {
    pub fn igRemoveSettingsHandler(type_name: *const cty::c_char);
}
extern "C" {
    pub fn igFindSettingsHandler(type_name: *const cty::c_char) -> *mut ImGuiSettingsHandler;
}
extern "C" {
    pub fn igLocalizeRegisterEntries(entries: *const ImGuiLocEntry, count: cty::c_int);
}
extern "C" {
    pub fn igLocalizeGetMsg(key: ImGuiLocKey) -> *const cty::c_char;
}
extern "C" {
    pub fn igSetScrollX_WindowPtr(window: *mut ImGuiWindow, scroll_x: f32);
}
extern "C" {
    pub fn igSetScrollY_WindowPtr(window: *mut ImGuiWindow, scroll_y: f32);
}
extern "C" {
    pub fn igSetScrollFromPosX_WindowPtr(
        window: *mut ImGuiWindow,
        local_x: f32,
        center_x_ratio: f32,
    );
}
extern "C" {
    pub fn igSetScrollFromPosY_WindowPtr(
        window: *mut ImGuiWindow,
        local_y: f32,
        center_y_ratio: f32,
    );
}
extern "C" {
    pub fn igScrollToItem(flags: ImGuiScrollFlags);
}
extern "C" {
    pub fn igScrollToRect(window: *mut ImGuiWindow, rect: ImRect, flags: ImGuiScrollFlags);
}
extern "C" {
    pub fn igScrollToRectEx(
        pOut: *mut ImVec2,
        window: *mut ImGuiWindow,
        rect: ImRect,
        flags: ImGuiScrollFlags,
    );
}
extern "C" {
    pub fn igScrollToBringRectIntoView(window: *mut ImGuiWindow, rect: ImRect);
}
extern "C" {
    pub fn igGetItemStatusFlags() -> ImGuiItemStatusFlags;
}
extern "C" {
    pub fn igGetItemFlags() -> ImGuiItemFlags;
}
extern "C" {
    pub fn igGetActiveID() -> ImGuiID;
}
extern "C" {
    pub fn igGetFocusID() -> ImGuiID;
}
extern "C" {
    pub fn igSetActiveID(id: ImGuiID, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igSetFocusID(id: ImGuiID, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igClearActiveID();
}
extern "C" {
    pub fn igGetHoveredID() -> ImGuiID;
}
extern "C" {
    pub fn igSetHoveredID(id: ImGuiID);
}
extern "C" {
    pub fn igKeepAliveID(id: ImGuiID);
}
extern "C" {
    pub fn igMarkItemEdited(id: ImGuiID);
}
extern "C" {
    pub fn igPushOverrideID(id: ImGuiID);
}
extern "C" {
    pub fn igGetIDWithSeed(
        str_id_begin: *const cty::c_char,
        str_id_end: *const cty::c_char,
        seed: ImGuiID,
    ) -> ImGuiID;
}
extern "C" {
    pub fn igItemSize_Vec2(size: ImVec2, text_baseline_y: f32);
}
extern "C" {
    pub fn igItemSize_Rect(bb: ImRect, text_baseline_y: f32);
}
extern "C" {
    pub fn igItemAdd(
        bb: ImRect,
        id: ImGuiID,
        nav_bb: *const ImRect,
        extra_flags: ImGuiItemFlags,
    ) -> bool;
}
extern "C" {
    pub fn igItemHoverable(bb: ImRect, id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igIsClippedEx(bb: ImRect, id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igSetLastItemData(
        item_id: ImGuiID,
        in_flags: ImGuiItemFlags,
        status_flags: ImGuiItemStatusFlags,
        item_rect: ImRect,
    );
}
extern "C" {
    pub fn igCalcItemSize(pOut: *mut ImVec2, size: ImVec2, default_w: f32, default_h: f32);
}
extern "C" {
    pub fn igCalcWrapWidthForPos(pos: ImVec2, wrap_pos_x: f32) -> f32;
}
extern "C" {
    pub fn igPushMultiItemsWidths(components: cty::c_int, width_full: f32);
}
extern "C" {
    pub fn igIsItemToggledSelection() -> bool;
}
extern "C" {
    pub fn igGetContentRegionMaxAbs(pOut: *mut ImVec2);
}
extern "C" {
    pub fn igShrinkWidths(items: *mut ImGuiShrinkWidthItem, count: cty::c_int, width_excess: f32);
}
extern "C" {
    pub fn igPushItemFlag(option: ImGuiItemFlags, enabled: bool);
}
extern "C" {
    pub fn igPopItemFlag();
}
extern "C" {
    pub fn igLogBegin(type_: ImGuiLogType, auto_open_depth: cty::c_int);
}
extern "C" {
    pub fn igLogToBuffer(auto_open_depth: cty::c_int);
}
extern "C" {
    pub fn igLogRenderedText(
        ref_pos: *const ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    );
}
extern "C" {
    pub fn igLogSetNextTextDecoration(prefix: *const cty::c_char, suffix: *const cty::c_char);
}
extern "C" {
    pub fn igBeginChildEx(
        name: *const cty::c_char,
        id: ImGuiID,
        size_arg: ImVec2,
        border: bool,
        flags: ImGuiWindowFlags,
    ) -> bool;
}
extern "C" {
    pub fn igOpenPopupEx(id: ImGuiID, popup_flags: ImGuiPopupFlags);
}
extern "C" {
    pub fn igClosePopupToLevel(remaining: cty::c_int, restore_focus_to_window_under_popup: bool);
}
extern "C" {
    pub fn igClosePopupsOverWindow(
        ref_window: *mut ImGuiWindow,
        restore_focus_to_window_under_popup: bool,
    );
}
extern "C" {
    pub fn igClosePopupsExceptModals();
}
extern "C" {
    pub fn igIsPopupOpen_ID(id: ImGuiID, popup_flags: ImGuiPopupFlags) -> bool;
}
extern "C" {
    pub fn igBeginPopupEx(id: ImGuiID, extra_flags: ImGuiWindowFlags) -> bool;
}
extern "C" {
    pub fn igBeginTooltipEx(tooltip_flags: ImGuiTooltipFlags, extra_window_flags: ImGuiWindowFlags);
}
extern "C" {
    pub fn igGetPopupAllowedExtentRect(pOut: *mut ImRect, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igGetTopMostPopupModal() -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igGetTopMostAndVisiblePopupModal() -> *mut ImGuiWindow;
}
extern "C" {
    pub fn igFindBestWindowPosForPopup(pOut: *mut ImVec2, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igFindBestWindowPosForPopupEx(
        pOut: *mut ImVec2,
        ref_pos: ImVec2,
        size: ImVec2,
        last_dir: *mut ImGuiDir,
        r_outer: ImRect,
        r_avoid: ImRect,
        policy: ImGuiPopupPositionPolicy,
    );
}
extern "C" {
    pub fn igBeginViewportSideBar(
        name: *const cty::c_char,
        viewport: *mut ImGuiViewport,
        dir: ImGuiDir,
        size: f32,
        window_flags: ImGuiWindowFlags,
    ) -> bool;
}
extern "C" {
    pub fn igBeginMenuEx(
        label: *const cty::c_char,
        icon: *const cty::c_char,
        enabled: bool,
    ) -> bool;
}
extern "C" {
    pub fn igMenuItemEx(
        label: *const cty::c_char,
        icon: *const cty::c_char,
        shortcut: *const cty::c_char,
        selected: bool,
        enabled: bool,
    ) -> bool;
}
extern "C" {
    pub fn igBeginComboPopup(popup_id: ImGuiID, bb: ImRect, flags: ImGuiComboFlags) -> bool;
}
extern "C" {
    pub fn igBeginComboPreview() -> bool;
}
extern "C" {
    pub fn igEndComboPreview();
}
extern "C" {
    pub fn igNavInitWindow(window: *mut ImGuiWindow, force_reinit: bool);
}
extern "C" {
    pub fn igNavInitRequestApplyResult();
}
extern "C" {
    pub fn igNavMoveRequestButNoResultYet() -> bool;
}
extern "C" {
    pub fn igNavMoveRequestSubmit(
        move_dir: ImGuiDir,
        clip_dir: ImGuiDir,
        move_flags: ImGuiNavMoveFlags,
        scroll_flags: ImGuiScrollFlags,
    );
}
extern "C" {
    pub fn igNavMoveRequestForward(
        move_dir: ImGuiDir,
        clip_dir: ImGuiDir,
        move_flags: ImGuiNavMoveFlags,
        scroll_flags: ImGuiScrollFlags,
    );
}
extern "C" {
    pub fn igNavMoveRequestResolveWithLastItem(result: *mut ImGuiNavItemData);
}
extern "C" {
    pub fn igNavMoveRequestCancel();
}
extern "C" {
    pub fn igNavMoveRequestApplyResult();
}
extern "C" {
    pub fn igNavMoveRequestTryWrapping(window: *mut ImGuiWindow, move_flags: ImGuiNavMoveFlags);
}
extern "C" {
    pub fn igActivateItem(id: ImGuiID);
}
extern "C" {
    pub fn igSetNavWindow(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igSetNavID(
        id: ImGuiID,
        nav_layer: ImGuiNavLayer,
        focus_scope_id: ImGuiID,
        rect_rel: ImRect,
    );
}
extern "C" {
    pub fn igIsNamedKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsNamedKeyOrModKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsLegacyKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsKeyboardKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsGamepadKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsMouseKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igIsAliasKey(key: ImGuiKey) -> bool;
}
extern "C" {
    pub fn igConvertShortcutMod(key_chord: ImGuiKeyChord) -> ImGuiKeyChord;
}
extern "C" {
    pub fn igConvertSingleModFlagToKey(key: ImGuiKey) -> ImGuiKey;
}
extern "C" {
    pub fn igGetKeyData(key: ImGuiKey) -> *mut ImGuiKeyData;
}
extern "C" {
    pub fn igGetKeyChordName(
        key_chord: ImGuiKeyChord,
        out_buf: *mut cty::c_char,
        out_buf_size: cty::c_int,
    );
}
extern "C" {
    pub fn igMouseButtonToKey(button: ImGuiMouseButton) -> ImGuiKey;
}
extern "C" {
    pub fn igIsMouseDragPastThreshold(button: ImGuiMouseButton, lock_threshold: f32) -> bool;
}
extern "C" {
    pub fn igGetKeyMagnitude2d(
        pOut: *mut ImVec2,
        key_left: ImGuiKey,
        key_right: ImGuiKey,
        key_up: ImGuiKey,
        key_down: ImGuiKey,
    );
}
extern "C" {
    pub fn igGetNavTweakPressedAmount(axis: ImGuiAxis) -> f32;
}
extern "C" {
    pub fn igCalcTypematicRepeatAmount(
        t0: f32,
        t1: f32,
        repeat_delay: f32,
        repeat_rate: f32,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igGetTypematicRepeatRate(
        flags: ImGuiInputFlags,
        repeat_delay: *mut f32,
        repeat_rate: *mut f32,
    );
}
extern "C" {
    pub fn igSetActiveIdUsingAllKeyboardKeys();
}
extern "C" {
    pub fn igIsActiveIdUsingNavDir(dir: ImGuiDir) -> bool;
}
extern "C" {
    pub fn igGetKeyOwner(key: ImGuiKey) -> ImGuiID;
}
extern "C" {
    pub fn igSetKeyOwner(key: ImGuiKey, owner_id: ImGuiID, flags: ImGuiInputFlags);
}
extern "C" {
    pub fn igSetItemKeyOwner(key: ImGuiKey, flags: ImGuiInputFlags);
}
extern "C" {
    pub fn igTestKeyOwner(key: ImGuiKey, owner_id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igGetKeyOwnerData(key: ImGuiKey) -> *mut ImGuiKeyOwnerData;
}
extern "C" {
    pub fn igIsKeyDown_ID(key: ImGuiKey, owner_id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igIsKeyPressed_ID(key: ImGuiKey, owner_id: ImGuiID, flags: ImGuiInputFlags) -> bool;
}
extern "C" {
    pub fn igIsKeyReleased_ID(key: ImGuiKey, owner_id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igIsMouseDown_ID(button: ImGuiMouseButton, owner_id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igIsMouseClicked_ID(
        button: ImGuiMouseButton,
        owner_id: ImGuiID,
        flags: ImGuiInputFlags,
    ) -> bool;
}
extern "C" {
    pub fn igIsMouseReleased_ID(button: ImGuiMouseButton, owner_id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igShortcut(key_chord: ImGuiKeyChord, owner_id: ImGuiID, flags: ImGuiInputFlags) -> bool;
}
extern "C" {
    pub fn igSetShortcutRouting(
        key_chord: ImGuiKeyChord,
        owner_id: ImGuiID,
        flags: ImGuiInputFlags,
    ) -> bool;
}
extern "C" {
    pub fn igTestShortcutRouting(key_chord: ImGuiKeyChord, owner_id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igGetShortcutRoutingData(key_chord: ImGuiKeyChord) -> *mut ImGuiKeyRoutingData;
}
extern "C" {
    pub fn igDockContextInitialize(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igDockContextShutdown(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igDockContextClearNodes(
        ctx: *mut ImGuiContext,
        root_id: ImGuiID,
        clear_settings_refs: bool,
    );
}
extern "C" {
    pub fn igDockContextRebuildNodes(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igDockContextNewFrameUpdateUndocking(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igDockContextNewFrameUpdateDocking(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igDockContextEndFrame(ctx: *mut ImGuiContext);
}
extern "C" {
    pub fn igDockContextGenNodeID(ctx: *mut ImGuiContext) -> ImGuiID;
}
extern "C" {
    pub fn igDockContextQueueDock(
        ctx: *mut ImGuiContext,
        target: *mut ImGuiWindow,
        target_node: *mut ImGuiDockNode,
        payload: *mut ImGuiWindow,
        split_dir: ImGuiDir,
        split_ratio: f32,
        split_outer: bool,
    );
}
extern "C" {
    pub fn igDockContextQueueUndockWindow(ctx: *mut ImGuiContext, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igDockContextQueueUndockNode(ctx: *mut ImGuiContext, node: *mut ImGuiDockNode);
}
extern "C" {
    pub fn igDockContextCalcDropPosForDocking(
        target: *mut ImGuiWindow,
        target_node: *mut ImGuiDockNode,
        payload_window: *mut ImGuiWindow,
        payload_node: *mut ImGuiDockNode,
        split_dir: ImGuiDir,
        split_outer: bool,
        out_pos: *mut ImVec2,
    ) -> bool;
}
extern "C" {
    pub fn igDockContextFindNodeByID(ctx: *mut ImGuiContext, id: ImGuiID) -> *mut ImGuiDockNode;
}
extern "C" {
    pub fn igDockNodeBeginAmendTabBar(node: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn igDockNodeEndAmendTabBar();
}
extern "C" {
    pub fn igDockNodeGetRootNode(node: *mut ImGuiDockNode) -> *mut ImGuiDockNode;
}
extern "C" {
    pub fn igDockNodeIsInHierarchyOf(node: *mut ImGuiDockNode, parent: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn igDockNodeGetDepth(node: *const ImGuiDockNode) -> cty::c_int;
}
extern "C" {
    pub fn igDockNodeGetWindowMenuButtonId(node: *const ImGuiDockNode) -> ImGuiID;
}
extern "C" {
    pub fn igGetWindowDockNode() -> *mut ImGuiDockNode;
}
extern "C" {
    pub fn igGetWindowAlwaysWantOwnTabBar(window: *mut ImGuiWindow) -> bool;
}
extern "C" {
    pub fn igBeginDocked(window: *mut ImGuiWindow, p_open: *mut bool);
}
extern "C" {
    pub fn igBeginDockableDragDropSource(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igBeginDockableDragDropTarget(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igSetWindowDock(window: *mut ImGuiWindow, dock_id: ImGuiID, cond: ImGuiCond);
}
extern "C" {
    pub fn igDockBuilderDockWindow(window_name: *const cty::c_char, node_id: ImGuiID);
}
extern "C" {
    pub fn igDockBuilderGetNode(node_id: ImGuiID) -> *mut ImGuiDockNode;
}
extern "C" {
    pub fn igDockBuilderGetCentralNode(node_id: ImGuiID) -> *mut ImGuiDockNode;
}
extern "C" {
    pub fn igDockBuilderAddNode(node_id: ImGuiID, flags: ImGuiDockNodeFlags) -> ImGuiID;
}
extern "C" {
    pub fn igDockBuilderRemoveNode(node_id: ImGuiID);
}
extern "C" {
    pub fn igDockBuilderRemoveNodeDockedWindows(node_id: ImGuiID, clear_settings_refs: bool);
}
extern "C" {
    pub fn igDockBuilderRemoveNodeChildNodes(node_id: ImGuiID);
}
extern "C" {
    pub fn igDockBuilderSetNodePos(node_id: ImGuiID, pos: ImVec2);
}
extern "C" {
    pub fn igDockBuilderSetNodeSize(node_id: ImGuiID, size: ImVec2);
}
extern "C" {
    pub fn igDockBuilderSplitNode(
        node_id: ImGuiID,
        split_dir: ImGuiDir,
        size_ratio_for_node_at_dir: f32,
        out_id_at_dir: *mut ImGuiID,
        out_id_at_opposite_dir: *mut ImGuiID,
    ) -> ImGuiID;
}
extern "C" {
    pub fn igDockBuilderCopyDockSpace(
        src_dockspace_id: ImGuiID,
        dst_dockspace_id: ImGuiID,
        in_window_remap_pairs: *mut ImVector_const_charPtr,
    );
}
extern "C" {
    pub fn igDockBuilderCopyNode(
        src_node_id: ImGuiID,
        dst_node_id: ImGuiID,
        out_node_remap_pairs: *mut ImVector_ImGuiID,
    );
}
extern "C" {
    pub fn igDockBuilderCopyWindowSettings(
        src_name: *const cty::c_char,
        dst_name: *const cty::c_char,
    );
}
extern "C" {
    pub fn igDockBuilderFinish(node_id: ImGuiID);
}
extern "C" {
    pub fn igPushFocusScope(id: ImGuiID);
}
extern "C" {
    pub fn igPopFocusScope();
}
extern "C" {
    pub fn igGetCurrentFocusScope() -> ImGuiID;
}
extern "C" {
    pub fn igIsDragDropActive() -> bool;
}
extern "C" {
    pub fn igBeginDragDropTargetCustom(bb: ImRect, id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igClearDragDrop();
}
extern "C" {
    pub fn igIsDragDropPayloadBeingAccepted() -> bool;
}
extern "C" {
    pub fn igRenderDragDropTargetRect(bb: ImRect);
}
extern "C" {
    pub fn igSetWindowClipRectBeforeSetChannel(window: *mut ImGuiWindow, clip_rect: ImRect);
}
extern "C" {
    pub fn igBeginColumns(
        str_id: *const cty::c_char,
        count: cty::c_int,
        flags: ImGuiOldColumnFlags,
    );
}
extern "C" {
    pub fn igEndColumns();
}
extern "C" {
    pub fn igPushColumnClipRect(column_index: cty::c_int);
}
extern "C" {
    pub fn igPushColumnsBackground();
}
extern "C" {
    pub fn igPopColumnsBackground();
}
extern "C" {
    pub fn igGetColumnsID(str_id: *const cty::c_char, count: cty::c_int) -> ImGuiID;
}
extern "C" {
    pub fn igFindOrCreateColumns(window: *mut ImGuiWindow, id: ImGuiID) -> *mut ImGuiOldColumns;
}
extern "C" {
    pub fn igGetColumnOffsetFromNorm(columns: *const ImGuiOldColumns, offset_norm: f32) -> f32;
}
extern "C" {
    pub fn igGetColumnNormFromOffset(columns: *const ImGuiOldColumns, offset: f32) -> f32;
}
extern "C" {
    pub fn igTableOpenContextMenu(column_n: cty::c_int);
}
extern "C" {
    pub fn igTableSetColumnWidth(column_n: cty::c_int, width: f32);
}
extern "C" {
    pub fn igTableSetColumnSortDirection(
        column_n: cty::c_int,
        sort_direction: ImGuiSortDirection,
        append_to_sort_specs: bool,
    );
}
extern "C" {
    pub fn igTableGetHoveredColumn() -> cty::c_int;
}
extern "C" {
    pub fn igTableGetHeaderRowHeight() -> f32;
}
extern "C" {
    pub fn igTablePushBackgroundChannel();
}
extern "C" {
    pub fn igTablePopBackgroundChannel();
}
extern "C" {
    pub fn igGetCurrentTable() -> *mut ImGuiTable;
}
extern "C" {
    pub fn igTableFindByID(id: ImGuiID) -> *mut ImGuiTable;
}
extern "C" {
    pub fn igBeginTableEx(
        name: *const cty::c_char,
        id: ImGuiID,
        columns_count: cty::c_int,
        flags: ImGuiTableFlags,
        outer_size: ImVec2,
        inner_width: f32,
    ) -> bool;
}
extern "C" {
    pub fn igTableBeginInitMemory(table: *mut ImGuiTable, columns_count: cty::c_int);
}
extern "C" {
    pub fn igTableBeginApplyRequests(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableSetupDrawChannels(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableUpdateLayout(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableUpdateBorders(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableUpdateColumnsWeightFromWidth(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableDrawBorders(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableDrawContextMenu(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableBeginContextMenuPopup(table: *mut ImGuiTable) -> bool;
}
extern "C" {
    pub fn igTableMergeDrawChannels(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableGetInstanceData(
        table: *mut ImGuiTable,
        instance_no: cty::c_int,
    ) -> *mut ImGuiTableInstanceData;
}
extern "C" {
    pub fn igTableSortSpecsSanitize(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableSortSpecsBuild(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableGetColumnNextSortDirection(column: *mut ImGuiTableColumn) -> ImGuiSortDirection;
}
extern "C" {
    pub fn igTableFixColumnSortDirection(table: *mut ImGuiTable, column: *mut ImGuiTableColumn);
}
extern "C" {
    pub fn igTableGetColumnWidthAuto(table: *mut ImGuiTable, column: *mut ImGuiTableColumn) -> f32;
}
extern "C" {
    pub fn igTableBeginRow(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableEndRow(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableBeginCell(table: *mut ImGuiTable, column_n: cty::c_int);
}
extern "C" {
    pub fn igTableEndCell(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableGetCellBgRect(pOut: *mut ImRect, table: *const ImGuiTable, column_n: cty::c_int);
}
extern "C" {
    pub fn igTableGetColumnName_TablePtr(
        table: *const ImGuiTable,
        column_n: cty::c_int,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igTableGetColumnResizeID(
        table: *const ImGuiTable,
        column_n: cty::c_int,
        instance_no: cty::c_int,
    ) -> ImGuiID;
}
extern "C" {
    pub fn igTableGetMaxColumnWidth(table: *const ImGuiTable, column_n: cty::c_int) -> f32;
}
extern "C" {
    pub fn igTableSetColumnWidthAutoSingle(table: *mut ImGuiTable, column_n: cty::c_int);
}
extern "C" {
    pub fn igTableSetColumnWidthAutoAll(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableRemove(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableGcCompactTransientBuffers_TablePtr(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableGcCompactTransientBuffers_TableTempDataPtr(table: *mut ImGuiTableTempData);
}
extern "C" {
    pub fn igTableGcCompactSettings();
}
extern "C" {
    pub fn igTableLoadSettings(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableSaveSettings(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableResetSettings(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igTableGetBoundSettings(table: *mut ImGuiTable) -> *mut ImGuiTableSettings;
}
extern "C" {
    pub fn igTableSettingsAddSettingsHandler();
}
extern "C" {
    pub fn igTableSettingsCreate(id: ImGuiID, columns_count: cty::c_int)
        -> *mut ImGuiTableSettings;
}
extern "C" {
    pub fn igTableSettingsFindByID(id: ImGuiID) -> *mut ImGuiTableSettings;
}
extern "C" {
    pub fn igBeginTabBarEx(
        tab_bar: *mut ImGuiTabBar,
        bb: ImRect,
        flags: ImGuiTabBarFlags,
        dock_node: *mut ImGuiDockNode,
    ) -> bool;
}
extern "C" {
    pub fn igTabBarFindTabByID(tab_bar: *mut ImGuiTabBar, tab_id: ImGuiID) -> *mut ImGuiTabItem;
}
extern "C" {
    pub fn igTabBarFindMostRecentlySelectedTabForActiveWindow(
        tab_bar: *mut ImGuiTabBar,
    ) -> *mut ImGuiTabItem;
}
extern "C" {
    pub fn igTabBarAddTab(
        tab_bar: *mut ImGuiTabBar,
        tab_flags: ImGuiTabItemFlags,
        window: *mut ImGuiWindow,
    );
}
extern "C" {
    pub fn igTabBarRemoveTab(tab_bar: *mut ImGuiTabBar, tab_id: ImGuiID);
}
extern "C" {
    pub fn igTabBarCloseTab(tab_bar: *mut ImGuiTabBar, tab: *mut ImGuiTabItem);
}
extern "C" {
    pub fn igTabBarQueueReorder(
        tab_bar: *mut ImGuiTabBar,
        tab: *const ImGuiTabItem,
        offset: cty::c_int,
    );
}
extern "C" {
    pub fn igTabBarQueueReorderFromMousePos(
        tab_bar: *mut ImGuiTabBar,
        tab: *const ImGuiTabItem,
        mouse_pos: ImVec2,
    );
}
extern "C" {
    pub fn igTabBarProcessReorder(tab_bar: *mut ImGuiTabBar) -> bool;
}
extern "C" {
    pub fn igTabItemEx(
        tab_bar: *mut ImGuiTabBar,
        label: *const cty::c_char,
        p_open: *mut bool,
        flags: ImGuiTabItemFlags,
        docked_window: *mut ImGuiWindow,
    ) -> bool;
}
extern "C" {
    pub fn igTabItemCalcSize_Str(
        pOut: *mut ImVec2,
        label: *const cty::c_char,
        has_close_button_or_unsaved_marker: bool,
    );
}
extern "C" {
    pub fn igTabItemCalcSize_WindowPtr(pOut: *mut ImVec2, window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igTabItemBackground(
        draw_list: *mut ImDrawList,
        bb: ImRect,
        flags: ImGuiTabItemFlags,
        col: ImU32,
    );
}
extern "C" {
    pub fn igTabItemLabelAndCloseButton(
        draw_list: *mut ImDrawList,
        bb: ImRect,
        flags: ImGuiTabItemFlags,
        frame_padding: ImVec2,
        label: *const cty::c_char,
        tab_id: ImGuiID,
        close_button_id: ImGuiID,
        is_contents_visible: bool,
        out_just_closed: *mut bool,
        out_text_clipped: *mut bool,
    );
}
extern "C" {
    pub fn igRenderText(
        pos: ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        hide_text_after_hash: bool,
    );
}
extern "C" {
    pub fn igRenderTextWrapped(
        pos: ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        wrap_width: f32,
    );
}
extern "C" {
    pub fn igRenderTextClipped(
        pos_min: ImVec2,
        pos_max: ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        text_size_if_known: *const ImVec2,
        align: ImVec2,
        clip_rect: *const ImRect,
    );
}
extern "C" {
    pub fn igRenderTextClippedEx(
        draw_list: *mut ImDrawList,
        pos_min: ImVec2,
        pos_max: ImVec2,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        text_size_if_known: *const ImVec2,
        align: ImVec2,
        clip_rect: *const ImRect,
    );
}
extern "C" {
    pub fn igRenderTextEllipsis(
        draw_list: *mut ImDrawList,
        pos_min: ImVec2,
        pos_max: ImVec2,
        clip_max_x: f32,
        ellipsis_max_x: f32,
        text: *const cty::c_char,
        text_end: *const cty::c_char,
        text_size_if_known: *const ImVec2,
    );
}
extern "C" {
    pub fn igRenderFrame(
        p_min: ImVec2,
        p_max: ImVec2,
        fill_col: ImU32,
        border: bool,
        rounding: f32,
    );
}
extern "C" {
    pub fn igRenderFrameBorder(p_min: ImVec2, p_max: ImVec2, rounding: f32);
}
extern "C" {
    pub fn igRenderColorRectWithAlphaCheckerboard(
        draw_list: *mut ImDrawList,
        p_min: ImVec2,
        p_max: ImVec2,
        fill_col: ImU32,
        grid_step: f32,
        grid_off: ImVec2,
        rounding: f32,
        flags: ImDrawFlags,
    );
}
extern "C" {
    pub fn igRenderNavHighlight(bb: ImRect, id: ImGuiID, flags: ImGuiNavHighlightFlags);
}
extern "C" {
    pub fn igFindRenderedTextEnd(
        text: *const cty::c_char,
        text_end: *const cty::c_char,
    ) -> *const cty::c_char;
}
extern "C" {
    pub fn igRenderMouseCursor(
        pos: ImVec2,
        scale: f32,
        mouse_cursor: ImGuiMouseCursor,
        col_fill: ImU32,
        col_border: ImU32,
        col_shadow: ImU32,
    );
}
extern "C" {
    pub fn igRenderArrow(
        draw_list: *mut ImDrawList,
        pos: ImVec2,
        col: ImU32,
        dir: ImGuiDir,
        scale: f32,
    );
}
extern "C" {
    pub fn igRenderBullet(draw_list: *mut ImDrawList, pos: ImVec2, col: ImU32);
}
extern "C" {
    pub fn igRenderCheckMark(draw_list: *mut ImDrawList, pos: ImVec2, col: ImU32, sz: f32);
}
extern "C" {
    pub fn igRenderArrowPointingAt(
        draw_list: *mut ImDrawList,
        pos: ImVec2,
        half_sz: ImVec2,
        direction: ImGuiDir,
        col: ImU32,
    );
}
extern "C" {
    pub fn igRenderArrowDockMenu(draw_list: *mut ImDrawList, p_min: ImVec2, sz: f32, col: ImU32);
}
extern "C" {
    pub fn igRenderRectFilledRangeH(
        draw_list: *mut ImDrawList,
        rect: ImRect,
        col: ImU32,
        x_start_norm: f32,
        x_end_norm: f32,
        rounding: f32,
    );
}
extern "C" {
    pub fn igRenderRectFilledWithHole(
        draw_list: *mut ImDrawList,
        outer: ImRect,
        inner: ImRect,
        col: ImU32,
        rounding: f32,
    );
}
extern "C" {
    pub fn igCalcRoundingFlagsForRectInRect(
        r_in: ImRect,
        r_outer: ImRect,
        threshold: f32,
    ) -> ImDrawFlags;
}
extern "C" {
    pub fn igTextEx(text: *const cty::c_char, text_end: *const cty::c_char, flags: ImGuiTextFlags);
}
extern "C" {
    pub fn igButtonEx(label: *const cty::c_char, size_arg: ImVec2, flags: ImGuiButtonFlags)
        -> bool;
}
extern "C" {
    pub fn igArrowButtonEx(
        str_id: *const cty::c_char,
        dir: ImGuiDir,
        size_arg: ImVec2,
        flags: ImGuiButtonFlags,
    ) -> bool;
}
extern "C" {
    pub fn igImageButtonEx(
        id: ImGuiID,
        texture_id: ImTextureID,
        size: ImVec2,
        uv0: ImVec2,
        uv1: ImVec2,
        bg_col: ImVec4,
        tint_col: ImVec4,
    ) -> bool;
}
extern "C" {
    pub fn igSeparatorEx(flags: ImGuiSeparatorFlags);
}
extern "C" {
    pub fn igCheckboxFlags_S64Ptr(
        label: *const cty::c_char,
        flags: *mut ImS64,
        flags_value: ImS64,
    ) -> bool;
}
extern "C" {
    pub fn igCheckboxFlags_U64Ptr(
        label: *const cty::c_char,
        flags: *mut ImU64,
        flags_value: ImU64,
    ) -> bool;
}
extern "C" {
    pub fn igCloseButton(id: ImGuiID, pos: ImVec2) -> bool;
}
extern "C" {
    pub fn igCollapseButton(id: ImGuiID, pos: ImVec2, dock_node: *mut ImGuiDockNode) -> bool;
}
extern "C" {
    pub fn igScrollbar(axis: ImGuiAxis);
}
extern "C" {
    pub fn igScrollbarEx(
        bb: ImRect,
        id: ImGuiID,
        axis: ImGuiAxis,
        p_scroll_v: *mut ImS64,
        avail_v: ImS64,
        contents_v: ImS64,
        flags: ImDrawFlags,
    ) -> bool;
}
extern "C" {
    pub fn igGetWindowScrollbarRect(pOut: *mut ImRect, window: *mut ImGuiWindow, axis: ImGuiAxis);
}
extern "C" {
    pub fn igGetWindowScrollbarID(window: *mut ImGuiWindow, axis: ImGuiAxis) -> ImGuiID;
}
extern "C" {
    pub fn igGetWindowResizeCornerID(window: *mut ImGuiWindow, n: cty::c_int) -> ImGuiID;
}
extern "C" {
    pub fn igGetWindowResizeBorderID(window: *mut ImGuiWindow, dir: ImGuiDir) -> ImGuiID;
}
extern "C" {
    pub fn igButtonBehavior(
        bb: ImRect,
        id: ImGuiID,
        out_hovered: *mut bool,
        out_held: *mut bool,
        flags: ImGuiButtonFlags,
    ) -> bool;
}
extern "C" {
    pub fn igDragBehavior(
        id: ImGuiID,
        data_type: ImGuiDataType,
        p_v: *mut cty::c_void,
        v_speed: f32,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
    ) -> bool;
}
extern "C" {
    pub fn igSliderBehavior(
        bb: ImRect,
        id: ImGuiID,
        data_type: ImGuiDataType,
        p_v: *mut cty::c_void,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
        format: *const cty::c_char,
        flags: ImGuiSliderFlags,
        out_grab_bb: *mut ImRect,
    ) -> bool;
}
extern "C" {
    pub fn igSplitterBehavior(
        bb: ImRect,
        id: ImGuiID,
        axis: ImGuiAxis,
        size1: *mut f32,
        size2: *mut f32,
        min_size1: f32,
        min_size2: f32,
        hover_extend: f32,
        hover_visibility_delay: f32,
        bg_col: ImU32,
    ) -> bool;
}
extern "C" {
    pub fn igTreeNodeBehavior(
        id: ImGuiID,
        flags: ImGuiTreeNodeFlags,
        label: *const cty::c_char,
        label_end: *const cty::c_char,
    ) -> bool;
}
extern "C" {
    pub fn igTreePushOverrideID(id: ImGuiID);
}
extern "C" {
    pub fn igTreeNodeSetOpen(id: ImGuiID, open: bool);
}
extern "C" {
    pub fn igTreeNodeUpdateNextOpen(id: ImGuiID, flags: ImGuiTreeNodeFlags) -> bool;
}
extern "C" {
    pub fn igDataTypeGetInfo(data_type: ImGuiDataType) -> *const ImGuiDataTypeInfo;
}
extern "C" {
    pub fn igDataTypeFormatString(
        buf: *mut cty::c_char,
        buf_size: cty::c_int,
        data_type: ImGuiDataType,
        p_data: *const cty::c_void,
        format: *const cty::c_char,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igDataTypeApplyOp(
        data_type: ImGuiDataType,
        op: cty::c_int,
        output: *mut cty::c_void,
        arg_1: *const cty::c_void,
        arg_2: *const cty::c_void,
    );
}
extern "C" {
    pub fn igDataTypeApplyFromText(
        buf: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        format: *const cty::c_char,
    ) -> bool;
}
extern "C" {
    pub fn igDataTypeCompare(
        data_type: ImGuiDataType,
        arg_1: *const cty::c_void,
        arg_2: *const cty::c_void,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igDataTypeClamp(
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        p_min: *const cty::c_void,
        p_max: *const cty::c_void,
    ) -> bool;
}
extern "C" {
    pub fn igInputTextEx(
        label: *const cty::c_char,
        hint: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: cty::c_int,
        size_arg: ImVec2,
        flags: ImGuiInputTextFlags,
        callback: ImGuiInputTextCallback,
        user_data: *mut cty::c_void,
    ) -> bool;
}
extern "C" {
    pub fn igTempInputText(
        bb: ImRect,
        id: ImGuiID,
        label: *const cty::c_char,
        buf: *mut cty::c_char,
        buf_size: cty::c_int,
        flags: ImGuiInputTextFlags,
    ) -> bool;
}
extern "C" {
    pub fn igTempInputScalar(
        bb: ImRect,
        id: ImGuiID,
        label: *const cty::c_char,
        data_type: ImGuiDataType,
        p_data: *mut cty::c_void,
        format: *const cty::c_char,
        p_clamp_min: *const cty::c_void,
        p_clamp_max: *const cty::c_void,
    ) -> bool;
}
extern "C" {
    pub fn igTempInputIsActive(id: ImGuiID) -> bool;
}
extern "C" {
    pub fn igGetInputTextState(id: ImGuiID) -> *mut ImGuiInputTextState;
}
extern "C" {
    pub fn igColorTooltip(text: *const cty::c_char, col: *const f32, flags: ImGuiColorEditFlags);
}
extern "C" {
    pub fn igColorEditOptionsPopup(col: *const f32, flags: ImGuiColorEditFlags);
}
extern "C" {
    pub fn igColorPickerOptionsPopup(ref_col: *const f32, flags: ImGuiColorEditFlags);
}
extern "C" {
    pub fn igPlotEx(
        plot_type: ImGuiPlotType,
        label: *const cty::c_char,
        values_getter: ::core::option::Option<
            unsafe extern "C" fn(data: *mut cty::c_void, idx: cty::c_int) -> f32,
        >,
        data: *mut cty::c_void,
        values_count: cty::c_int,
        values_offset: cty::c_int,
        overlay_text: *const cty::c_char,
        scale_min: f32,
        scale_max: f32,
        frame_size: ImVec2,
    ) -> cty::c_int;
}
extern "C" {
    pub fn igShadeVertsLinearColorGradientKeepAlpha(
        draw_list: *mut ImDrawList,
        vert_start_idx: cty::c_int,
        vert_end_idx: cty::c_int,
        gradient_p0: ImVec2,
        gradient_p1: ImVec2,
        col0: ImU32,
        col1: ImU32,
    );
}
extern "C" {
    pub fn igShadeVertsLinearUV(
        draw_list: *mut ImDrawList,
        vert_start_idx: cty::c_int,
        vert_end_idx: cty::c_int,
        a: ImVec2,
        b: ImVec2,
        uv_a: ImVec2,
        uv_b: ImVec2,
        clamp: bool,
    );
}
extern "C" {
    pub fn igGcCompactTransientMiscBuffers();
}
extern "C" {
    pub fn igGcCompactTransientWindowBuffers(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igGcAwakeTransientWindowBuffers(window: *mut ImGuiWindow);
}
extern "C" {
    pub fn igDebugLog(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn igErrorCheckEndFrameRecover(
        log_callback: ImGuiErrorLogCallback,
        user_data: *mut cty::c_void,
    );
}
extern "C" {
    pub fn igErrorCheckEndWindowRecover(
        log_callback: ImGuiErrorLogCallback,
        user_data: *mut cty::c_void,
    );
}
extern "C" {
    pub fn igErrorCheckUsingSetCursorPosToExtendParentBoundaries();
}
extern "C" {
    pub fn igDebugLocateItem(target_id: ImGuiID);
}
extern "C" {
    pub fn igDebugLocateItemOnHover(target_id: ImGuiID);
}
extern "C" {
    pub fn igDebugLocateItemResolveWithLastItem();
}
extern "C" {
    pub fn igDebugDrawItemRect(col: ImU32);
}
extern "C" {
    pub fn igDebugStartItemPicker();
}
extern "C" {
    pub fn igShowFontAtlas(atlas: *mut ImFontAtlas);
}
extern "C" {
    pub fn igDebugHookIdInfo(
        id: ImGuiID,
        data_type: ImGuiDataType,
        data_id: *const cty::c_void,
        data_id_end: *const cty::c_void,
    );
}
extern "C" {
    pub fn igDebugNodeColumns(columns: *mut ImGuiOldColumns);
}
extern "C" {
    pub fn igDebugNodeDockNode(node: *mut ImGuiDockNode, label: *const cty::c_char);
}
extern "C" {
    pub fn igDebugNodeDrawList(
        window: *mut ImGuiWindow,
        viewport: *mut ImGuiViewportP,
        draw_list: *const ImDrawList,
        label: *const cty::c_char,
    );
}
extern "C" {
    pub fn igDebugNodeDrawCmdShowMeshAndBoundingBox(
        out_draw_list: *mut ImDrawList,
        draw_list: *const ImDrawList,
        draw_cmd: *const ImDrawCmd,
        show_mesh: bool,
        show_aabb: bool,
    );
}
extern "C" {
    pub fn igDebugNodeFont(font: *mut ImFont);
}
extern "C" {
    pub fn igDebugNodeFontGlyph(font: *mut ImFont, glyph: *const ImFontGlyph);
}
extern "C" {
    pub fn igDebugNodeStorage(storage: *mut ImGuiStorage, label: *const cty::c_char);
}
extern "C" {
    pub fn igDebugNodeTabBar(tab_bar: *mut ImGuiTabBar, label: *const cty::c_char);
}
extern "C" {
    pub fn igDebugNodeTable(table: *mut ImGuiTable);
}
extern "C" {
    pub fn igDebugNodeTableSettings(settings: *mut ImGuiTableSettings);
}
extern "C" {
    pub fn igDebugNodeInputTextState(state: *mut ImGuiInputTextState);
}
extern "C" {
    pub fn igDebugNodeWindow(window: *mut ImGuiWindow, label: *const cty::c_char);
}
extern "C" {
    pub fn igDebugNodeWindowSettings(settings: *mut ImGuiWindowSettings);
}
extern "C" {
    pub fn igDebugNodeWindowsList(windows: *mut ImVector_ImGuiWindowPtr, label: *const cty::c_char);
}
extern "C" {
    pub fn igDebugNodeWindowsListByBeginStackParent(
        windows: *mut *mut ImGuiWindow,
        windows_size: cty::c_int,
        parent_in_begin_stack: *mut ImGuiWindow,
    );
}
extern "C" {
    pub fn igDebugNodeViewport(viewport: *mut ImGuiViewportP);
}
extern "C" {
    pub fn igDebugRenderKeyboardPreview(draw_list: *mut ImDrawList);
}
extern "C" {
    pub fn igDebugRenderViewportThumbnail(
        draw_list: *mut ImDrawList,
        viewport: *mut ImGuiViewportP,
        bb: ImRect,
    );
}
extern "C" {
    pub fn igIsKeyPressedMap(key: ImGuiKey, repeat: bool) -> bool;
}
extern "C" {
    pub fn igImFontAtlasGetBuilderForStbTruetype() -> *const ImFontBuilderIO;
}
extern "C" {
    pub fn igImFontAtlasBuildInit(atlas: *mut ImFontAtlas);
}
extern "C" {
    pub fn igImFontAtlasBuildSetupFont(
        atlas: *mut ImFontAtlas,
        font: *mut ImFont,
        font_config: *mut ImFontConfig,
        ascent: f32,
        descent: f32,
    );
}
extern "C" {
    pub fn igImFontAtlasBuildPackCustomRects(
        atlas: *mut ImFontAtlas,
        stbrp_context_opaque: *mut cty::c_void,
    );
}
extern "C" {
    pub fn igImFontAtlasBuildFinish(atlas: *mut ImFontAtlas);
}
extern "C" {
    pub fn igImFontAtlasBuildRender8bppRectFromString(
        atlas: *mut ImFontAtlas,
        x: cty::c_int,
        y: cty::c_int,
        w: cty::c_int,
        h: cty::c_int,
        in_str: *const cty::c_char,
        in_marker_char: cty::c_char,
        in_marker_pixel_value: cty::c_uchar,
    );
}
extern "C" {
    pub fn igImFontAtlasBuildRender32bppRectFromString(
        atlas: *mut ImFontAtlas,
        x: cty::c_int,
        y: cty::c_int,
        w: cty::c_int,
        h: cty::c_int,
        in_str: *const cty::c_char,
        in_marker_char: cty::c_char,
        in_marker_pixel_value: cty::c_uint,
    );
}
extern "C" {
    pub fn igImFontAtlasBuildMultiplyCalcLookupTable(
        out_table: *mut cty::c_uchar,
        in_multiply_factor: f32,
    );
}
extern "C" {
    pub fn igImFontAtlasBuildMultiplyRectAlpha8(
        table: *const cty::c_uchar,
        pixels: *mut cty::c_uchar,
        x: cty::c_int,
        y: cty::c_int,
        w: cty::c_int,
        h: cty::c_int,
        stride: cty::c_int,
    );
}
extern "C" {
    pub fn igLogText(fmt: *const cty::c_char, ...);
}
extern "C" {
    pub fn ImGuiTextBuffer_appendf(buffer: *mut ImGuiTextBuffer, fmt: *const cty::c_char, ...);
}
